/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;

public final class NPathComplexityCheck
extends AbstractCheck {
    public static final String MSG_KEY = "npathComplexity";
    private static final int DEFAULT_MAX = 200;
    private static final BigInteger INITIAL_VALUE = BigInteger.ONE;
    private final Deque<BigInteger> valueStack = new ArrayDeque<BigInteger>();
    private BigInteger currentValue = INITIAL_VALUE;
    private int max = 200;

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 9, 12, 11, 84, 85, 91, 83, 92, 89, 93, 95, 96, 109};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 91: 
            case 95: 
            case 109: {
                this.visitMultiplyingConditional();
                break;
            }
            case 92: 
            case 93: 
            case 96: {
                this.visitAddingConditional();
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.visitMethodDef();
                break;
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 91: 
            case 95: 
            case 109: {
                this.leaveMultiplyingConditional();
                break;
            }
            case 92: 
            case 93: 
            case 96: {
                this.leaveAddingConditional();
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.leaveMethodDef(ast);
                break;
            }
        }
    }

    private void visitAddingConditional() {
        this.pushValue();
    }

    private void leaveAddingConditional() {
        this.currentValue = this.currentValue.subtract(BigInteger.ONE).add(this.popValue());
    }

    private void visitMultiplyingConditional() {
        this.pushValue();
    }

    private void leaveMultiplyingConditional() {
        this.currentValue = this.currentValue.add(BigInteger.ONE).multiply(this.popValue());
    }

    private void pushValue() {
        this.valueStack.push(this.currentValue);
        this.currentValue = INITIAL_VALUE;
    }

    private BigInteger popValue() {
        this.currentValue = this.valueStack.pop();
        return this.currentValue;
    }

    private void visitMethodDef() {
        this.pushValue();
    }

    private void leaveMethodDef(DetailAST ast) {
        BigInteger bigIntegerMax = BigInteger.valueOf(this.max);
        if (this.currentValue.compareTo(bigIntegerMax) > 0) {
            this.log(ast, MSG_KEY, this.currentValue, bigIntegerMax);
        }
        this.popValue();
    }
}

