/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class GetObjectDemo {
    private static String secretId = System.getenv("SECRETID");
    private static String secretKey = System.getenv("SECRETKEY");
    private static String bucketName = System.getenv("BUCKET_NAME");
    private static String region = System.getenv("REGION");
    private static COSClient cosClient = GetObjectDemo.createClient();

    public static void main(String[] args) {
        try {
            GetObjectDemo.getObjectToFileDemo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cosClient.shutdown();
        }
    }

    private static COSClient createClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        COSClient cosclient = new COSClient(cred, clientConfig);
        return cosclient;
    }

    private static void getObjectToFileDemo() {
        String key = "test/my_test.json";
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        getObjectRequest.setTrafficLimit(0x800000);
        try {
            File localFile = new File("my_test.json");
            ObjectMetadata objectMetadata = cosClient.getObject(getObjectRequest, localFile);
            System.out.println(objectMetadata.getContentLength());
        }
        catch (CosServiceException cse) {
            cse.printStackTrace();
        }
        catch (CosClientException cce) {
            cce.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getObjectInputStreamDemo() throws IOException {
        String key = "test/my_test.json";
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        COSObjectInputStream cosObjectInput = null;
        try {
            COSObject cosObject = cosClient.getObject(getObjectRequest);
            cosObjectInput = cosObject.getObjectContent();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray(cosObjectInput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ((InputStream)cosObjectInput).close();
        }
    }
}

