/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.region.Region;

public class ModifyObjectMetadataDemo {
    private static String secretId = System.getenv("SECRETID");
    private static String secretKey = System.getenv("SECRETKEY");
    private static String bucketName = System.getenv("BUCKET_NAME");
    private static String region = System.getenv("REGION");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region cosRegion = new Region(region);
        ClientConfig clientConfig = new ClientConfig(cosRegion);
        COSClient cosclient = new COSClient(cred, clientConfig);
        String key = "exampleobject";
        ObjectMetadata objectMetadata = cosclient.getObjectMetadata(bucketName, key);
        objectMetadata.setHeader("x-cos-metadata-directive", "Replaced");
        objectMetadata.setHeader("x-cos-storage-class", "STANDARD_IA");
        objectMetadata.setContentType("text/plain");
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(cosRegion, bucketName, key, bucketName, key);
        copyObjectRequest.setNewObjectMetadata(objectMetadata);
        try {
            CopyObjectResult copyObjectResult = cosclient.copyObject(copyObjectRequest);
            System.out.print(copyObjectResult.getRequestId());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        finally {
            cosclient.shutdown();
        }
    }
}

