/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobResponseV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobsRequestV2;
import com.qcloud.cos.utils.Jackson;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;

public class GeneratePlayListDemo {
    private static String appId = "123456789";
    private static String bucket = "demo-123456789";
    private static String objectKey = "test.m3u8";
    private static String expires = "3600";
    private static byte[] secret = "YourSecret".getBytes();

    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        GeneratePlayListDemo.getPlayListSimple(client);
    }

    public static void generatePlayList(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName(bucket);
        request.setTag("GeneratePlayList");
        request.getInput().setObject(objectKey);
        MediaContainerObject container = request.getOperation().getTranscode().getContainer();
        container.setFormat("hls");
        container.getClipConfig().setDuration("5");
        MediaTransConfigObject transConfig = request.getOperation().getTranscode().getTransConfig();
        transConfig.setCosTag("DemoTag=demo1&DemoTag2=demo2");
        transConfig.getHlsEncrypt().setIsHlsEncrypt("true");
        MediaTranscodeVideoObject video = request.getOperation().getTranscode().getVideo();
        video.setCodec("H.264");
        video.setWidth("1280");
        video.setHeight("960");
        request.getOperation().getOutput().setBucket("demo-1234567890");
        request.getOperation().getOutput().setRegion("ap-beijing");
        request.getOperation().getOutput().setObject("output/media/test.m3u8");
        MediaJobResponseV2 response = client.createMediaJobsV2(request);
        System.out.println(Jackson.toJsonString(response));
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName(bucket);
        request.setJobId("j8b360cd0142511efac6425779c0*****");
        MediaJobResponseV2 response = client.describeMediaJobV2(request);
        System.out.println(Jackson.toJsonString(response));
    }

    public static void getPlayList(COSClient client) {
        String bucketName = bucket;
        String key = objectKey;
        Instant now = Instant.now();
        Instant expire = now.plus(Long.parseLong(expires), ChronoUnit.SECONDS);
        Date expirationDate = Date.from(expire);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ci-process", "getplaylist");
        params.put("expires", "43200");
        HashMap<String, String> headers = new HashMap<String, String>();
        HttpMethodName method = HttpMethodName.GET;
        URL url = client.generatePresignedUrl(bucketName, key, expirationDate, method, headers, params);
        System.out.println(url.toString());
    }

    public static void getPlayListSimple(COSClient client) throws UnsupportedEncodingException {
        String bucketName = bucket;
        String key = objectKey;
        Instant now = Instant.now();
        Instant expire = now.plus(Long.parseLong(expires), ChronoUnit.SECONDS);
        Date expirationDate = Date.from(expire);
        String token = GeneratePlayListDemo.generateToken(appId, bucket, objectKey, secret, expirationDate);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ci-process", "getplaylist");
        params.put("expires", "43200");
        params.put("token-type", "JwtToken");
        params.put("token", token);
        HashMap<String, String> headers = new HashMap<String, String>();
        HttpMethodName method = HttpMethodName.GET;
        URL url = client.generatePresignedUrl(bucketName, key, expirationDate, method, headers, params);
        System.out.println(url.toString());
    }

    public static String generateToken(String appId, String bucketId, String objectKey, byte[] secret, Date expires) throws UnsupportedEncodingException {
        Instant now = Instant.now();
        String encodedObjectKey = URLEncoder.encode(objectKey, "UTF-8");
        Algorithm algorithm = Algorithm.HMAC256((byte[])secret);
        JWTCreator.Builder builder = JWT.create().withIssuer("client").withIssuedAt(Date.from(now)).withExpiresAt(expires).withClaim("Type", "CosCiToken").withClaim("AppId", appId).withClaim("BucketId", bucketId).withClaim("Object", encodedObjectKey).withClaim("Issuer", "client").withClaim("IssuedTimeStamp", Long.valueOf(now.getEpochSecond())).withClaim("ExpireTimeStamp", Long.valueOf(expires.getTime() / 1000L)).withClaim("UsageLimit", Integer.valueOf(20)).withClaim("ProtectSchema", "rsa1024").withClaim("ProtectContentKey", Integer.valueOf(0));
        return builder.sign(algorithm);
    }
}

