/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsProperty$Scope;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.Checkout$2;
import com.razorpay.CheckoutUtils;
import com.razorpay.ExternalWalletListener;
import com.razorpay.J$_0_;
import com.razorpay.L__R$;
import com.razorpay.OpinionatedSoln;
import com.razorpay.OpinionatedSoln$DismissCallback;
import com.razorpay.P$_S_;
import com.razorpay.PaymentData;
import com.razorpay.PaymentResultListener;
import com.razorpay.PaymentResultWithDataListener;
import com.razorpay.Y_$H_;
import com.razorpay.l__d$;
import com.razorpay.t;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class Checkout
extends Fragment {
    public static final int NETWORK_ERROR = 2;
    public static final int INVALID_OPTIONS = 3;
    public static final int PAYMENT_CANCELED = 0;
    public static final int TLS_ERROR = 6;
    public static final int INCOMPATIBLE_PLUGIN = 7;
    public static final int MAGICX_REQUEST_CODE = 98001;
    public static final int MAGICX_RESPONSE_CODE = 99002;
    public static final int RZP_REQUEST_CODE = 62442;
    static final int PAYMENT_SUCCESS = 1;
    static final int EXTERNAL_WALLET = 4;
    static final int INTEGRATION_ONE = 1;
    static final int INTEGRATION_TWO = 2;
    static final int INTEGRATION_THREE = 3;
    static final String EVENT_CALLBACK_DNE = "dne";
    static final String EVENT_CALLBACK_THREW_ERROR = "threw_error";
    @SuppressLint(value={"StaticFieldLeak"})
    private static WebView sPreloadView;
    private static long sPreloadCompleteDuration;
    private static long sPreloadAbortDuration;
    private static boolean sPreloadFailed;
    private String key;
    private JSONObject options;
    private Activity merchantActivity;
    private String merchantClassName;
    private boolean disableFullScreen;
    private int checkoutImage;
    private static PaymentData paymentData;
    private boolean isMethodOverridden;
    private PaymentResultListener paymentResultListenerFromClass = null;
    private PaymentResultWithDataListener paymentResultWithDataListenerFromClass = null;
    private ExternalWalletListener externalWalletListenerFromClass = null;

    @Deprecated
    public final void setPublicKey(String string) {
        this.key = string;
    }

    public final void setImage(int n2) {
        this.checkoutImage = n2;
    }

    public final void setKeyID(String string) {
        this.setPublicKey(string);
    }

    public final void setFullScreenDisable(boolean bl) {
        this.disableFullScreen = bl;
    }

    public final void open(Activity activity, JSONObject jSONObject) {
        if (OpinionatedSoln.INSTANCE.getBuildConfigValue((Context)activity, "DEBUG") != null) {
            if (!OpinionatedSoln.INSTANCE.getAlertShownForStatus()) {
                this.sdkCheckIntegrationInternal(activity, new l__d$(this, activity, jSONObject));
                return;
            }
            this.openInternal(activity, jSONObject);
            return;
        }
        this.openInternal(activity, jSONObject);
    }

    private void openInternal(Activity activity, JSONObject jSONObject) {
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            this.key = BaseUtils.getKeyId((Context)activity);
        }
        P$_S_.getAdvertisingIdFromUtil((Context)activity);
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            throw new RuntimeException("Please set your Razorpay API key in AndroidManifest.xml");
        }
        if (jSONObject == null || jSONObject.length() == 0) {
            throw new RuntimeException("Checkout options cannot be null or empty");
        }
        try {
            jSONObject.put("key", (Object)this.key);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError(jSONException.getMessage(), "S2", jSONException2.getMessage());
        }
        Checkout.abortPreloadIfRequired();
        this.options = jSONObject;
        this.merchantClassName = activity.getClass().getName();
        this.merchantActivity = activity;
        try {
            activity.getFragmentManager().beginTransaction().add((Fragment)this, null).commitAllowingStateLoss();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            AnalyticsUtil.reportError("Checkout", "S2", illegalStateException.getMessage());
            return;
        }
    }

    public static void preload(Context context) {
        sPreloadCompleteDuration = 0L;
        sPreloadAbortDuration = 0L;
        sPreloadFailed = false;
        context = context.getApplicationContext();
        sPreloadView = new WebView(context);
        BaseUtils.setWebViewSettings(context, sPreloadView, false);
        sPreloadView.setWebViewClient((WebViewClient)new Checkout$2());
        sPreloadView.setWebChromeClient((WebChromeClient)new J$_0_());
        sPreloadView.loadUrl("https://api.razorpay.com/v1/checkout/public");
    }

    private static void failPreload() {
        sPreloadFailed = true;
    }

    private static void destroyPreloadView() {
        try {
            sPreloadView.stopLoading();
        }
        catch (Exception exception) {}
        sPreloadView = null;
    }

    private static void abortPreloadIfRequired() {
        long l2 = System.nanoTime();
        try {
            if (sPreloadView != null) {
                long l3 = (Long)sPreloadView.getTag();
                sPreloadAbortDuration = l2 - l3;
                new StringBuilder("Preload aborted in ").append(BaseUtils.nanoTimeToSecondsString(sPreloadAbortDuration, 2)).append(" sec.");
            }
        }
        catch (Exception exception) {}
        Checkout.destroyPreloadView();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (this.options != null) {
            bundle = new Intent();
            bundle.setComponent(new ComponentName(this.getActivity().getPackageName(), "com.razorpay.CheckoutActivity"));
            if (sPreloadCompleteDuration > 0L) {
                bundle.putExtra("PRELOAD_COMPLETE_DURATION", sPreloadCompleteDuration);
            } else if (sPreloadAbortDuration > 0L) {
                bundle.putExtra("PRELOAD_ABORT_DURATION", sPreloadAbortDuration);
            }
            bundle.putExtra("OPTIONS", this.options.toString());
            bundle.putExtra("IMAGE", this.checkoutImage);
            bundle.putExtra("DISABLE_FULL_SCREEN", this.disableFullScreen);
            this.options = null;
            this.startActivityForResult((Intent)bundle, 62442);
        }
    }

    public void onActivityResult(int n2, int n3, Intent intent) {
        if (n2 != 62442) {
            return;
        }
        if (this.merchantActivity == null) {
            this.merchantActivity = this.getActivity();
        }
        this.merchantClassName = this.merchantActivity.getClass().getName();
        Object object = Checkout.getPaymentResult(intent);
        if (object == null || TextUtils.isEmpty((CharSequence)object)) {
            object = BaseUtils.getGenericPaymentErrorResponse("Payment Error", BaseUtils.getInstance().getMetadata());
        } else if (((String)object).contains("cancelled") && !((String)object).contains("error")) {
            object = BaseUtils.getPaymentCancelledResponse(BaseUtils.getInstance().getMetadata());
        }
        Checkout.trackOnActivityResultEvent(n3, (String)object);
        Checkout.createPaymentData(this.merchantActivity, (String)object);
        if (n3 == 1) {
            this.handleOnSuccess();
        } else if (n3 == 4) {
            this.handleExternalWalletSelected();
        } else {
            this.handleOnError(n3, (String)object);
        }
        try {
            this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commit();
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S1", ((Throwable)object).getMessage());
            return;
        }
    }

    private void handleExternalWalletSelected() {
        if (this.externalWalletListenerFromClass != null) {
            this.externalWalletListenerFromClass.onExternalWalletSelected(paymentData.getExternalWallet(), paymentData);
            return;
        }
        if (this.getActivity() instanceof ExternalWalletListener) {
            try {
                ExternalWalletListener externalWalletListener = (ExternalWalletListener)this.getActivity();
                String string = paymentData.getExternalWallet();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    externalWalletListener.onExternalWalletSelected(string, paymentData);
                    AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_EXTERNAL_WALLET_SELECTED_CALLED);
                    AnalyticsUtil.postData();
                }
                return;
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 4, EVENT_CALLBACK_THREW_ERROR, exception);
                return;
            }
        }
        Checkout.handleMerchantCallbackError(this.merchantActivity, 4, EVENT_CALLBACK_DNE, new Exception());
    }

    private void handleOnError(int n2, String string) {
        this.isMethodOverridden = true;
        this.onError(n2, string);
        if (this.isMethodOverridden) {
            Checkout.trackIntegrationType(n2, 1);
        }
    }

    private void handleOnSuccess() {
        String string = paymentData.getPaymentId();
        if (string != null) {
            this.isMethodOverridden = true;
            this.onSuccess(string);
        }
        if (this.isMethodOverridden) {
            Checkout.trackIntegrationType(1, 1);
        }
    }

    public void onSuccess(String string) {
        this.isMethodOverridden = false;
        boolean bl = this.handleOnSuccessViaInterface(string);
        if (!bl) {
            this.handleOnSuccessViaReflection(string);
        }
    }

    public void onError(int n2, String string) {
        this.isMethodOverridden = false;
        boolean bl = this.handleOnErrorViaInterface(n2, string);
        if (!bl) {
            this.handleOnErrorViaReflection(n2, string);
        }
    }

    private void handleOnErrorViaReflection(int n2, String string) {
        Method method = null;
        try {
            method = this.getMerchantClassMethod("onPaymentError", Integer.TYPE, String.class);
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, n2, EVENT_CALLBACK_DNE, exception);
        }
        try {
            this.invokeMethod(method, n2, string);
            Checkout.trackIntegrationType(n2, 2);
            return;
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
            return;
        }
    }

    private boolean handleOnErrorViaInterface(int n2, String string) {
        if (this.paymentResultListenerFromClass != null) {
            this.paymentResultListenerFromClass.onPaymentError(n2, string);
            return true;
        }
        if (this.getActivity() instanceof PaymentResultListener) {
            try {
                PaymentResultListener paymentResultListener = (PaymentResultListener)this.getActivity();
                paymentResultListener.onPaymentError(n2, string);
                Checkout.trackIntegrationType(n2, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        if (this.paymentResultWithDataListenerFromClass != null) {
            this.paymentResultWithDataListenerFromClass.onPaymentError(n2, string, paymentData);
            return true;
        }
        if (this.getActivity() instanceof PaymentResultWithDataListener) {
            try {
                PaymentResultWithDataListener paymentResultWithDataListener = (PaymentResultWithDataListener)this.getActivity();
                paymentResultWithDataListener.onPaymentError(n2, string, paymentData);
                Checkout.trackIntegrationType(n2, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        return false;
    }

    private boolean handleOnSuccessViaInterface(String string) {
        if (this.paymentResultListenerFromClass != null) {
            this.paymentResultListenerFromClass.onPaymentSuccess(string);
            return true;
        }
        if (this.getActivity() instanceof PaymentResultListener) {
            try {
                PaymentResultListener paymentResultListener = (PaymentResultListener)this.getActivity();
                paymentResultListener.onPaymentSuccess(string);
                Checkout.trackIntegrationType(1, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        if (this.paymentResultWithDataListenerFromClass != null) {
            this.paymentResultWithDataListenerFromClass.onPaymentSuccess(string, paymentData);
            return true;
        }
        if (this.getActivity() instanceof PaymentResultWithDataListener) {
            try {
                PaymentResultWithDataListener paymentResultWithDataListener = (PaymentResultWithDataListener)this.getActivity();
                paymentResultWithDataListener.onPaymentSuccess(string, paymentData);
                Checkout.trackIntegrationType(1, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        return false;
    }

    private void handleOnSuccessViaReflection(String string) {
        Method method = null;
        try {
            method = this.getMerchantClassMethod("onPaymentSuccess", String.class);
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_DNE, exception);
        }
        try {
            this.invokeMethod(method, string);
            Checkout.trackIntegrationType(1, 2);
            return;
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            return;
        }
    }

    private void invokeMethod(Method method, Object ... objectArray) {
        if (method == null) {
            return;
        }
        method.invoke((Object)this.merchantActivity, objectArray);
    }

    private Method getMerchantClassMethod(String object, Class ... classArray) {
        Class<?> clazz = Class.forName(this.merchantClassName);
        object = clazz.getMethod((String)object, classArray);
        return object;
    }

    private static void trackIntegrationType(int n2, int n3) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("integration_type", Integer.toString(n3));
            if (n2 == 1) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_ON_SUCCESS_CALLED, AnalyticsUtil.getJSONResponse(hashMap));
            } else {
                AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_ON_ERROR_CALLED, AnalyticsUtil.getJSONResponse(hashMap));
            }
            AnalyticsUtil.postData();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", exception2.getMessage());
            return;
        }
    }

    private static void trackOnActivityResultEvent(int n2, String string) {
        try {
            AnalyticsUtil.addProperty("onActivityResult result", new AnalyticsProperty(string, AnalyticsProperty$Scope.ORDER));
            AnalyticsUtil.addProperty("onActivityResult resultCode", new AnalyticsProperty(String.valueOf(n2), AnalyticsProperty$Scope.ORDER));
            if (n2 == 1) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_ON_SUCCESS);
            } else if (n2 == 4) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_EXTERNAL_WALLET_SELECTED);
            } else {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_ON_ERROR);
            }
            AnalyticsUtil.postData();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", exception2.getMessage());
            return;
        }
    }

    private static void handleMerchantCallbackError(Activity activity, int n2, String string, Exception exception) {
        String string2;
        String string3;
        if (n2 == 1) {
            string3 = "onPaymentSuccess";
            string2 = "success";
        } else if (n2 == 4) {
            string3 = "onExternalWalletSelected";
            string2 = "redirected";
        } else {
            string3 = "onPaymentError";
            string2 = "error";
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("event_details", exception.getMessage());
            hashMap.put("event_type", exception.getMessage());
            hashMap.put("payment_status", string2);
            AnalyticsUtil.trackEvent(AnalyticsEvent.HANDOVER_ERROR, AnalyticsUtil.getJSONResponse(hashMap));
            AnalyticsUtil.postData();
        }
        catch (Exception exception2) {
            Exception exception3 = exception2;
            AnalyticsUtil.reportError(exception2.getMessage(), "S0", exception3.getMessage());
        }
        if (string.equals(EVENT_CALLBACK_DNE)) {
            if (n2 == 4) {
                Toast.makeText((Context)activity, (CharSequence)"Error: ExternalWalletListener probably not implemented in your activity", (int)0).show();
                return;
            }
            Toast.makeText((Context)activity, (CharSequence)("Error: " + string3 + " probably not implemented in your activity"), (int)0).show();
            return;
        }
        if (string.equals(EVENT_CALLBACK_THREW_ERROR)) {
            Toast.makeText((Context)activity, (CharSequence)("Your " + string3 + " method is throwing an error. Wrap the entire code of the method inside a try catch."), (int)0).show();
        }
    }

    private static void createPaymentData(Activity activity, String string) {
        paymentData = new PaymentData();
        Activity activity2 = activity;
        paymentData.setUserContact(t.a((Context)activity2, "rzp_user_contact", null));
        activity2 = activity;
        paymentData.setUserEmail(t.a((Context)activity2, "rzp_user_email", null));
        try {
            activity = new JSONObject(string);
            if (activity.optJSONObject("error") != null) {
                activity2 = new JSONObject();
                activity2.put("error", (Object)activity.getJSONObject("error"));
                JSONObject jSONObject = activity.getJSONObject("error").getJSONObject("metadata");
                if (jSONObject.has("payment_id")) {
                    paymentData.setPaymentId(jSONObject.getString("payment_id"));
                }
                if (jSONObject.has("order_id")) {
                    paymentData.setOrderId(jSONObject.getString("order_id"));
                }
                paymentData.setData((JSONObject)activity2);
            } else {
                paymentData.setData((JSONObject)activity);
            }
            if (activity.has("razorpay_payment_id")) {
                paymentData.setPaymentId(activity.getString("razorpay_payment_id"));
            }
            if (activity.has("razorpay_order_id")) {
                paymentData.setOrderId(activity.getString("razorpay_order_id"));
            }
            if (activity.has("razorpay_signature")) {
                paymentData.setSignature(activity.getString("razorpay_signature"));
            }
            if (activity.has("external_wallet")) {
                paymentData.setExternalWallet(activity.getString("external_wallet"));
            }
            return;
        }
        catch (JSONException jSONException) {
            activity2 = new JSONObject();
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("code", (Object)"RESPONSE");
                jSONObject.put("description", (Object)string);
                activity2.put("error", (Object)jSONObject);
            }
            catch (JSONException jSONException2) {}
            AnalyticsUtil.reportError(jSONException.getMessage(), "S2", jSONException.getMessage());
            return;
        }
    }

    @Deprecated
    public static void handleActivityResult(Activity activity, int n2, int n3, Intent intent, PaymentResultWithDataListener paymentResultWithDataListener, ExternalWalletListener externalWalletListener) {
        if (n2 != 62442) {
            return;
        }
        String string = Checkout.getPaymentResult(intent);
        if (string == null || TextUtils.isEmpty((CharSequence)string)) {
            string = BaseUtils.getGenericPaymentErrorResponse("Payment Error", BaseUtils.getInstance().getMetadata());
        } else if (string.contains("cancelled") && !string.contains("error")) {
            string = BaseUtils.getPaymentCancelledResponse(BaseUtils.getInstance().getMetadata());
        }
        Checkout.trackOnActivityResultEvent(n3, string);
        Checkout.createPaymentData(activity, string);
        if (n3 == 1) {
            try {
                string = paymentData.getPaymentId();
                paymentResultWithDataListener.onPaymentSuccess(string, paymentData);
                return;
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(activity, n3, EVENT_CALLBACK_THREW_ERROR, exception);
                return;
            }
        }
        if (n3 == 4) {
            if (externalWalletListener != null) {
                try {
                    externalWalletListener.onExternalWalletSelected(paymentData.getExternalWallet(), paymentData);
                    return;
                }
                catch (Exception exception) {
                    Checkout.handleMerchantCallbackError(activity, n3, EVENT_CALLBACK_THREW_ERROR, exception);
                    return;
                }
            }
        } else {
            try {
                paymentResultWithDataListener.onPaymentError(n3, string, paymentData);
                return;
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(activity, n3, EVENT_CALLBACK_THREW_ERROR, exception);
            }
        }
    }

    public void merchantActivityResult(Activity activity, int n2, int n3, Intent intent, PaymentResultWithDataListener paymentResultWithDataListener, ExternalWalletListener externalWalletListener) {
        this.merchantActivity = activity;
        this.paymentResultWithDataListenerFromClass = paymentResultWithDataListener;
        this.externalWalletListenerFromClass = externalWalletListener;
        this.onActivityResult(n2, n3, intent);
    }

    public void merchantActivityResult(Activity activity, int n2, int n3, Intent intent, PaymentResultListener paymentResultListener, ExternalWalletListener externalWalletListener) {
        this.merchantActivity = activity;
        this.paymentResultListenerFromClass = paymentResultListener;
        this.externalWalletListenerFromClass = externalWalletListener;
        this.onActivityResult(n2, n3, intent);
    }

    public static void clearUserData(Context context) {
        CheckoutUtils.b(context, null);
        CheckoutUtils.a(context, null);
        L__R$.a(context, null);
        context = CookieManager.getInstance();
        context.setCookie("https://api.razorpay.com", "razorpay_api_session=");
        WebStorage.getInstance().deleteAllData();
        if (Build.VERSION.SDK_INT >= 21) {
            context.removeSessionCookies((ValueCallback)new Y_$H_());
            return;
        }
        context.removeAllCookie();
    }

    private static String getPaymentResult(Intent intent) {
        if (intent != null && (intent = intent.getExtras()) != null) {
            return intent.getString("RESULT");
        }
        return null;
    }

    public static void sdkCheckIntegration(Activity activity) {
        OpinionatedSoln.INSTANCE.integrationStatusCheck(activity);
    }

    private void sdkCheckIntegrationInternal(Activity activity, OpinionatedSoln$DismissCallback opinionatedSoln$DismissCallback) {
        OpinionatedSoln.INSTANCE.integrationStatusCheck(activity, opinionatedSoln$DismissCallback);
    }

    public String builderTest() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("key", (Object)this.key);
            jSONObject.put("image", this.checkoutImage);
            jSONObject.put("disableFullScreen", this.disableFullScreen);
        }
        catch (JSONException jSONException) {}
        return jSONObject.toString();
    }

    static /* synthetic */ void access$000(Checkout checkout, Activity activity, JSONObject jSONObject) {
        checkout.openInternal(activity, jSONObject);
    }

    static /* synthetic */ WebView access$100() {
        return sPreloadView;
    }

    static /* synthetic */ void access$200() {
        Checkout.failPreload();
    }

    static /* synthetic */ boolean access$300() {
        return sPreloadFailed;
    }

    static /* synthetic */ long access$402(long l2) {
        sPreloadCompleteDuration = l2;
        return sPreloadCompleteDuration;
    }

    static /* synthetic */ long access$400() {
        return sPreloadCompleteDuration;
    }

    static /* synthetic */ void access$500() {
        Checkout.destroyPreloadView();
    }
}

