/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import com.google.android.apps.nbu.paisa.inapp.client.api.PaymentsClient;
import com.google.android.apps.nbu.paisa.inapp.client.api.Wallet;
import com.google.android.apps.nbu.paisa.inapp.client.api.WalletUtils;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.RzpGpayUtilMerged;
import com.razorpay.RzpInternalCallback;
import com.razorpay.RzpPlugin;
import com.razorpay.RzpPluginCompatibilityResponse;
import com.razorpay.RzpPluginRegisterCallback;
import com.razorpay.a;
import com.razorpay.p;
import com.razorpay.q;
import com.razorpay.r;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

class RzpGpayMerged
implements OnCompleteListener<Boolean>,
RzpPlugin {
    private PaymentsClient mPaymentClient;
    private static int LOAD_PAYMENT_DATA_REQUEST_CODE = 1;
    private RzpInternalCallback rzpInternalCallback;
    private JSONObject apiResponse;
    private boolean isUpiOnly = false;
    private Task<Boolean> cardsTask = null;
    private Task<Boolean> upiTask = null;
    private RzpPluginRegisterCallback registerCallback;

    RzpGpayMerged() {
    }

    @Override
    public RzpPluginCompatibilityResponse isCompatible(String string, int n2, String string2) {
        if (string.equalsIgnoreCase("custom") && n2 > 27) {
            return new RzpPluginCompatibilityResponse(true, null);
        }
        if (string.equalsIgnoreCase("standard") && n2 > 18) {
            return new RzpPluginCompatibilityResponse(true, null);
        }
        string = string.equalsIgnoreCase("custom") ? "Razorpay's GooglePay plugin requires a min SDK Version 3.8.8 Please update." : (string.equalsIgnoreCase("standard") ? "Razorpay's GooglePay plugin requires a min SDK Version 1.5.6 Please update." : "Incompatible Razorpay sdk version. Please update the base sdk");
        return new RzpPluginCompatibilityResponse(false, string);
    }

    @Override
    public boolean doesHandlePayload(String string, JSONObject jSONObject, Activity activity) {
        try {
            if (jSONObject != null && jSONObject.has("method") && jSONObject.getString("method").equalsIgnoreCase("upi") && jSONObject.getString("_[app]").equalsIgnoreCase("com.google.android.apps.nbu.paisa.user")) {
                return true;
            }
            if (jSONObject != null && jSONObject.has("type") && jSONObject.getString("type").equalsIgnoreCase("application") && jSONObject.getString("application_name").equalsIgnoreCase("google_pay")) {
                return true;
            }
        }
        catch (JSONException jSONException) {
            return false;
        }
        return false;
    }

    @Override
    public void processPayment(String object, JSONObject jSONObject, Activity activity, RzpInternalCallback rzpInternalCallback) {
        try {
            this.rzpInternalCallback = rzpInternalCallback;
            this.mPaymentClient = Wallet.getPaymentsClient();
            if (jSONObject.has("type") && jSONObject.getString("type").equalsIgnoreCase("application")) {
                this.apiResponse = jSONObject;
                object = jSONObject.getJSONObject("request").getJSONArray("content").getJSONObject(0);
                try {
                    AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PROCESS_PAYMENT_CARDS_UPI_CALLED);
                    this.mPaymentClient.loadPaymentData(activity, object.toString(), LOAD_PAYMENT_DATA_REQUEST_CODE);
                    return;
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(this.getClass().getName(), "S0", exception.getMessage());
                    this.genericOnPaymentFailure("BAD_REQUEST", 1, "An internal error has occurred");
                    return;
                }
            }
            if (jSONObject.has("url_data")) {
                this.isUpiOnly = true;
                try {
                    object = jSONObject.get("url_data").toString();
                    try {
                        this.apiResponse = RzpGpayUtilMerged.getUpiData((String)object);
                        AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PROCESS_PAYMENT_CUSTOMUI_CALLED);
                        this.mPaymentClient.loadPaymentData(activity, RzpGpayUtilMerged.getPaymentRequestData((String)object, jSONObject), LOAD_PAYMENT_DATA_REQUEST_CODE);
                    }
                    catch (Exception exception) {
                        this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "An internal error has occurred");
                        return;
                    }
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(this.getClass().getName(), "error:exception", exception.getMessage());
                    this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "An internal error has occurred");
                }
                return;
            }
            object = new HashMap<String, String>();
            object.put("Content-Type", "application/x-www-form-urlencoded");
            a.a("https://api.razorpay.com/v1/payments/create/ajax", RzpGpayUtilMerged.makeApiPayload(jSONObject), (Map<String, String>)object, new p(this, activity, jSONObject));
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(this.getClass().getName(), "error:exception", exception.getMessage());
            this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "An internal error has occurred.");
            return;
        }
    }

    @Override
    public void onActivityResult(String string, int n2, int n3, Intent intent) {
        if (n2 == LOAD_PAYMENT_DATA_REQUEST_CODE) {
            switch (n3) {
                case -1: {
                    AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PAYMENT_CALLBACK_SUCCESS);
                    string = WalletUtils.getPaymentDataFromIntent((Intent)intent);
                    this.processPaymentResponse(string);
                    return;
                }
                case 1: {
                    int n4 = intent.getIntExtra("errorCode", 8);
                    this.handleResultStatusCode(n4);
                    return;
                }
                case 0: {
                    AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PAYMENT_CALLBACK_CANCELLED);
                    this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 0, "Payment canceled.");
                }
            }
        }
    }

    private void handleResultStatusCode(int n2) {
        switch (n2) {
            case 409: {
                this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "There is a problem with your Google Pay account.");
                return;
            }
            case 405: {
                this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "There is a problem with merchant's account.");
                return;
            }
        }
        this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "An internal error has occurred");
    }

    @Override
    public void isRegistered(Context context, RzpPluginRegisterCallback rzpPluginRegisterCallback) {
        this.registerCallback = rzpPluginRegisterCallback;
        AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_CHECK_REGISTER_CALLED);
        try {
            this.mPaymentClient = Wallet.getPaymentsClient();
            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PAYMENT_IS_REGISTERED_CALLED);
            this.upiTask = this.mPaymentClient.isReadyToPay(context, Objects.requireNonNull(RzpGpayUtilMerged.getIsReadyToPayRequest()).toString());
            this.cardsTask = this.mPaymentClient.isReadyToPay(context, Objects.requireNonNull(RzpGpayUtilMerged.getCardsIsReadyToPayRequest()).toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AnalyticsUtil.reportError(this.getClass().getName(), "error:exception", noSuchAlgorithmException.getMessage());
        }
        Objects.requireNonNull(this.cardsTask).addOnCompleteListener((OnCompleteListener)this);
        Objects.requireNonNull(this.upiTask).addOnCompleteListener((OnCompleteListener)this);
    }

    @Override
    public void isRegistered(Context context) {
        Task task = null;
        Task task2 = null;
        this.mPaymentClient = Wallet.getPaymentsClient();
        AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_CHECK_REGISTER_CALLED);
        try {
            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PAYMENT_IS_REGISTERED_CALLED);
            task = this.mPaymentClient.isReadyToPay(context, Objects.requireNonNull(RzpGpayUtilMerged.getIsReadyToPayRequest()).toString());
            task2 = this.mPaymentClient.isReadyToPay(context, Objects.requireNonNull(RzpGpayUtilMerged.getCardsIsReadyToPayRequest()).toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AnalyticsUtil.reportError(this.getClass().getName(), "error:exception", noSuchAlgorithmException.getMessage());
        }
        ((Task)Objects.requireNonNull(task2)).addOnCompleteListener((OnCompleteListener)new q(this));
        Objects.requireNonNull(task).addOnCompleteListener((OnCompleteListener)new r(this));
    }

    private void processPaymentResponse(String string) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_VERIFY_PAYMENT_CALLED);
        if (RzpGpayMerged.verifyPaymentResponse(string)) {
            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_VERIFY_PAYMENT_SUCCESS_CALLED);
            this.genericOnPaymentSuccess();
            return;
        }
        AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_VERIFY_PAYMENT_ERROR_CALLED);
        this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "Payment was not successful.");
    }

    private static boolean verifyPaymentResponse(String string) {
        try {
            string = new JSONObject(string);
            string = string.getJSONObject("paymentMethodData").getJSONObject("tokenizationData").getString("token");
            string = new JSONObject(string);
            string = new JSONObject(string.getString("signedMessage"));
            string = string.getJSONObject("paymentMethodDetails").getString("status");
            return string.equals("SUCCESS");
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_VERIFY_PAYMENT_EXCEPTION);
            return false;
        }
    }

    private void genericOnPaymentSuccess() {
        if (this.isUpiOnly) {
            this.rzpInternalCallback.onPaymentSuccess(RzpGpayUtilMerged.makeExternalSDKPayload(this.apiResponse));
            return;
        }
        this.rzpInternalCallback.onPaymentSuccess(RzpGpayUtilMerged.makeMergedExternalSDKPayload(this.apiResponse));
    }

    private void genericOnPaymentFailure(String string, int n2, String string2) {
        if (this.isUpiOnly) {
            this.rzpInternalCallback.onPaymentError(5, RzpGpayUtilMerged.makeErrorPayload(string, string2));
            return;
        }
        this.rzpInternalCallback.onPaymentError(5, RzpGpayUtilMerged.makeMergedExternalSDKErrorPayload(this.apiResponse, n2, string2));
    }

    public void onComplete(@NonNull Task<Boolean> task) {
        boolean bl = (Boolean)task.getResult();
        if (task.equals(this.cardsTask)) {
            BaseUtils.setIsGpayCardsUpiRegistered(bl);
            this.registerCallback.onResponse(bl);
            return;
        }
        BaseUtils.setCompatibleWithGooglePay(bl);
    }

    public void setIsUpiOnly(boolean bl) {
        this.isUpiOnly = bl;
    }

    public void setRzpInternalCallback(RzpInternalCallback rzpInternalCallback) {
        this.rzpInternalCallback = rzpInternalCallback;
    }

    public void setApiResponse(JSONObject jSONObject) {
        this.apiResponse = jSONObject;
    }

    static /* synthetic */ boolean access$002(RzpGpayMerged rzpGpayMerged, boolean bl) {
        rzpGpayMerged.isUpiOnly = bl;
        return rzpGpayMerged.isUpiOnly;
    }

    static /* synthetic */ JSONObject access$102(RzpGpayMerged rzpGpayMerged, JSONObject jSONObject) {
        rzpGpayMerged.apiResponse = jSONObject;
        return rzpGpayMerged.apiResponse;
    }

    static /* synthetic */ void access$200(RzpGpayMerged rzpGpayMerged, String string, int n2, String string2) {
        rzpGpayMerged.genericOnPaymentFailure(string, n2, string2);
    }

    static /* synthetic */ int access$300() {
        return LOAD_PAYMENT_DATA_REQUEST_CODE;
    }

    static /* synthetic */ PaymentsClient access$400(RzpGpayMerged rzpGpayMerged) {
        return rzpGpayMerged.mPaymentClient;
    }
}

