/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.spotify.docker.client.EventReader;
import com.spotify.docker.client.messages.Event;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStream
extends AbstractIterator<Event>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(EventStream.class);
    private final EventReader reader;
    private volatile boolean closed;

    EventStream(CloseableHttpResponse response, ObjectMapper objectMapper) {
        this.reader = new EventReader(response, objectMapper);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            log.warn(this + " not closed properly");
            this.close();
        }
    }

    protected Event computeNext() {
        Event event;
        try {
            event = this.reader.nextMessage();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (event == null) {
            return (Event)this.endOfData();
        }
        return event;
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

