/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init.ui;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.BaseCustomization;
import com.stripe.android.stripe3ds2.init.ui.ButtonCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.stripe3ds2.utils.ObjectUtils;

public final class StripeButtonCustomization
extends BaseCustomization
implements ButtonCustomization,
Parcelable {
    public static final Parcelable.Creator<StripeButtonCustomization> CREATOR = new Parcelable.Creator<StripeButtonCustomization>(){

        public StripeButtonCustomization createFromParcel(Parcel in) {
            return new StripeButtonCustomization(in);
        }

        public StripeButtonCustomization[] newArray(int size) {
            return new StripeButtonCustomization[size];
        }
    };
    @Nullable
    private String mBackgroundColor;
    private int mCornerRadius;

    public StripeButtonCustomization() {
    }

    private StripeButtonCustomization(@NonNull Parcel in) {
        super(in);
        this.mBackgroundColor = in.readString();
        this.mCornerRadius = in.readInt();
    }

    @Override
    public void setBackgroundColor(@NonNull String hexColorCode) throws InvalidInputException {
        this.mBackgroundColor = CustomizeUtils.requireValidColor(hexColorCode);
    }

    @Override
    public void setCornerRadius(int cornerRadius) throws InvalidInputException {
        this.mCornerRadius = CustomizeUtils.requireValidDimension(cornerRadius);
    }

    @Override
    @Nullable
    public String getBackgroundColor() {
        return this.mBackgroundColor;
    }

    @Override
    public int getCornerRadius() {
        return this.mCornerRadius;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof StripeButtonCustomization && this.typedEquals((StripeButtonCustomization)obj);
    }

    private boolean typedEquals(@NonNull StripeButtonCustomization buttonCustomization) {
        return ObjectUtils.equals(this.mBackgroundColor, buttonCustomization.mBackgroundColor) && this.mCornerRadius == buttonCustomization.mCornerRadius;
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mBackgroundColor, this.mCornerRadius);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mBackgroundColor);
        dest.writeInt(this.mCornerRadius);
    }
}

