/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import android.os.Parcel;
import android.os.Parcelable;
import com.stripe.android.stripe3ds2.transactions.ErrorData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u000f\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0010\u001a\u00020\tH\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\tH\u00d6\u0001J\u0019\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/RuntimeErrorEvent;", "Landroid/os/Parcelable;", "throwable", "", "(Ljava/lang/Throwable;)V", "errorData", "Lcom/stripe/android/stripe3ds2/transactions/ErrorData;", "(Lcom/stripe/android/stripe3ds2/transactions/ErrorData;)V", "errorCode", "", "errorMessage", "(Ljava/lang/String;Ljava/lang/String;)V", "getErrorCode", "()Ljava/lang/String;", "getErrorMessage", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "3ds2sdk_release"})
@Parcelize
public final class RuntimeErrorEvent
implements Parcelable {
    @NotNull
    private final String errorCode;
    @NotNull
    private final String errorMessage;
    @NotNull
    public static final Parcelable.Creator<RuntimeErrorEvent> CREATOR;

    public RuntimeErrorEvent(@NotNull String errorCode, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @NotNull
    public final String getErrorCode() {
        return this.errorCode;
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public RuntimeErrorEvent(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        String string2 = throwable.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        String string3 = throwable.getMessage();
        if (string3 == null) {
            string3 = "";
        }
        this(string2, string3);
    }

    public RuntimeErrorEvent(@NotNull ErrorData errorData) {
        Intrinsics.checkNotNullParameter((Object)errorData, (String)"errorData");
        this(errorData.getErrorCode(), errorData.getErrorDetail());
    }

    @NotNull
    public final String component1() {
        return this.errorCode;
    }

    @NotNull
    public final String component2() {
        return this.errorMessage;
    }

    @NotNull
    public final RuntimeErrorEvent copy(@NotNull String errorCode, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return new RuntimeErrorEvent(errorCode, errorMessage);
    }

    public static /* synthetic */ RuntimeErrorEvent copy$default(RuntimeErrorEvent runtimeErrorEvent, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = runtimeErrorEvent.errorCode;
        }
        if ((n & 2) != 0) {
            string3 = runtimeErrorEvent.errorMessage;
        }
        return runtimeErrorEvent.copy(string2, string3);
    }

    @NotNull
    public String toString() {
        return "RuntimeErrorEvent(errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ")";
    }

    public int hashCode() {
        int result = this.errorCode.hashCode();
        result = result * 31 + this.errorMessage.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RuntimeErrorEvent)) {
            return false;
        }
        RuntimeErrorEvent runtimeErrorEvent = (RuntimeErrorEvent)other;
        if (!Intrinsics.areEqual((Object)this.errorCode, (Object)runtimeErrorEvent.errorCode)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.errorMessage, (Object)runtimeErrorEvent.errorMessage);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.errorCode);
        out.writeString(this.errorMessage);
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<RuntimeErrorEvent> {
            @NotNull
            public final RuntimeErrorEvent[] newArray(int size) {
                return new RuntimeErrorEvent[size];
            }

            @NotNull
            public final RuntimeErrorEvent createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new RuntimeErrorEvent(parcel.readString(), parcel.readString());
            }
        }
        CREATOR = new Creator();
    }
}

