/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.header;

import com.sun.jersey.core.header.reader.HttpHeaderReader;
import com.sun.jersey.core.impl.provider.header.WriterUtil;
import com.sun.jersey.spi.HeaderDelegateProvider;
import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeProvider
implements HeaderDelegateProvider<MediaType> {
    @Override
    public boolean supports(Class<?> type) {
        return MediaType.class.isAssignableFrom(type);
    }

    public String toString(MediaType header) {
        StringBuilder b = new StringBuilder();
        b.append(header.getType()).append('/').append(header.getSubtype());
        for (Map.Entry e : header.getParameters().entrySet()) {
            b.append(';').append((String)e.getKey()).append('=');
            WriterUtil.appendQuotedMediaType(b, (String)e.getValue());
        }
        return b.toString();
    }

    public MediaType fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException("Media type is null");
        }
        try {
            HttpHeaderReader reader = HttpHeaderReader.newInstance(header);
            reader.hasNext();
            String type = reader.nextToken();
            reader.nextSeparator('/');
            String subType = reader.nextToken();
            Map<String, String> params = null;
            if (reader.hasNext()) {
                params = HttpHeaderReader.readParameters(reader);
            }
            return new MediaType(type, subType, params);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Error parsing media type '" + header + "'", ex);
        }
    }
}

