/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.wadl.config;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.wadl.config.WadlGeneratorConfig;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.jersey.server.wadl.WadlGeneratorImpl;
import java.util.logging.Logger;

public class WadlGeneratorConfigLoader {
    private static final Logger LOGGER = Logger.getLogger(WadlGeneratorConfigLoader.class.getName());

    public static WadlGenerator loadWadlGeneratorsFromConfig(ResourceConfig resourceConfig) {
        Object wadlGeneratorConfigProperty = resourceConfig.getProperty("com.sun.jersey.config.property.WadlGeneratorConfig");
        if (wadlGeneratorConfigProperty == null) {
            WadlGeneratorImpl wadlGenerator = new WadlGeneratorImpl();
            try {
                wadlGenerator.init();
                return wadlGenerator;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not init the " + wadlGenerator.getClass().getName(), e);
            }
        }
        try {
            Class<WadlGeneratorConfig> configClazz;
            if (wadlGeneratorConfigProperty instanceof WadlGeneratorConfig) {
                return ((WadlGeneratorConfig)wadlGeneratorConfigProperty).getWadlGenerator();
            }
            if (wadlGeneratorConfigProperty instanceof Class) {
                configClazz = ((Class)wadlGeneratorConfigProperty).asSubclass(WadlGeneratorConfig.class);
            } else if (wadlGeneratorConfigProperty instanceof String) {
                configClazz = ReflectionHelper.classForNameWithException((String)((String)wadlGeneratorConfigProperty)).asSubclass(WadlGeneratorConfig.class);
            } else {
                throw new RuntimeException("The property com.sun.jersey.config.property.WadlGeneratorConfig is an invalid type: " + wadlGeneratorConfigProperty.getClass().getName() + " (supported: String, Class<? extends WadlGeneratorConfiguration>," + " WadlGeneratorConfiguration)");
            }
            WadlGeneratorConfig config = configClazz.newInstance();
            return config.getWadlGenerator();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load WadlGeneratorConfiguration, check the configuration of com.sun.jersey.config.property.WadlGeneratorConfig", e);
        }
    }
}

