/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.webservice.member;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.developer.StatefulWebServiceManager;
import com.sun.xml.ws.tx.common.AddressManager;
import com.sun.xml.ws.tx.common.StatefulWebserviceFactory;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.webservice.member.LocalizationMessages;
import com.sun.xml.ws.tx.webservice.member.at.CoordinatorPortType;
import com.sun.xml.ws.tx.webservice.member.at.CoordinatorPortTypeImpl;
import com.sun.xml.ws.tx.webservice.member.at.ParticipantPortType;
import com.sun.xml.ws.tx.webservice.member.at.ParticipantPortTypeImpl;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationCoordinatorPortType;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationCoordinatorPortTypeImpl;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationRequesterPortType;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationRequesterPortTypeImpl;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.ws.EndpointReference;

public final class TXStatefulWebserviceFactoryImpl
implements StatefulWebserviceFactory {
    private static final TxLogger logger = TxLogger.getLogger(TXStatefulWebserviceFactoryImpl.class);
    private static boolean registeredFallback = false;
    private static boolean wstxServiceAvailable = false;
    private boolean pingServices = true;

    @NotNull
    public StatefulWebServiceManager getManager(@NotNull String serviceName, @NotNull String portName) {
        this.registerFallback();
        if (serviceName.equals("WSATCoordinator")) {
            if (portName.equals("Participant")) {
                return ParticipantPortTypeImpl.getManager();
            }
            if (portName.equals("Coordinator")) {
                return CoordinatorPortTypeImpl.getManager();
            }
            throw new IllegalStateException(LocalizationMessages.WSTX_SERVICE_PORT_NOT_FOUND_5001(portName, serviceName));
        }
        if (serviceName.equals("Coordinator")) {
            if (portName.equals("RegistrationRequester")) {
                return RegistrationRequesterPortTypeImpl.getManager();
            }
            if (portName.equals("RegistrationCoordinator")) {
                return RegistrationCoordinatorPortTypeImpl.getManager();
            }
            throw new IllegalStateException(LocalizationMessages.WSTX_SERVICE_PORT_NOT_FOUND_5001(portName, serviceName));
        }
        throw new IllegalStateException(LocalizationMessages.WSTX_SERVICE_PORT_NOT_FOUND_5001(portName, serviceName));
    }

    @NotNull
    public EndpointReference createService(@NotNull String serviceName, @NotNull String portName, @NotNull URI address, @NotNull AddressingVersion addressingVersion, @NotNull String activityId, @NotNull String registrantId, long timeoutInMillis) {
        timeoutInMillis = (long)((double)timeoutInMillis * 1.25);
        this.registerFallback();
        if (serviceName.equals("WSATCoordinator")) {
            if (portName.equals("Participant")) {
                ParticipantPortTypeImpl participant = new ParticipantPortTypeImpl(activityId, registrantId);
                StatefulWebServiceManager<ParticipantPortTypeImpl> statefulWebServiceManager = ParticipantPortTypeImpl.getManager();
                statefulWebServiceManager.setTimeout(timeoutInMillis, null);
                return statefulWebServiceManager.export(addressingVersion.eprType.eprClass, address.toString(), (Object)participant);
            }
            if (portName.equals("Coordinator")) {
                CoordinatorPortTypeImpl coordinator = new CoordinatorPortTypeImpl(activityId, registrantId);
                StatefulWebServiceManager<CoordinatorPortTypeImpl> statefulWebServiceManager = CoordinatorPortTypeImpl.getManager();
                statefulWebServiceManager.setTimeout(timeoutInMillis, null);
                return statefulWebServiceManager.export(addressingVersion.eprType.eprClass, address.toString(), (Object)coordinator);
            }
            throw new IllegalStateException(LocalizationMessages.WSTX_SERVICE_PORT_NOT_FOUND_5001(portName, serviceName));
        }
        if (serviceName.equals("Coordinator")) {
            if (portName.equals("RegistrationRequester")) {
                RegistrationRequesterPortTypeImpl registrationRequester = new RegistrationRequesterPortTypeImpl(activityId, registrantId);
                StatefulWebServiceManager<RegistrationRequesterPortTypeImpl> statefulWebServiceManager = RegistrationRequesterPortTypeImpl.getManager();
                statefulWebServiceManager.setTimeout(timeoutInMillis, null);
                return statefulWebServiceManager.export(addressingVersion.eprType.eprClass, address.toString(), (Object)registrationRequester);
            }
            if (portName.equals("RegistrationCoordinator")) {
                RegistrationCoordinatorPortTypeImpl registrationCoordinator = new RegistrationCoordinatorPortTypeImpl(activityId);
                StatefulWebServiceManager<RegistrationCoordinatorPortTypeImpl> statefulWebServiceManager = RegistrationCoordinatorPortTypeImpl.getManager();
                statefulWebServiceManager.setTimeout(timeoutInMillis, null);
                return statefulWebServiceManager.export(addressingVersion.eprType.eprClass, address.toString(), (Object)registrationCoordinator);
            }
            throw new IllegalStateException(LocalizationMessages.WSTX_SERVICE_PORT_NOT_FOUND_5001(portName, serviceName));
        }
        throw new IllegalStateException(LocalizationMessages.WSTX_SERVICE_PORT_NOT_FOUND_5001(portName, serviceName));
    }

    public boolean isWSTXServiceAvailable() {
        this.registerFallback();
        return wstxServiceAvailable;
    }

    private void registerFallback() {
        if (!registeredFallback) {
            registeredFallback = true;
            this.pingStatefulServices();
            if (this.isWSTXServiceAvailable()) {
                ParticipantPortTypeImpl participant = new ParticipantPortTypeImpl("-1", "-1");
                if (ParticipantPortTypeImpl.getManager() != null) {
                    ParticipantPortTypeImpl.getManager().setFallbackInstance((Object)participant);
                } else {
                    wstxServiceAvailable = false;
                }
                CoordinatorPortTypeImpl coordinator = new CoordinatorPortTypeImpl("-1", "-1");
                if (CoordinatorPortTypeImpl.getManager() != null) {
                    CoordinatorPortTypeImpl.getManager().setFallbackInstance((Object)coordinator);
                } else {
                    wstxServiceAvailable = false;
                }
                RegistrationRequesterPortTypeImpl registrationRequester = new RegistrationRequesterPortTypeImpl("-1", "-1");
                if (RegistrationRequesterPortTypeImpl.getManager() != null) {
                    RegistrationRequesterPortTypeImpl.getManager().setFallbackInstance((Object)registrationRequester);
                } else {
                    wstxServiceAvailable = false;
                }
                RegistrationCoordinatorPortTypeImpl registrationCoordinator = new RegistrationCoordinatorPortTypeImpl("-1");
                if (RegistrationCoordinatorPortTypeImpl.getManager() != null) {
                    RegistrationCoordinatorPortTypeImpl.getManager().setFallbackInstance((Object)registrationCoordinator);
                } else {
                    wstxServiceAvailable = false;
                }
            } else {
                registeredFallback = false;
            }
        }
    }

    private void pingStatefulServices() {
        if (this.pingServices) {
            this.pingServices = false;
            wstxServiceAvailable = true;
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("pingStatefulServices", "pinging register service...");
            }
            this.pingService(AddressManager.getAddress(RegistrationCoordinatorPortType.class, false).toString() + "?wsdl", RegistrationCoordinatorPortTypeImpl.class);
            if (!wstxServiceAvailable) {
                return;
            }
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("pingStatefulServices", "pinging registerResponse service...");
            }
            this.pingService(AddressManager.getAddress(RegistrationRequesterPortType.class, false).toString() + "?wsdl", RegistrationRequesterPortTypeImpl.class);
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("pingStatefulServices", "pinging ATCoordinator service...");
            }
            this.pingService(AddressManager.getAddress(CoordinatorPortType.class, false).toString() + "?wsdl", CoordinatorPortTypeImpl.class);
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("pingStatefulServices", "pinging ATParticipant service...");
            }
            this.pingService(AddressManager.getAddress(ParticipantPortType.class, false).toString() + "?wsdl", ParticipantPortTypeImpl.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingService(String urlAddr, Class sws) {
        String METHOD = "pingService";
        HttpURLConnection conn = null;
        InputStream response = null;
        BufferedReader reader = null;
        try {
            URL url = new URL(urlAddr);
            conn = (HttpURLConnection)url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String string, SSLSession sSLSession) {
                        return true;
                    }
                });
            }
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.connect();
            response = conn.getInputStream();
            reader = new BufferedReader(new InputStreamReader(response));
            String line = reader.readLine();
            while (line != null) {
                line = reader.readLine();
            }
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("pingService", "RESPONSE CODE: " + conn.getResponseCode());
            }
            if (sws.getDeclaredField("manager").equals(null)) {
                logger.severe("pingService", LocalizationMessages.ENDPOINT_NOT_AVAILABLE_5002(urlAddr, sws.getName()));
            } else {
                logger.finest("pingService", "Injection succeeded");
            }
        }
        catch (Exception e) {
            if (wstxServiceAvailable) {
                wstxServiceAvailable = false;
                logger.warning("pingService", LocalizationMessages.ENDPOINT_NOT_AVAILABLE_5002(urlAddr, sws.getName()));
                logger.fine("pingService", LocalizationMessages.ENDPOINT_NOT_AVAILABLE_5002(urlAddr, sws.getName()), e);
            } else {
                logger.severe("pingService", LocalizationMessages.ENDPOINT_NOT_AVAILABLE_5002(urlAddr, sws.getName()));
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

