/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.PolicyBuilder;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.TokenValidator;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.Signature;
import com.sun.xml.ws.security.opt.impl.incoming.processor.KeyInfoProcessor;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.crypto.KeySelector;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLAssertion
implements SecurityHeaderElement,
PolicyBuilder,
TokenValidator,
NamespaceContextInfo,
SecurityElementWriter {
    private String id = "";
    private String localName = "";
    private String namespaceURI = "";
    private Key key = null;
    private JAXBFilterProcessingContext jpc = null;
    private HashMap<String, String> samlHeaderNSContext = null;
    private StreamReaderBufferCreator creator = null;
    private Signature sig = null;
    private MutableXMLStreamBuffer buffer = null;
    private boolean signatureNSinReader = false;
    private static final String KEYINFO_ELEMENT = "KeyInfo";

    public SAMLAssertion(XMLStreamReader reader, JAXBFilterProcessingContext jpc, StreamReaderBufferCreator creator, HashMap nsDecl) throws XWSSecurityException {
        this.jpc = jpc;
        this.creator = creator;
        this.id = reader.getAttributeValue(null, "AssertionID");
        if (this.id == null) {
            this.id = reader.getAttributeValue(null, "ID");
        }
        this.namespaceURI = reader.getNamespaceURI();
        this.localName = reader.getLocalName();
        this.samlHeaderNSContext = new HashMap();
        this.samlHeaderNSContext.putAll(nsDecl);
        if (reader.getNamespaceCount() > 0) {
            for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                this.samlHeaderNSContext.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                if (!reader.getNamespacePrefix(i).equals("ds") || !reader.getNamespaceURI(i).equals("http://www.w3.org/2000/09/xmldsig#")) continue;
                this.signatureNSinReader = true;
            }
        }
        this.buffer = new MutableXMLStreamBuffer();
        try {
            this.buffer.createFromXMLStreamReader(reader);
            this.process((XMLStreamReader)this.buffer.readAsXMLStreamReader());
        }
        catch (XMLStreamException xe) {
            throw new XWSSecurityException("Error occurred while reading SAMLAssertion", xe);
        }
    }

    public XMLStreamReader getSamlReader() throws XMLStreamException, XWSSecurityException {
        XMLStreamReader samlReader = this.readHeader();
        try {
            if (this.isSignatureNSinReader()) {
                return samlReader;
            }
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLInputFactory xif = XMLInputFactory.newInstance();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter writer = xof.createXMLStreamWriter(baos);
            boolean samlElementProcessed = false;
            while (8 != samlReader.getEventType()) {
                if (1 == samlReader.getEventType() && samlReader.getLocalName().equals("Assertion") && !samlElementProcessed) {
                    writer.writeStartElement(samlReader.getPrefix(), samlReader.getLocalName(), samlReader.getNamespaceURI());
                    Set<String> samlNSKeySet = this.samlHeaderNSContext.keySet();
                    for (String prefix : samlNSKeySet) {
                        writer.writeNamespace(prefix, this.samlHeaderNSContext.get(prefix));
                    }
                    int atCount = samlReader.getAttributeCount();
                    for (int i = 0; i < atCount; ++i) {
                        if (samlReader.getAttributePrefix(i) == "" || samlReader.getAttributePrefix(i) == null) {
                            writer.writeAttribute(samlReader.getAttributeLocalName(i), samlReader.getAttributeValue(i));
                            continue;
                        }
                        writer.writeAttribute(samlReader.getAttributePrefix(i), samlReader.getAttributeNamespace(i), samlReader.getAttributeLocalName(i), samlReader.getAttributeValue(i));
                    }
                    samlElementProcessed = true;
                } else {
                    StreamUtil.writeCurrentEvent(samlReader, writer);
                }
                samlReader.next();
            }
            writer.close();
            try {
                baos.close();
            }
            catch (IOException ex) {
                throw new XWSSecurityException("Error occurred while processing SAMLAssertion of type XMLSreamReader", ex);
            }
            samlReader = xif.createXMLStreamReader(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (XMLStreamException ex) {
            throw new XWSSecurityException("Error occurred while processing SAMLAssertion of type XMLSreamReader", ex);
        }
        return samlReader;
    }

    private boolean isSignatureNSinReader() {
        return this.signatureNSinReader;
    }

    public SAMLAssertion() {
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        return this.buffer.readAsXMLStreamReader();
    }

    @Override
    public WSSPolicy getPolicy() {
        return null;
    }

    @Override
    public void validate(ProcessingContext context) throws XWSSecurityException {
        try {
            context.getSecurityEnvironment().validateSAMLAssertion(context.getExtraneousProperties(), this.readHeader());
            XMLStreamReader samlReader = this.getSamlReader();
            context.getSecurityEnvironment().updateOtherPartySubject((Subject)context.getExtraneousProperties().get("javax.security.auth.Subject"), samlReader);
        }
        catch (XMLStreamException xe) {
            throw new XWSSecurityException("Error occurred while trying to validate SAMLAssertion", xe);
        }
    }

    @Override
    public HashMap<String, String> getInscopeNSContext() {
        return this.samlHeaderNSContext;
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        this.buffer.writeToXMLStreamWriter(streamWriter);
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        this.writeTo(streamWriter);
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    public boolean isHOK() {
        return this.sig != null;
    }

    public boolean validateSignature() throws XWSSecurityException {
        if (this.isHOK()) {
            return this.sig.validate();
        }
        return false;
    }

    public void processNoValidation(XMLStreamReader reader, XMLStreamWriter buffer) throws XWSSecurityException {
        try {
            StreamUtil.writeCurrentEvent(reader, buffer);
            while (reader.hasNext()) {
                reader.next();
                if (this._break(reader)) {
                    StreamUtil.writeCurrentEvent(reader, buffer);
                    reader.next();
                    break;
                }
                StreamUtil.writeCurrentEvent(reader, buffer);
            }
        }
        catch (XMLStreamException xe) {
            throw new XWSSecurityException("Error occurred while reading SAMLAssertion", xe);
        }
    }

    public void process(XMLStreamReader reader) throws XWSSecurityException {
        try {
            while (reader.hasNext()) {
                reader.next();
                switch (reader.getEventType()) {
                    case 1: {
                        if (reader.getLocalName() != "Signature" || reader.getNamespaceURI() != "http://www.w3.org/2000/09/xmldsig#") break;
                        this.sig = new Signature(this.jpc, this.samlHeaderNSContext, this.creator, false);
                        this.jpc.isSamlSignatureKey(true);
                        this.sig.process(reader, false);
                        this.jpc.isSamlSignatureKey(false);
                    }
                }
                if (this._break(reader)) {
                    reader.next();
                    break;
                }
                if (reader.getEventType() != 1 || !reader.getLocalName().equals("Advice")) continue;
                this.skipAdviceValidation(reader);
            }
        }
        catch (XMLStreamException xe) {
            throw new XWSSecurityException("Error occurred while reading SAMLAssertion", xe);
        }
    }

    public void skipAdviceValidation(XMLStreamReader reader) throws XWSSecurityException {
        int adviceElementCount = 1;
        try {
            while (true) {
                if (reader.getLocalName().equals("Advice")) {
                    if (reader.getEventType() == 2 && adviceElementCount == 0) break;
                }
                reader.next();
                if (reader.getEventType() == 1 && reader.getLocalName().equals("Advice")) {
                    ++adviceElementCount;
                }
                if (reader.getEventType() != 2 || !reader.getLocalName().equals("Advice")) continue;
                --adviceElementCount;
            }
        }
        catch (XMLStreamException xe) {
            throw new XWSSecurityException("Error occurred while reading SAMLAssertion", xe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Key getKey() throws XWSSecurityException {
        if (this.key != null) return this.key;
        try {
            XMLStreamReader reader = this.readHeader();
            while (reader.getEventType() != 8) {
                switch (reader.getEventType()) {
                    case 1: {
                        if (reader.getLocalName() != KEYINFO_ELEMENT || reader.getNamespaceURI() != "http://www.w3.org/2000/09/xmldsig#") break;
                        this.jpc.isSAMLEK(true);
                        KeyInfoProcessor kip = new KeyInfoProcessor(this.jpc, KeySelector.Purpose.VERIFY, true);
                        this.key = kip.getKey(reader);
                        this.jpc.isSAMLEK(false);
                        return this.key;
                    }
                }
                if (!reader.hasNext()) return this.key;
                if (reader.getEventType() == 1 && reader.getLocalName().equals("Advice")) {
                    int adviceElementCount = 1;
                    while (true) {
                        if (reader.getLocalName().equals("Advice")) {
                            if (reader.getEventType() == 2 && adviceElementCount == 0) break;
                        }
                        reader.next();
                        if (reader.getEventType() == 1 && reader.getLocalName().equals("Advice")) {
                            ++adviceElementCount;
                        }
                        if (reader.getEventType() != 2 || !reader.getLocalName().equals("Advice")) continue;
                        --adviceElementCount;
                    }
                    reader.next();
                    continue;
                }
                reader.next();
            }
            return this.key;
        }
        catch (XMLStreamException xe) {
            throw new XWSSecurityException("Error occurred while obtaining Key from SAMLAssertion", xe);
        }
    }

    private boolean _break(XMLStreamReader reader) {
        String uri;
        return reader.getEventType() == 2 && reader.getLocalName() == "Assertion" && ((uri = reader.getNamespaceURI()) == "urn:oasis:names:tc:SAML:2.0:assertion" || uri == "urn:oasis:names:tc:SAML:1.0:assertion" || uri == "urn:oasis:names:tc:SAML:1.0:assertion");
    }
}

