/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.Executor;
import com.swoval.files.FileTreeViews;
import com.swoval.files.Observers;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import com.swoval.files.RegisteredPaths;
import com.swoval.files.TypedPath;
import com.swoval.files.TypedPaths;
import com.swoval.functional.Either;
import com.swoval.logging.Logger;
import com.swoval.logging.Loggers;
import java.io.IOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

class SymlinkWatcher
implements FileTreeViews.Observable<PathWatchers.Event>,
AutoCloseable {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Observers<PathWatchers.Event> observers = new Observers();
    private final Executor callbackExecutor = Executor.make("com.swoval.files.SymlinkWatcher.callback-executor");
    private final Logger logger;
    private final RegisteredPaths watchedSymlinksByTarget;
    private final PathWatcher<PathWatchers.Event> watcher;

    SymlinkWatcher(PathWatcher<PathWatchers.Event> pathWatcher) {
        this(pathWatcher, Loggers.getLogger());
    }

    SymlinkWatcher(final PathWatcher<PathWatchers.Event> pathWatcher, final Logger logger) {
        this.watcher = pathWatcher;
        this.logger = logger;
        ReentrantLock reentrantLock = new ReentrantLock();
        this.watchedSymlinksByTarget = new RegisteredPaths(reentrantLock);
        pathWatcher.addObserver(new FileTreeViews.Observer<PathWatchers.Event>(){

            @Override
            public void onError(Throwable throwable) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(PathWatchers.Event event) {
                if (Loggers.shouldLog(logger, Loggers.Level.DEBUG)) {
                    logger.debug(this + " received event " + event);
                }
                if (!SymlinkWatcher.this.isClosed.get()) {
                    Object object;
                    Object object2;
                    ArrayList<Path> arrayList = new ArrayList<Path>();
                    Path path = event.getTypedPath().getPath();
                    PathWatchers.Event.Kind kind = event.getKind();
                    if (SymlinkWatcher.this.watchedSymlinksByTarget.lock()) {
                        try {
                            object2 = SymlinkWatcher.this.find(path, SymlinkWatcher.this.watchedSymlinksByTarget);
                            if (object2 != null) {
                                object = ((RegisteredPath)object2).path.relativize(path);
                                Iterator<Path> iterator = ((RegisteredPath)object2).paths.iterator();
                                while (iterator.hasNext()) {
                                    Path path2 = iterator.next().resolve((Path)object);
                                    if (SymlinkWatcher.this.hasLoop(path2)) continue;
                                    arrayList.add(path2);
                                }
                            }
                        }
                        finally {
                            SymlinkWatcher.this.watchedSymlinksByTarget.unlock();
                        }
                    }
                    if (!Files.exists(path, new LinkOption[0]) && SymlinkWatcher.this.watchedSymlinksByTarget.lock()) {
                        try {
                            object2 = (RegisteredPath)SymlinkWatcher.this.watchedSymlinksByTarget.remove(path);
                            if (object2 != null) {
                                ((RegisteredPath)object2).paths.remove(path);
                                if (((RegisteredPath)object2).paths.isEmpty()) {
                                    pathWatcher.unregister(path);
                                }
                            }
                        }
                        finally {
                            SymlinkWatcher.this.watchedSymlinksByTarget.unlock();
                        }
                    }
                    object2 = arrayList.iterator();
                    while (object2.hasNext()) {
                        object = TypedPaths.get((Path)object2.next());
                        if (Loggers.shouldLog(logger, Loggers.Level.DEBUG)) {
                            logger.debug("SymlinkWatcher evaluating callback for " + "link " + object + " to target " + path);
                        }
                        SymlinkWatcher.this.observers.onNext(new PathWatchers.Event((TypedPath)object, kind));
                    }
                }
            }
        });
    }

    @Override
    public int addObserver(FileTreeViews.Observer<? super PathWatchers.Event> observer) {
        return this.observers.addObserver(observer);
    }

    @Override
    public void removeObserver(int n) {
        this.observers.removeObserver(n);
    }

    private RegisteredPath find(Path path, RegisteredPaths registeredPaths) {
        RegisteredPath registeredPath = (RegisteredPath)registeredPaths.get(path);
        if (registeredPath != null) {
            return registeredPath;
        }
        if (path == null || path.getNameCount() == 0) {
            return null;
        }
        Path path2 = path.getParent();
        if (path2 == null || path2.getNameCount() == 0) {
            return null;
        }
        return this.find(path2, registeredPaths);
    }

    private boolean hasLoop(Path path) {
        boolean bl = false;
        Path path2 = path.getParent();
        try {
            Path path3 = path2.toRealPath(new LinkOption[0]);
            bl = path2.startsWith(path3) && !path2.equals(path3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            Iterator iterator = this.watchedSymlinksByTarget.values().iterator();
            while (iterator.hasNext()) {
                ((RegisteredPath)iterator.next()).paths.clear();
            }
            this.watchedSymlinksByTarget.clear();
            this.watcher.close();
            this.callbackExecutor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSymlink(Path path, int n) throws IOException {
        if (!this.isClosed.get()) {
            Path path2 = path.toRealPath(new LinkOption[0]);
            if (path.startsWith(path2) && !path.equals(path2)) {
                throw new FileSystemLoopException(path.toString());
            }
            if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                this.logger.debug(this + " SymlinkWatcher adding link " + path + " with max depth " + n);
            }
            if (this.watchedSymlinksByTarget.lock()) {
                try {
                    RegisteredPath registeredPath = (RegisteredPath)this.watchedSymlinksByTarget.get(path2);
                    if (registeredPath == null) {
                        Either<IOException, Boolean> either = this.watcher.register(path2, n);
                        if (Either.getOrElse(either, false).booleanValue()) {
                            this.watchedSymlinksByTarget.put(path2, new RegisteredPath(path2, path));
                        } else if (either.isLeft()) {
                            throw Either.leftProjection(either).getValue();
                        }
                    } else {
                        registeredPath.paths.add(path);
                    }
                }
                finally {
                    this.watchedSymlinksByTarget.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Path path) {
        if (!this.isClosed.get() && this.watchedSymlinksByTarget.lock()) {
            try {
                Object object;
                Path path2 = null;
                Iterator iterator = this.watchedSymlinksByTarget.iterator();
                while (iterator.hasNext() && path2 == null) {
                    object = iterator.next();
                    if (!((RegisteredPath)object.getValue()).paths.remove(path)) continue;
                    path2 = (Path)object.getKey();
                }
                if (path2 != null && (object = (RegisteredPath)this.watchedSymlinksByTarget.get(path2)) != null) {
                    ((RegisteredPath)object).paths.remove(path);
                    if (((RegisteredPath)object).paths.isEmpty()) {
                        this.watchedSymlinksByTarget.remove(path2);
                    }
                }
                if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                    this.logger.debug(this + " stopped monitoring link " + path);
                }
            }
            finally {
                this.watchedSymlinksByTarget.unlock();
            }
        }
    }

    static final class RegisteredPath
    implements AutoCloseable {
        public final Path path;
        public final Set<Path> paths = new HashSet<Path>();

        RegisteredPath(Path path, Path path2) {
            this.path = path;
            this.paths.add(path2);
        }

        @Override
        public void close() {
            this.paths.clear();
        }
    }
}

