/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.ArchiveMode;
import com.opentok.MediaMode;
import com.opentok.exception.InvalidArgumentException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.validator.routines.InetAddressValidator;

public class SessionProperties {
    private String location = null;
    private MediaMode mediaMode;
    private ArchiveMode archiveMode;

    private SessionProperties(Builder builder) {
        this.location = builder.location;
        this.mediaMode = builder.mediaMode;
        this.archiveMode = builder.archiveMode;
    }

    public String getLocation() {
        return this.location;
    }

    public MediaMode mediaMode() {
        return this.mediaMode;
    }

    public ArchiveMode archiveMode() {
        return this.archiveMode;
    }

    public Map<String, Collection<String>> toMap() {
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        if (null != this.location) {
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add(this.location);
            params.put("location", valueList);
        }
        ArrayList<String> mediaModeValueList = new ArrayList<String>();
        mediaModeValueList.add(this.mediaMode.toString());
        params.put("p2p.preference", mediaModeValueList);
        ArrayList<String> archiveModeValueList = new ArrayList<String>();
        archiveModeValueList.add(this.archiveMode.toString());
        params.put("archiveMode", archiveModeValueList);
        return params;
    }

    public static class Builder {
        private String location = null;
        private MediaMode mediaMode = MediaMode.RELAYED;
        private ArchiveMode archiveMode = ArchiveMode.MANUAL;

        public Builder location(String location) throws InvalidArgumentException {
            if (!InetAddressValidator.getInstance().isValidInet4Address(location)) {
                throw new InvalidArgumentException("Location must be a valid IPv4 address. location = " + location);
            }
            this.location = location;
            return this;
        }

        public Builder mediaMode(MediaMode mediaMode) {
            this.mediaMode = mediaMode;
            return this;
        }

        public Builder archiveMode(ArchiveMode archiveMode) {
            this.archiveMode = archiveMode;
            return this;
        }

        public SessionProperties build() {
            return new SessionProperties(this);
        }
    }
}

