/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.util;

import com.opentok.exception.OpenTokException;
import java.security.Key;
import java.util.concurrent.TimeUnit;
import javax.crypto.spec.SecretKeySpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;

public class TokenGenerator {
    public static final String ISSUER = "iss";
    public static final String ISSUER_TYPE = "ist";
    public static final String ISSUED_AT = "iat";
    public static final String EXP = "exp";
    public static final String PROJECT_ISSUER_TYPE = "project";

    public static String generateToken(Integer apiKey, String apiSecret) throws OpenTokException {
        long defaultExpireTime = System.currentTimeMillis() / 1000L + TimeUnit.MINUTES.toSeconds(3L);
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(apiKey.toString());
        claims.setStringClaim(ISSUER_TYPE, PROJECT_ISSUER_TYPE);
        claims.setGeneratedJwtId();
        return TokenGenerator.getToken(claims, defaultExpireTime, apiSecret);
    }

    private static String getToken(JwtClaims claims, long expireTime, String apiSecret) throws OpenTokException {
        SecretKeySpec spec = new SecretKeySpec(apiSecret.getBytes(), "HS256");
        claims.setExpirationTime(NumericDate.fromSeconds((long)expireTime));
        claims.setIssuedAtToNow();
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)spec);
        jws.setAlgorithmHeaderValue("HS256");
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new OpenTokException(e.getMessage());
        }
    }
}

