/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.turo.pushy.apns.AbstractMockApnsServerHandler;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AsciiString;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class TlsAuthenticationMockApnsServerHandler
extends AbstractMockApnsServerHandler {
    private final Set<String> allowedTopics;
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");

    protected TlsAuthenticationMockApnsServerHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean emulateInternalErrors, Map<String, Map<String, Date>> deviceTokenExpirationsByTopic, String baseTopic) {
        super(decoder, encoder, initialSettings, emulateInternalErrors, deviceTokenExpirationsByTopic);
        Objects.requireNonNull(baseTopic, "Base topic must not be null for mock server handlers using TLS-based authentication.");
        this.allowedTopics = new HashSet<String>();
        this.allowedTopics.add(baseTopic);
        this.allowedTopics.add(baseTopic + ".voip");
        this.allowedTopics.add(baseTopic + ".complication");
    }

    @Override
    protected void verifyHeaders(Http2Headers headers) throws AbstractMockApnsServerHandler.RejectedNotificationException {
        String topic;
        CharSequence topicSequence = (CharSequence)headers.get((Object)APNS_TOPIC_HEADER);
        String string = topic = topicSequence != null ? topicSequence.toString() : null;
        if (!this.allowedTopics.contains(topic)) {
            throw new AbstractMockApnsServerHandler.RejectedNotificationException(AbstractMockApnsServerHandler.ErrorReason.BAD_TOPIC);
        }
    }

    public static final class TlsAuthenticationMockApnsServerHandlerBuilder
    extends AbstractMockApnsServerHandler.AbstractMockApnsServerHandlerBuilder {
        private String baseTopic;

        public AbstractMockApnsServerHandler.AbstractMockApnsServerHandlerBuilder baseTopic(String baseTopic) {
            this.baseTopic = baseTopic;
            return this;
        }

        public TlsAuthenticationMockApnsServerHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            TlsAuthenticationMockApnsServerHandler handler = new TlsAuthenticationMockApnsServerHandler(decoder, encoder, initialSettings, super.emulateInternalErrors(), super.deviceTokenExpirationsByTopic(), this.baseTopic);
            this.frameListener(handler);
            return handler;
        }

        @Override
        public AbstractMockApnsServerHandler build() {
            return super.build();
        }
    }
}

