/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.turo.pushy.apns.DateAsTimeSinceEpochTypeAdapter;
import com.turo.pushy.apns.auth.ApnsSigningKey;
import com.turo.pushy.apns.auth.ApnsVerificationKey;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;

class AuthenticationToken {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Date.class, (Object)new DateAsTimeSinceEpochTypeAdapter(TimeUnit.SECONDS)).create();
    private final AuthenticationTokenHeader header;
    private final AuthenticationTokenClaims claims;
    private final byte[] signatureBytes;
    private final String base64EncodedToken;

    public AuthenticationToken(ApnsSigningKey signingKey, Date issuedAt) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.header = new AuthenticationTokenHeader(signingKey.getKeyId());
        this.claims = new AuthenticationTokenClaims(signingKey.getTeamId(), issuedAt);
        String headerJson = GSON.toJson((Object)this.header);
        String claimsJson = GSON.toJson((Object)this.claims);
        StringBuilder payloadBuilder = new StringBuilder();
        payloadBuilder.append(Base64.encodeBase64URLSafeString((byte[])headerJson.getBytes(StandardCharsets.US_ASCII)));
        payloadBuilder.append('.');
        payloadBuilder.append(Base64.encodeBase64URLSafeString((byte[])claimsJson.getBytes(StandardCharsets.US_ASCII)));
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initSign(signingKey);
        signature.update(payloadBuilder.toString().getBytes(StandardCharsets.US_ASCII));
        this.signatureBytes = signature.sign();
        payloadBuilder.append('.');
        payloadBuilder.append(Base64.encodeBase64URLSafeString((byte[])this.signatureBytes));
        this.base64EncodedToken = payloadBuilder.toString();
    }

    public AuthenticationToken(String base64EncodedToken) {
        this.base64EncodedToken = base64EncodedToken;
        String[] pieces = this.base64EncodedToken.split("\\.");
        if (pieces.length != 3) {
            throw new IllegalArgumentException();
        }
        this.header = (AuthenticationTokenHeader)GSON.fromJson(new String(Base64.decodeBase64((String)pieces[0]), StandardCharsets.US_ASCII), AuthenticationTokenHeader.class);
        this.claims = (AuthenticationTokenClaims)GSON.fromJson(new String(Base64.decodeBase64((String)pieces[1]), StandardCharsets.US_ASCII), AuthenticationTokenClaims.class);
        this.signatureBytes = Base64.decodeBase64((String)pieces[2]);
    }

    public Date getIssuedAt() {
        return this.claims.getIssuedAt();
    }

    public String getKeyId() {
        return this.header.getKeyId();
    }

    public String getTeamId() {
        return this.claims.getIssuer();
    }

    public boolean verifySignature(ApnsVerificationKey verificationKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.header.getKeyId().equals(verificationKey.getKeyId())) {
            return false;
        }
        if (!this.claims.getIssuer().equals(verificationKey.getTeamId())) {
            return false;
        }
        String headerJson = GSON.toJson((Object)this.header);
        String claimsJson = GSON.toJson((Object)this.claims);
        StringBuilder headerAndClaimsBuilder = new StringBuilder();
        headerAndClaimsBuilder.append(Base64.encodeBase64URLSafeString((byte[])headerJson.getBytes(StandardCharsets.US_ASCII)));
        headerAndClaimsBuilder.append('.');
        headerAndClaimsBuilder.append(Base64.encodeBase64URLSafeString((byte[])claimsJson.getBytes(StandardCharsets.US_ASCII)));
        byte[] headerAndClaimsBytes = headerAndClaimsBuilder.toString().getBytes(StandardCharsets.US_ASCII);
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initVerify(verificationKey);
        signature.update(headerAndClaimsBytes);
        return signature.verify(this.signatureBytes);
    }

    public String toString() {
        return this.base64EncodedToken;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base64EncodedToken == null ? 0 : this.base64EncodedToken.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationToken)) {
            return false;
        }
        AuthenticationToken other = (AuthenticationToken)obj;
        return !(this.base64EncodedToken == null ? other.base64EncodedToken != null : !this.base64EncodedToken.equals(other.base64EncodedToken));
    }

    private static class AuthenticationTokenClaims {
        @SerializedName(value="iss")
        private final String issuer;
        @SerializedName(value="iat")
        private final Date issuedAt;

        public AuthenticationTokenClaims(String teamId, Date issuedAt) {
            this.issuer = teamId;
            this.issuedAt = issuedAt;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public Date getIssuedAt() {
            return this.issuedAt;
        }
    }

    private static class AuthenticationTokenHeader {
        @SerializedName(value="alg")
        private final String algorithm = "ES256";
        @SerializedName(value="typ")
        private final String tokenType = "JWT";
        @SerializedName(value="kid")
        private final String keyId;

        public AuthenticationTokenHeader(String keyId) {
            this.keyId = keyId;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public String getKeyId() {
            return this.keyId;
        }
    }
}

