/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.turo.pushy.apns.AbstractMockApnsServerHandler;
import com.turo.pushy.apns.SocketChannelClassUtil;
import com.turo.pushy.apns.TlsAuthenticationMockApnsServerHandler;
import com.turo.pushy.apns.TokenAuthenticationMockApnsServerHandler;
import com.turo.pushy.apns.auth.ApnsVerificationKey;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.SucceededFuture;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class MockApnsServer {
    private final SslContext sslContext;
    private final AtomicBoolean hasReleasedSslContext = new AtomicBoolean(false);
    private final ServerBootstrap bootstrap;
    private final boolean shouldShutDownEventLoopGroup;
    private final Map<String, Map<String, Date>> deviceTokenExpirationsByTopic = new HashMap<String, Map<String, Date>>();
    private final Map<String, ApnsVerificationKey> verificationKeysByKeyId = new HashMap<String, ApnsVerificationKey>();
    private final Map<ApnsVerificationKey, Set<String>> topicsByVerificationKey = new HashMap<ApnsVerificationKey, Set<String>>();
    private ChannelGroup allChannels;
    private boolean emulateInternalErrors = false;
    private boolean emulateExpiredFirstToken = false;
    public static final long AUTHENTICATION_TOKEN_EXPIRATION_MILLIS = TimeUnit.HOURS.toMillis(1L);

    protected MockApnsServer(final SslContext sslContext, EventLoopGroup eventLoopGroup) {
        this.sslContext = sslContext;
        if (this.sslContext instanceof ReferenceCounted) {
            ((ReferenceCounted)this.sslContext).retain();
        }
        this.bootstrap = new ServerBootstrap();
        if (eventLoopGroup != null) {
            this.bootstrap.group(eventLoopGroup);
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1));
            this.shouldShutDownEventLoopGroup = true;
        }
        this.bootstrap.channel(SocketChannelClassUtil.getServerSocketChannelClass(this.bootstrap.config().group()));
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                final SslHandler sslHandler = sslContext.newHandler(channel.alloc());
                channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
                channel.pipeline().addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("http/1.1"){

                    protected void configurePipeline(ChannelHandlerContext context, String protocol) throws Exception {
                        AbstractMockApnsServerHandler.AbstractMockApnsServerHandlerBuilder handlerBuilder;
                        if ("h2".equals(protocol)) {
                            try {
                                SSLSession sslSession = sslHandler.engine().getSession();
                                String principalName = sslSession.getPeerPrincipal().getName();
                                Pattern pattern = Pattern.compile(".*UID=([^,]+).*");
                                Matcher matcher = pattern.matcher(principalName);
                                if (!matcher.matches()) {
                                    throw new IllegalArgumentException("Client certificate does not specify a base topic.");
                                }
                                String baseTopic = matcher.group(1);
                                TlsAuthenticationMockApnsServerHandler.TlsAuthenticationMockApnsServerHandlerBuilder tlsAuthenticationHandlerBuilder = new TlsAuthenticationMockApnsServerHandler.TlsAuthenticationMockApnsServerHandlerBuilder();
                                tlsAuthenticationHandlerBuilder.baseTopic(baseTopic);
                                handlerBuilder = tlsAuthenticationHandlerBuilder;
                            }
                            catch (SSLPeerUnverifiedException e) {
                                TokenAuthenticationMockApnsServerHandler.TokenAuthenticationMockApnsServerHandlerBuilder tokenAuthenticationHandlerBuilder = new TokenAuthenticationMockApnsServerHandler.TokenAuthenticationMockApnsServerHandlerBuilder();
                                tokenAuthenticationHandlerBuilder.verificationKeysByKeyId(MockApnsServer.this.verificationKeysByKeyId);
                                tokenAuthenticationHandlerBuilder.topicsByVerificationKey(MockApnsServer.this.topicsByVerificationKey);
                                tokenAuthenticationHandlerBuilder.emulateExpiredFirstToken(MockApnsServer.this.emulateExpiredFirstToken);
                                handlerBuilder = tokenAuthenticationHandlerBuilder;
                            }
                        } else {
                            throw new IllegalStateException("Unexpected protocol: " + protocol);
                        }
                        context.pipeline().addLast(new ChannelHandler[]{handlerBuilder.initialSettings(new Http2Settings().maxConcurrentStreams(8L)).emulateInternalErrors(MockApnsServer.this.emulateInternalErrors).deviceTokenExpirationsByTopic(MockApnsServer.this.deviceTokenExpirationsByTopic).build()});
                        MockApnsServer.this.allChannels.add((Object)context.channel());
                    }
                }});
            }
        });
    }

    public Future<Void> start(int port) {
        ChannelFuture channelFuture = this.bootstrap.bind(port);
        this.allChannels = new DefaultChannelGroup((EventExecutor)channelFuture.channel().eventLoop(), true);
        this.allChannels.add((Object)channelFuture.channel());
        return channelFuture;
    }

    public void registerVerificationKey(ApnsVerificationKey verificationKey, Collection<String> topics) throws NoSuchAlgorithmException, InvalidKeyException {
        this.registerVerificationKey(verificationKey, topics.toArray(new String[0]));
    }

    public void registerVerificationKey(ApnsVerificationKey verificationKey, String ... topics) throws NoSuchAlgorithmException, InvalidKeyException {
        this.verificationKeysByKeyId.put(verificationKey.getKeyId(), verificationKey);
        this.topicsByVerificationKey.put(verificationKey, new HashSet<String>(Arrays.asList(topics)));
    }

    public void registerDeviceTokenForTopic(String topic, String token, Date expiration) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(token);
        if (!this.deviceTokenExpirationsByTopic.containsKey(topic)) {
            this.deviceTokenExpirationsByTopic.put(topic, new HashMap());
        }
        this.deviceTokenExpirationsByTopic.get(topic).put(token, expiration);
    }

    public void clearTokens() {
        this.deviceTokenExpirationsByTopic.clear();
    }

    protected void setEmulateInternalErrors(boolean emulateInternalErrors) {
        this.emulateInternalErrors = emulateInternalErrors;
    }

    protected void setEmulateExpiredFirstToken(boolean emulateExpiredFirstToken) {
        this.emulateExpiredFirstToken = emulateExpiredFirstToken;
    }

    public Future<Void> shutdown() {
        SucceededFuture disconnectFuture;
        SucceededFuture channelCloseFuture;
        Object object = channelCloseFuture = this.allChannels != null ? this.allChannels.close() : new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
        if (this.shouldShutDownEventLoopGroup) {
            channelCloseFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    MockApnsServer.this.bootstrap.config().group().shutdownGracefully();
                }
            });
            disconnectFuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
            this.bootstrap.config().group().terminationFuture().addListener(new GenericFutureListener((Future)disconnectFuture){
                final /* synthetic */ Future val$disconnectFuture;
                {
                    this.val$disconnectFuture = future;
                }

                public void operationComplete(Future future) throws Exception {
                    ((Promise)this.val$disconnectFuture).trySuccess(null);
                }
            });
        } else {
            disconnectFuture = channelCloseFuture;
        }
        disconnectFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (MockApnsServer.this.sslContext instanceof ReferenceCounted && MockApnsServer.this.hasReleasedSslContext.compareAndSet(false, true)) {
                    ((ReferenceCounted)MockApnsServer.this.sslContext).release();
                }
            }
        });
        return disconnectFuture;
    }
}

