/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.turo.pushy.apns.AbstractMockApnsServerHandler;
import com.turo.pushy.apns.AuthenticationToken;
import com.turo.pushy.apns.MockApnsServer;
import com.turo.pushy.apns.TokenAuthenticationApnsClientHandler;
import com.turo.pushy.apns.auth.ApnsVerificationKey;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AsciiString;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenAuthenticationMockApnsServerHandler
extends AbstractMockApnsServerHandler {
    private final boolean emulateExpiredFirstToken;
    private boolean rejectedFirstExpiredToken = false;
    private final Map<String, ApnsVerificationKey> verificationKeysByKeyId;
    private final Map<ApnsVerificationKey, Set<String>> topicsByVerificationKey;
    private String expectedTeamId;
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");
    private static final AsciiString APNS_AUTHORIZATION_HEADER = new AsciiString((CharSequence)"authorization");
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationApnsClientHandler.class);

    protected TokenAuthenticationMockApnsServerHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean emulateInternalErrors, Map<String, Map<String, Date>> deviceTokenExpirationsByTopic, boolean emulateExpiredFirstToken, Map<String, ApnsVerificationKey> verificationKeysByKeyId, Map<ApnsVerificationKey, Set<String>> topicsByVerificationKey) {
        super(decoder, encoder, initialSettings, emulateInternalErrors, deviceTokenExpirationsByTopic);
        this.emulateExpiredFirstToken = emulateExpiredFirstToken;
        this.verificationKeysByKeyId = verificationKeysByKeyId;
        this.topicsByVerificationKey = topicsByVerificationKey;
    }

    @Override
    protected void verifyHeaders(Http2Headers headers) throws AbstractMockApnsServerHandler.RejectedNotificationException {
        String authorizationString;
        super.verifyHeaders(headers);
        CharSequence authorizationSequence = (CharSequence)headers.get((Object)APNS_AUTHORIZATION_HEADER);
        String base64EncodedAuthenticationToken = authorizationSequence != null ? ((authorizationString = authorizationSequence.toString()).startsWith("bearer") ? authorizationString.substring("bearer".length()).trim() : null) : null;
        AuthenticationToken authenticationToken = new AuthenticationToken(base64EncodedAuthenticationToken);
        ApnsVerificationKey verificationKey = this.verificationKeysByKeyId.get(authenticationToken.getKeyId());
        if (verificationKey == null) {
            throw new AbstractMockApnsServerHandler.RejectedNotificationException(AbstractMockApnsServerHandler.ErrorReason.INVALID_PROVIDER_TOKEN);
        }
        try {
            if (!authenticationToken.verifySignature(verificationKey)) {
                throw new AbstractMockApnsServerHandler.RejectedNotificationException(AbstractMockApnsServerHandler.ErrorReason.INVALID_PROVIDER_TOKEN);
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            log.error("Failed to verify authentication token signature.", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (this.expectedTeamId == null) {
            this.expectedTeamId = authenticationToken.getTeamId();
        }
        if (!this.expectedTeamId.equals(authenticationToken.getTeamId())) {
            throw new AbstractMockApnsServerHandler.RejectedNotificationException(AbstractMockApnsServerHandler.ErrorReason.INVALID_PROVIDER_TOKEN);
        }
        if (authenticationToken.getIssuedAt().getTime() + MockApnsServer.AUTHENTICATION_TOKEN_EXPIRATION_MILLIS < System.currentTimeMillis()) {
            throw new AbstractMockApnsServerHandler.RejectedNotificationException(AbstractMockApnsServerHandler.ErrorReason.EXPIRED_PROVIDER_TOKEN);
        }
        if (this.emulateExpiredFirstToken && !this.rejectedFirstExpiredToken) {
            this.rejectedFirstExpiredToken = true;
            throw new AbstractMockApnsServerHandler.RejectedNotificationException(AbstractMockApnsServerHandler.ErrorReason.EXPIRED_PROVIDER_TOKEN);
        }
        CharSequence topicSequence = (CharSequence)headers.get((Object)APNS_TOPIC_HEADER);
        String topic = topicSequence != null ? topicSequence.toString() : null;
        Set<String> topicsAllowedForVerificationKey = this.topicsByVerificationKey.get(verificationKey);
        if (topicsAllowedForVerificationKey == null || !topicsAllowedForVerificationKey.contains(topic)) {
            throw new AbstractMockApnsServerHandler.RejectedNotificationException(AbstractMockApnsServerHandler.ErrorReason.INVALID_PROVIDER_TOKEN);
        }
    }

    public static final class TokenAuthenticationMockApnsServerHandlerBuilder
    extends AbstractMockApnsServerHandler.AbstractMockApnsServerHandlerBuilder {
        private boolean emulateExpiredFirstToken;
        private Map<String, ApnsVerificationKey> verificationKeysByKeyId;
        private Map<ApnsVerificationKey, Set<String>> topicsByVerificationKey;

        public AbstractMockApnsServerHandler.AbstractMockApnsServerHandlerBuilder emulateExpiredFirstToken(boolean emulateExpiredFirstToken) {
            this.emulateExpiredFirstToken = emulateExpiredFirstToken;
            return this;
        }

        public AbstractMockApnsServerHandler.AbstractMockApnsServerHandlerBuilder verificationKeysByKeyId(Map<String, ApnsVerificationKey> verificationKeysByKeyId) {
            this.verificationKeysByKeyId = verificationKeysByKeyId;
            return this;
        }

        public AbstractMockApnsServerHandler.AbstractMockApnsServerHandlerBuilder topicsByVerificationKey(Map<ApnsVerificationKey, Set<String>> topicsByVerificationKey) {
            this.topicsByVerificationKey = topicsByVerificationKey;
            return this;
        }

        public TokenAuthenticationMockApnsServerHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            TokenAuthenticationMockApnsServerHandler handler = new TokenAuthenticationMockApnsServerHandler(decoder, encoder, initialSettings, super.emulateInternalErrors(), super.deviceTokenExpirationsByTopic(), this.emulateExpiredFirstToken, this.verificationKeysByKeyId, this.topicsByVerificationKey);
            this.frameListener(handler);
            return handler;
        }

        @Override
        public AbstractMockApnsServerHandler build() {
            return super.build();
        }
    }
}

