/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.AsyncCompareResultListener;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.DiscardAsyncListener;
import com.unboundid.ldap.sdk.DisconnectInfo;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.FullLDAPInterface;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPConnectionInfo;
import com.unboundid.ldap.sdk.LDAPConnectionInternals;
import com.unboundid.ldap.sdk.LDAPConnectionLogger;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionReader;
import com.unboundid.ldap.sdk.LDAPConnectionStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.ReferralConnector;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SASLBindInProgressException;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.SynchronizedSSLSocketFactory;
import com.unboundid.util.SynchronizedSocketFactory;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.WeakHashSet;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.sasl.SaslClient;

@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
public final class LDAPConnection
implements FullLDAPInterface,
LDAPConnectionInfo,
ReferralConnector,
Closeable {
    @NotNull
    private static final AtomicLong NEXT_CONNECTION_ID = new AtomicLong(0L);
    @NotNull
    private static final SocketFactory DEFAULT_SOCKET_FACTORY = SocketFactory.getDefault();
    @NotNull
    private static final WeakHashSet<Schema> SCHEMA_SET = new WeakHashSet();
    @Nullable
    private AbstractConnectionPool connectionPool;
    @NotNull
    private final AtomicBoolean needsReconnect = new AtomicBoolean(false);
    @NotNull
    private final AtomicReference<DisconnectInfo> disconnectInfo = new AtomicReference();
    @Nullable
    private volatile BindRequest lastBindRequest;
    private volatile boolean closeRequested;
    private volatile boolean unbindRequestSent;
    @Nullable
    private volatile ExtendedRequest startTLSRequest;
    private int reconnectPort = -1;
    @Nullable
    private volatile LDAPConnectionInternals connectionInternals;
    @NotNull
    private LDAPConnectionOptions connectionOptions;
    @NotNull
    private final LDAPConnectionStatistics connectionStatistics;
    private final long connectionID = NEXT_CONNECTION_ID.getAndIncrement();
    private long lastReconnectTime;
    private volatile long lastCommunicationTime = -1L;
    @Nullable
    private Map<String, Object> attachments;
    @Nullable
    private volatile ReferralConnector referralConnector;
    @Nullable
    private volatile Schema cachedSchema;
    @Nullable
    private volatile ServerSet serverSet;
    @Nullable
    private SocketFactory lastUsedSocketFactory;
    @NotNull
    private volatile SocketFactory socketFactory;
    @Nullable
    private StackTraceElement[] connectStackTrace;
    @Nullable
    private String connectionName;
    @Nullable
    private String connectionPoolName;
    @Nullable
    private String hostPort;
    @Nullable
    private String reconnectAddress;
    @Nullable
    private Timer timer;

    public LDAPConnection() {
        this(null, null);
    }

    public LDAPConnection(@Nullable LDAPConnectionOptions connectionOptions) {
        this(null, connectionOptions);
    }

    public LDAPConnection(@Nullable SocketFactory socketFactory) {
        this(socketFactory, null);
    }

    public LDAPConnection(@Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions.duplicate();
        SocketFactory f = socketFactory == null ? DEFAULT_SOCKET_FACTORY : socketFactory;
        this.socketFactory = this.connectionOptions.allowConcurrentSocketFactoryUse() ? f : (f instanceof SSLSocketFactory ? new SynchronizedSSLSocketFactory((SSLSocketFactory)f) : new SynchronizedSocketFactory(f));
        this.attachments = null;
        this.connectionStatistics = new LDAPConnectionStatistics();
        this.connectionName = null;
        this.connectionPoolName = null;
        this.cachedSchema = null;
        this.timer = null;
        this.serverSet = null;
        this.referralConnector = this.connectionOptions.getReferralConnector();
        if (this.referralConnector == null) {
            this.referralConnector = this;
        }
    }

    public LDAPConnection(@NotNull String host, int port) throws LDAPException {
        this(null, null, host, port);
    }

    public LDAPConnection(@Nullable LDAPConnectionOptions connectionOptions, @NotNull String host, int port) throws LDAPException {
        this(null, connectionOptions, host, port);
    }

    public LDAPConnection(@Nullable SocketFactory socketFactory, @NotNull String host, int port) throws LDAPException {
        this(socketFactory, null, host, port);
    }

    public LDAPConnection(@Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions connectionOptions, @NotNull String host, int port) throws LDAPException {
        this(socketFactory, connectionOptions);
        this.connect(host, port);
    }

    public LDAPConnection(@NotNull String host, int port, @Nullable String bindDN, @Nullable String bindPassword) throws LDAPException {
        this(null, null, host, port, bindDN, bindPassword);
    }

    public LDAPConnection(@Nullable LDAPConnectionOptions connectionOptions, @NotNull String host, int port, @Nullable String bindDN, @Nullable String bindPassword) throws LDAPException {
        this(null, connectionOptions, host, port, bindDN, bindPassword);
    }

    public LDAPConnection(@Nullable SocketFactory socketFactory, @NotNull String host, int port, @Nullable String bindDN, @Nullable String bindPassword) throws LDAPException {
        this(socketFactory, null, host, port, bindDN, bindPassword);
    }

    public LDAPConnection(@Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions connectionOptions, @NotNull String host, int port, @Nullable String bindDN, @Nullable String bindPassword) throws LDAPException {
        this(socketFactory, connectionOptions, host, port);
        try {
            this.bind(new SimpleBindRequest(bindDN, bindPassword));
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.setDisconnectInfo(DisconnectType.BIND_FAILED, null, le);
            this.close();
            throw le;
        }
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void connect(@NotNull String host, int port) throws LDAPException {
        this.connect(host, port, this.connectionOptions.getConnectTimeoutMillis());
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void connect(@NotNull String host, int port, int timeout) throws LDAPException {
        InetAddress inetAddress;
        try {
            inetAddress = this.connectionOptions.getNameResolver().getByName(host);
        }
        catch (Exception e) {
            Debug.debugException(e);
            LDAPException connectException = new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONN_RESOLVE_ERROR.get(host, StaticUtils.getExceptionMessage(e)), e);
            LDAPConnectionLogger logger = this.connectionOptions.getConnectionLogger();
            if (logger != null) {
                logger.logConnectFailure(this, host, port, connectException);
            }
            throw connectException;
        }
        this.connect(host, inetAddress, port, timeout);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void connect(@NotNull InetAddress inetAddress, int port, int timeout) throws LDAPException {
        this.connect(this.connectionOptions.getNameResolver().getHostName(inetAddress), inetAddress, port, timeout);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void connect(@NotNull String host, @NotNull InetAddress inetAddress, int port, int timeout) throws LDAPException {
        Validator.ensureNotNull(host, inetAddress, port);
        this.needsReconnect.set(false);
        this.hostPort = host + ':' + port;
        this.lastCommunicationTime = -1L;
        this.startTLSRequest = null;
        if (this.isConnected()) {
            this.setDisconnectInfo(DisconnectType.RECONNECT, null, null);
            this.close();
        }
        this.lastUsedSocketFactory = this.socketFactory;
        this.reconnectAddress = host;
        this.reconnectPort = port;
        this.cachedSchema = null;
        this.unbindRequestSent = false;
        this.disconnectInfo.set(null);
        try {
            this.connectionStatistics.incrementNumConnects();
            this.connectionInternals = new LDAPConnectionInternals(this, this.connectionOptions, this.lastUsedSocketFactory, host, inetAddress, port, timeout);
            this.connectionInternals.startConnectionReader();
            this.lastCommunicationTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.setDisconnectInfo(DisconnectType.LOCAL_ERROR, null, e);
            this.connectionInternals = null;
            LDAPException connectException = new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONN_CONNECT_ERROR.get(this.getHostPort(), StaticUtils.getExceptionMessage(e)), e);
            LDAPConnectionLogger logger = this.connectionOptions.getConnectionLogger();
            if (logger != null) {
                logger.logConnectFailure(this, host, port, connectException);
            }
            throw connectException;
        }
        if (this.connectionOptions.useSchema()) {
            try {
                this.cachedSchema = LDAPConnection.getCachedSchema(this);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    public void reconnect() throws LDAPException {
        ExtendedRequest startTLSExtendedRequest;
        BindRequest bindRequest;
        block11: {
            this.needsReconnect.set(false);
            if (System.currentTimeMillis() - this.lastReconnectTime < 1000L) {
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_MULTIPLE_FAILURES.get());
            }
            bindRequest = null;
            if (this.lastBindRequest != null && (bindRequest = this.lastBindRequest.getRebindRequest(this.reconnectAddress, this.reconnectPort)) == null) {
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_CANNOT_REAUTHENTICATE.get(this.getHostPort()));
            }
            startTLSExtendedRequest = this.startTLSRequest;
            this.setDisconnectInfo(DisconnectType.RECONNECT, null, null);
            this.terminate(null);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof InterruptedException)) break block11;
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONN_INTERRUPTED_DURING_RECONNECT.get(), e);
            }
        }
        this.connect(this.reconnectAddress, this.reconnectPort);
        if (startTLSExtendedRequest != null) {
            try {
                ExtendedResult startTLSResult = this.processExtendedOperation(startTLSExtendedRequest);
                if (startTLSResult.getResultCode() != ResultCode.SUCCESS) {
                    throw new LDAPException(startTLSResult);
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.setDisconnectInfo(DisconnectType.SECURITY_PROBLEM, null, le);
                this.terminate(null);
                throw le;
            }
        }
        if (bindRequest != null) {
            try {
                this.bind(bindRequest);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.setDisconnectInfo(DisconnectType.BIND_FAILED, null, le);
                this.terminate(null);
                throw le;
            }
        }
        this.lastReconnectTime = System.currentTimeMillis();
    }

    void setNeedsReconnect() {
        this.needsReconnect.set(true);
    }

    @Override
    public boolean isConnected() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return false;
        }
        if (!internals.isConnected()) {
            this.setClosed();
            return false;
        }
        return !this.needsReconnect.get();
    }

    void convertToTLS(@NotNull SSLSocketFactory sslSocketFactory) throws LDAPException {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        internals.convertToTLS(sslSocketFactory);
    }

    public void applySASLSecurityLayer(@NotNull SaslClient saslClient) throws LDAPException {
        this.applySASLQoP(saslClient);
    }

    void applySASLQoP(@NotNull SaslClient saslClient) throws LDAPException {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        internals.applySASLQoP(saslClient);
    }

    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public void setConnectionOptions(@Nullable LDAPConnectionOptions connectionOptions) {
        if (connectionOptions == null) {
            this.connectionOptions = new LDAPConnectionOptions();
        } else {
            LDAPConnectionOptions newOptions = connectionOptions.duplicate();
            if (Debug.debugEnabled(DebugType.LDAP) && newOptions.useSynchronousMode() && !connectionOptions.useSynchronousMode() && this.isConnected()) {
                Debug.debug(Level.WARNING, DebugType.LDAP, "A call to LDAPConnection.setConnectionOptions() with useSynchronousMode=true will have no effect for this connection because it is already established.  The useSynchronousMode option must be set before the connection is established to have any effect.");
            }
            this.connectionOptions = newOptions;
        }
        ReferralConnector rc = this.connectionOptions.getReferralConnector();
        this.referralConnector = rc == null ? this : rc;
    }

    @Override
    @Nullable
    public SocketFactory getLastUsedSocketFactory() {
        return this.lastUsedSocketFactory;
    }

    @Override
    @NotNull
    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(@Nullable SocketFactory socketFactory) {
        this.socketFactory = socketFactory == null ? DEFAULT_SOCKET_FACTORY : socketFactory;
    }

    @Override
    @Nullable
    public SSLSession getSSLSession() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return null;
        }
        Socket socket = internals.getSocket();
        if (socket != null && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            return sslSocket.getSession();
        }
        return null;
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    @Override
    @Nullable
    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(@Nullable String connectionName) {
        if (this.connectionPool == null) {
            this.connectionName = connectionName;
            if (this.connectionInternals != null) {
                LDAPConnectionReader reader = this.connectionInternals.getConnectionReader();
                reader.updateThreadName();
            }
        }
    }

    @Nullable
    public AbstractConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    @Nullable
    public String getConnectionPoolName() {
        return this.connectionPoolName;
    }

    void setConnectionPoolName(@Nullable String connectionPoolName) {
        this.connectionPoolName = connectionPoolName;
        if (this.connectionInternals != null) {
            LDAPConnectionReader reader = this.connectionInternals.getConnectionReader();
            reader.updateThreadName();
        }
    }

    @Nullable
    ServerSet getServerSet() {
        return this.serverSet;
    }

    void setServerSet(@Nullable ServerSet serverSet) {
        this.serverSet = serverSet;
    }

    @Override
    @NotNull
    public String getHostPort() {
        if (this.hostPort == null) {
            return "";
        }
        return this.hostPort;
    }

    @Override
    @Nullable
    public String getConnectedAddress() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return null;
        }
        return internals.getHost();
    }

    @Override
    @Nullable
    public String getConnectedIPAddress() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return null;
        }
        return internals.getInetAddress().getHostAddress();
    }

    @Override
    @Nullable
    public InetAddress getConnectedInetAddress() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return null;
        }
        return internals.getInetAddress();
    }

    @Override
    public int getConnectedPort() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return -1;
        }
        return internals.getPort();
    }

    @Override
    @Nullable
    public StackTraceElement[] getConnectStackTrace() {
        return this.connectStackTrace;
    }

    void setConnectStackTrace(@Nullable StackTraceElement[] connectStackTrace) {
        this.connectStackTrace = connectStackTrace;
    }

    @Override
    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void close() {
        this.close(StaticUtils.NO_CONTROLS);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void close(@Nullable Control[] controls) {
        this.closeRequested = true;
        this.setDisconnectInfo(DisconnectType.UNBIND, null, null);
        if (this.connectionPool == null) {
            this.terminate(controls);
        } else {
            this.connectionPool.releaseDefunctConnection(this);
        }
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    public void closeWithoutUnbind() {
        this.closeRequested = true;
        this.setDisconnectInfo(DisconnectType.CLOSED_WITHOUT_UNBIND, null, null);
        if (this.connectionPool == null) {
            this.setClosed();
        } else {
            this.connectionPool.releaseDefunctConnection(this);
        }
    }

    void terminate(@Nullable Control[] controls) {
        if (this.isConnected() && !this.unbindRequestSent) {
            try {
                LDAPConnectionLogger logger;
                this.unbindRequestSent = true;
                this.setDisconnectInfo(DisconnectType.UNBIND, null, null);
                int messageID = this.nextMessageID();
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debugLDAPRequest(Level.INFO, LDAPConnection.createUnbindRequestString(controls), messageID, this);
                }
                if ((logger = this.connectionOptions.getConnectionLogger()) != null) {
                    List<Object> controlList = controls == null ? Collections.emptyList() : Arrays.asList(controls);
                    logger.logUnbindRequest(this, messageID, controlList);
                }
                this.connectionStatistics.incrementNumUnbindRequests();
                this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)new UnbindRequestProtocolOp(), controls), this.connectionOptions.getResponseTimeoutMillis(OperationType.UNBIND));
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.setClosed();
    }

    @NotNull
    private static String createUnbindRequestString(Control ... controls) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("UnbindRequest(");
        if (controls != null && controls.length > 0) {
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
        return buffer.toString();
    }

    boolean closeRequested() {
        return this.closeRequested;
    }

    boolean unbindRequestSent() {
        return this.unbindRequestSent;
    }

    void setConnectionPool(@Nullable AbstractConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    @Override
    @Nullable
    public RootDSE getRootDSE() throws LDAPException {
        return RootDSE.getRootDSE(this);
    }

    @Override
    @Nullable
    public Schema getSchema() throws LDAPException {
        return Schema.getSchema(this, "");
    }

    @Override
    @Nullable
    public Schema getSchema(@Nullable String entryDN) throws LDAPException {
        return Schema.getSchema(this, entryDN);
    }

    @Override
    @Nullable
    public SearchResultEntry getEntry(@NotNull String dn) throws LDAPException {
        return this.getEntry(dn, null);
    }

    @Override
    @Nullable
    public SearchResultEntry getEntry(@NotNull String dn, String ... attributes) throws LDAPException {
        SearchResult result;
        Filter filter = Filter.createPresenceFilter("objectClass");
        try {
            SearchRequest searchRequest = new SearchRequest(dn, SearchScope.BASE, DereferencePolicy.NEVER, 1, 0, false, filter, attributes);
            result = this.search(searchRequest);
        }
        catch (LDAPException le) {
            if (le.getResultCode().equals(ResultCode.NO_SUCH_OBJECT)) {
                return null;
            }
            throw le;
        }
        if (!result.getResultCode().equals(ResultCode.SUCCESS)) {
            throw new LDAPException(result);
        }
        List<SearchResultEntry> entryList = result.getSearchEntries();
        if (entryList.isEmpty()) {
            return null;
        }
        return entryList.get(0);
    }

    public void abandon(@NotNull AsyncRequestID requestID) throws LDAPException {
        this.abandon(requestID, null);
    }

    public void abandon(@NotNull AsyncRequestID requestID, @Nullable Control[] controls) throws LDAPException {
        LDAPConnectionLogger logger;
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ABANDON_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        int messageID = requestID.getMessageID();
        try {
            this.connectionInternals.getConnectionReader().deregisterResponseAcceptor(messageID);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.connectionStatistics.incrementNumAbandonRequests();
        int abandonMessageID = this.nextMessageID();
        if (Debug.debugEnabled(DebugType.LDAP)) {
            Debug.debugLDAPRequest(Level.INFO, LDAPConnection.createAbandonRequestString(messageID, controls), abandonMessageID, this);
        }
        if ((logger = this.connectionOptions.getConnectionLogger()) != null) {
            List<Object> controlList = controls == null ? Collections.emptyList() : Arrays.asList(controls);
            logger.logAbandonRequest(this, abandonMessageID, messageID, controlList);
        }
        this.sendMessage(new LDAPMessage(abandonMessageID, (ProtocolOp)new AbandonRequestProtocolOp(messageID), controls), this.connectionOptions.getResponseTimeoutMillis(OperationType.ABANDON));
    }

    void abandon(int messageID, Control ... controls) throws LDAPException {
        LDAPConnectionLogger logger;
        try {
            this.connectionInternals.getConnectionReader().deregisterResponseAcceptor(messageID);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.connectionStatistics.incrementNumAbandonRequests();
        int abandonMessageID = this.nextMessageID();
        if (Debug.debugEnabled(DebugType.LDAP)) {
            Debug.debugLDAPRequest(Level.INFO, LDAPConnection.createAbandonRequestString(messageID, controls), abandonMessageID, this);
        }
        if ((logger = this.connectionOptions.getConnectionLogger()) != null) {
            List<Object> controlList = controls == null ? Collections.emptyList() : Arrays.asList(controls);
            logger.logAbandonRequest(this, abandonMessageID, messageID, controlList);
        }
        this.sendMessage(new LDAPMessage(abandonMessageID, (ProtocolOp)new AbandonRequestProtocolOp(messageID), controls), this.connectionOptions.getResponseTimeoutMillis(OperationType.ABANDON));
    }

    @NotNull
    private static String createAbandonRequestString(int idToAbandon, Control ... controls) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AbandonRequest(idToAbandon=");
        buffer.append(idToAbandon);
        if (controls != null && controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull String dn, Attribute ... attributes) throws LDAPException {
        Validator.ensureNotNull(dn, attributes);
        return this.add(new AddRequest(dn, attributes));
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull String dn, @NotNull Collection<Attribute> attributes) throws LDAPException {
        Validator.ensureNotNull(dn, attributes);
        return this.add(new AddRequest(dn, attributes));
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull Entry entry) throws LDAPException {
        Validator.ensureNotNull(entry);
        return this.add(new AddRequest(entry));
    }

    @Override
    @NotNull
    public LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        return this.add(new AddRequest(ldifLines));
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull AddRequest addRequest) throws LDAPException {
        Validator.ensureNotNull(addRequest);
        LDAPResult ldapResult = addRequest.process(this, 1);
        switch (ldapResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull ReadOnlyAddRequest addRequest) throws LDAPException {
        return this.add((AddRequest)addRequest);
    }

    @NotNull
    public AsyncRequestID asyncAdd(@NotNull AddRequest addRequest, @Nullable AsyncResultListener resultListener) throws LDAPException {
        Validator.ensureNotNull(addRequest);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        AsyncResultListener listener = resultListener == null ? DiscardAsyncListener.getInstance() : resultListener;
        return addRequest.processAsync(this, listener);
    }

    @NotNull
    public AsyncRequestID asyncAdd(@NotNull ReadOnlyAddRequest addRequest, @Nullable AsyncResultListener resultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncAdd((AddRequest)addRequest, resultListener);
    }

    @Override
    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    @NotNull
    public BindResult bind(@Nullable String bindDN, @Nullable String password) throws LDAPException {
        return this.bind(new SimpleBindRequest(bindDN, password));
    }

    @Override
    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    @NotNull
    public BindResult bind(@NotNull BindRequest bindRequest) throws LDAPException {
        Validator.ensureNotNull(bindRequest);
        BindResult bindResult = this.processBindOperation(bindRequest);
        switch (bindResult.getResultCode().intValue()) {
            case 0: {
                return bindResult;
            }
            case 14: {
                throw new SASLBindInProgressException(bindResult);
            }
        }
        throw new LDAPBindException(bindResult);
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull String dn, @NotNull String attributeName, @NotNull String assertionValue) throws LDAPException {
        Validator.ensureNotNull(dn, attributeName, assertionValue);
        return this.compare(new CompareRequest(dn, attributeName, assertionValue));
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull CompareRequest compareRequest) throws LDAPException {
        Validator.ensureNotNull(compareRequest);
        CompareResult result = compareRequest.process(this, 1);
        switch (result.getResultCode().intValue()) {
            case 5: 
            case 6: {
                return new CompareResult(result);
            }
        }
        throw new LDAPException(result);
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull ReadOnlyCompareRequest compareRequest) throws LDAPException {
        return this.compare((CompareRequest)compareRequest);
    }

    @NotNull
    public AsyncRequestID asyncCompare(@NotNull CompareRequest compareRequest, @Nullable AsyncCompareResultListener resultListener) throws LDAPException {
        Validator.ensureNotNull(compareRequest);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        AsyncCompareResultListener listener = resultListener == null ? DiscardAsyncListener.getInstance() : resultListener;
        return compareRequest.processAsync(this, listener);
    }

    @NotNull
    public AsyncRequestID asyncCompare(@NotNull ReadOnlyCompareRequest compareRequest, @Nullable AsyncCompareResultListener resultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncCompare((CompareRequest)compareRequest, resultListener);
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull String dn) throws LDAPException {
        return this.delete(new DeleteRequest(dn));
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull DeleteRequest deleteRequest) throws LDAPException {
        Validator.ensureNotNull(deleteRequest);
        LDAPResult ldapResult = deleteRequest.process(this, 1);
        switch (ldapResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull ReadOnlyDeleteRequest deleteRequest) throws LDAPException {
        return this.delete((DeleteRequest)deleteRequest);
    }

    @NotNull
    public AsyncRequestID asyncDelete(@NotNull DeleteRequest deleteRequest, @Nullable AsyncResultListener resultListener) throws LDAPException {
        Validator.ensureNotNull(deleteRequest);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        AsyncResultListener listener = resultListener == null ? DiscardAsyncListener.getInstance() : resultListener;
        return deleteRequest.processAsync(this, listener);
    }

    @NotNull
    public AsyncRequestID asyncDelete(@NotNull ReadOnlyDeleteRequest deleteRequest, @Nullable AsyncResultListener resultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncDelete((DeleteRequest)deleteRequest, resultListener);
    }

    @Override
    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull String requestOID) throws LDAPException {
        Validator.ensureNotNull(requestOID);
        return this.processExtendedOperation(new ExtendedRequest(requestOID));
    }

    @Override
    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull String requestOID, @Nullable ASN1OctetString requestValue) throws LDAPException {
        Validator.ensureNotNull(requestOID);
        return this.processExtendedOperation(new ExtendedRequest(requestOID, requestValue));
    }

    @Override
    @ThreadSafety(level=ThreadSafetyLevel.METHOD_NOT_THREADSAFE)
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        Validator.ensureNotNull(extendedRequest);
        ExtendedResult extendedResult = extendedRequest.process(this, 1);
        if (extendedResult.getOID() == null && extendedResult.getValue() == null) {
            switch (extendedResult.getResultCode().intValue()) {
                case 1: 
                case 2: 
                case 51: 
                case 52: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 90: 
                case 91: {
                    throw new LDAPException(extendedResult);
                }
            }
        }
        if (extendedResult.getResultCode() == ResultCode.SUCCESS && extendedRequest.getOID().equals("1.3.6.1.4.1.1466.20037")) {
            this.startTLSRequest = extendedRequest.duplicate();
        }
        return extendedResult;
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, @NotNull Modification mod) throws LDAPException {
        Validator.ensureNotNull(dn, mod);
        return this.modify(new ModifyRequest(dn, mod));
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, Modification ... mods) throws LDAPException {
        Validator.ensureNotNull(dn, mods);
        return this.modify(new ModifyRequest(dn, mods));
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, @NotNull List<Modification> mods) throws LDAPException {
        Validator.ensureNotNull(dn, mods);
        return this.modify(new ModifyRequest(dn, mods));
    }

    @Override
    @NotNull
    public LDAPResult modify(String ... ldifModificationLines) throws LDIFException, LDAPException {
        Validator.ensureNotNull(ldifModificationLines);
        return this.modify(new ModifyRequest(ldifModificationLines));
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull ModifyRequest modifyRequest) throws LDAPException {
        Validator.ensureNotNull(modifyRequest);
        LDAPResult ldapResult = modifyRequest.process(this, 1);
        switch (ldapResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull ReadOnlyModifyRequest modifyRequest) throws LDAPException {
        return this.modify((ModifyRequest)modifyRequest);
    }

    @NotNull
    public AsyncRequestID asyncModify(@NotNull ModifyRequest modifyRequest, @Nullable AsyncResultListener resultListener) throws LDAPException {
        Validator.ensureNotNull(modifyRequest);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        AsyncResultListener listener = resultListener == null ? DiscardAsyncListener.getInstance() : resultListener;
        return modifyRequest.processAsync(this, listener);
    }

    @NotNull
    public AsyncRequestID asyncModify(@NotNull ReadOnlyModifyRequest modifyRequest, @Nullable AsyncResultListener resultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncModify((ModifyRequest)modifyRequest, resultListener);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN) throws LDAPException {
        Validator.ensureNotNull(dn, newRDN);
        return this.modifyDN(new ModifyDNRequest(dn, newRDN, deleteOldRDN));
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN, @Nullable String newSuperiorDN) throws LDAPException {
        Validator.ensureNotNull(dn, newRDN);
        return this.modifyDN(new ModifyDNRequest(dn, newRDN, deleteOldRDN, newSuperiorDN));
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull ModifyDNRequest modifyDNRequest) throws LDAPException {
        Validator.ensureNotNull(modifyDNRequest);
        LDAPResult ldapResult = modifyDNRequest.process(this, 1);
        switch (ldapResult.getResultCode().intValue()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull ReadOnlyModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.modifyDN((ModifyDNRequest)modifyDNRequest);
    }

    @NotNull
    public AsyncRequestID asyncModifyDN(@NotNull ModifyDNRequest modifyDNRequest, @Nullable AsyncResultListener resultListener) throws LDAPException {
        Validator.ensureNotNull(modifyDNRequest);
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        AsyncResultListener listener = resultListener == null ? DiscardAsyncListener.getInstance() : resultListener;
        return modifyDNRequest.processAsync(this, listener);
    }

    @NotNull
    public AsyncRequestID asyncModifyDN(@NotNull ReadOnlyModifyDNRequest modifyDNRequest, @Nullable AsyncResultListener resultListener) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncModifyDN((ModifyDNRequest)modifyDNRequest, resultListener);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        try {
            return this.search(new SearchRequest(baseDN, scope, filter, attributes));
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        return this.search(new SearchRequest(baseDN, scope, filter, attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        try {
            return this.search(new SearchRequest(searchResultListener, baseDN, scope, filter, attributes));
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        try {
            return this.search(new SearchRequest(searchResultListener, baseDN, scope, filter, attributes));
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        try {
            return this.search(new SearchRequest(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        return this.search(new SearchRequest(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        try {
            return this.search(new SearchRequest(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        Validator.ensureNotNull(baseDN, filter);
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull SearchRequest searchRequest) throws LDAPSearchException {
        SearchResult searchResult;
        Validator.ensureNotNull(searchRequest);
        try {
            searchResult = searchRequest.process(this, 1);
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            throw lse;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        if (!searchResult.getResultCode().equals(ResultCode.SUCCESS)) {
            throw new LDAPSearchException(searchResult);
        }
        return searchResult;
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.search((SearchRequest)searchRequest);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        SearchRequest r;
        try {
            r = new SearchRequest(baseDN, scope, DereferencePolicy.NEVER, 1, 0, false, filter, attributes);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        return this.searchForEntry(r);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, DereferencePolicy.NEVER, 1, 0, false, filter, attributes));
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        SearchRequest r;
        try {
            r = new SearchRequest(baseDN, scope, derefPolicy, 1, timeLimit, typesOnly, filter, attributes);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPSearchException(le);
        }
        return this.searchForEntry(r);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, derefPolicy, 1, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull SearchRequest searchRequest) throws LDAPSearchException {
        SearchResult result;
        SearchRequest r;
        if (searchRequest.getSearchResultListener() != null || searchRequest.getSizeLimit() != 1) {
            r = new SearchRequest(searchRequest.getBaseDN(), searchRequest.getScope(), searchRequest.getDereferencePolicy(), 1, searchRequest.getTimeLimitSeconds(), searchRequest.typesOnly(), searchRequest.getFilter(), searchRequest.getAttributes());
            r.setFollowReferrals(searchRequest.followReferralsInternal());
            r.setReferralConnector(searchRequest.getReferralConnectorInternal());
            r.setResponseTimeoutMillis(searchRequest.getResponseTimeoutMillis(null));
            if (searchRequest.hasControl()) {
                r.setControlsInternal(searchRequest.getControls());
            }
        } else {
            r = searchRequest;
        }
        try {
            result = this.search(r);
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            if (lse.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return null;
            }
            throw lse;
        }
        if (result.getEntryCount() == 0) {
            return null;
        }
        return result.getSearchEntries().get(0);
    }

    @Override
    @NotNull
    public SearchResultEntry searchForEntry(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.searchForEntry((SearchRequest)searchRequest);
    }

    @NotNull
    public AsyncRequestID asyncSearch(@NotNull SearchRequest searchRequest) throws LDAPException {
        Validator.ensureNotNull(searchRequest);
        SearchResultListener searchListener = searchRequest.getSearchResultListener();
        if (searchListener == null) {
            LDAPException le = new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_ASYNC_SEARCH_NO_LISTENER.get());
            Debug.debugCodingError(le);
            throw le;
        }
        if (!(searchListener instanceof AsyncSearchResultListener)) {
            LDAPException le = new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_ASYNC_SEARCH_INVALID_LISTENER.get());
            Debug.debugCodingError(le);
            throw le;
        }
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return searchRequest.processAsync(this, (AsyncSearchResultListener)searchListener);
    }

    @NotNull
    public AsyncRequestID asyncSearch(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPException {
        if (this.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return this.asyncSearch((SearchRequest)searchRequest);
    }

    @NotNull
    public LDAPResult processOperation(@NotNull LDAPRequest request) throws LDAPException {
        if (request instanceof BindRequest) {
            return this.processBindOperation((BindRequest)request);
        }
        return request.process(this, 1);
    }

    @NotNull
    private BindResult processBindOperation(@NotNull BindRequest bindRequest) throws LDAPException {
        BindResult bindResult;
        boolean hasRetainIdentityControl = false;
        for (Control c : bindRequest.getControls()) {
            if (!c.getOID().equals("1.3.6.1.4.1.30221.2.5.3")) continue;
            hasRetainIdentityControl = true;
            break;
        }
        if (!hasRetainIdentityControl) {
            this.lastBindRequest = null;
        }
        if ((bindResult = bindRequest.process(this, 1)).getResultCode().equals(ResultCode.SUCCESS) && !hasRetainIdentityControl) {
            this.lastBindRequest = bindRequest;
            if (this.connectionOptions.useSchema()) {
                try {
                    this.cachedSchema = LDAPConnection.getCachedSchema(this);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return bindResult;
    }

    @NotNull
    public ReferralConnector getReferralConnector() {
        if (this.referralConnector == null) {
            return this;
        }
        return this.referralConnector;
    }

    public void setReferralConnector(@Nullable ReferralConnector referralConnector) {
        this.referralConnector = referralConnector == null ? this : referralConnector;
    }

    void sendMessage(@NotNull LDAPMessage message, long sendTimeoutMillis) throws LDAPException {
        LDAPConnectionInternals internals;
        if (this.needsReconnect.compareAndSet(true, false)) {
            this.reconnect();
        }
        if ((internals = this.connectionInternals) == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        boolean autoReconnect = this.connectionOptions.autoReconnect();
        internals.sendMessage(message, sendTimeoutMillis, autoReconnect);
        this.lastCommunicationTime = System.currentTimeMillis();
    }

    int nextMessageID() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return -1;
        }
        return internals.nextMessageID();
    }

    @Nullable
    DisconnectInfo getDisconnectInfo() {
        return this.disconnectInfo.get();
    }

    public void setDisconnectInfo(@NotNull DisconnectType type, @Nullable String message, @Nullable Throwable cause) {
        this.disconnectInfo.compareAndSet(null, new DisconnectInfo(this, type, message, cause));
    }

    @Nullable
    DisconnectInfo setDisconnectInfo(@Nullable DisconnectInfo info) {
        this.disconnectInfo.compareAndSet(null, info);
        return this.disconnectInfo.get();
    }

    @Override
    @Nullable
    public DisconnectType getDisconnectType() {
        DisconnectInfo di = this.disconnectInfo.get();
        if (di == null) {
            return null;
        }
        return di.getType();
    }

    @Override
    @Nullable
    public String getDisconnectMessage() {
        DisconnectInfo di = this.disconnectInfo.get();
        if (di == null) {
            return null;
        }
        return di.getMessage();
    }

    @Override
    @Nullable
    public Throwable getDisconnectCause() {
        DisconnectInfo di = this.disconnectInfo.get();
        if (di == null) {
            return null;
        }
        return di.getCause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClosed() {
        this.needsReconnect.set(false);
        if (this.disconnectInfo.get() == null) {
            try {
                StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
                StackTraceElement[] parentStackElements = new StackTraceElement[stackElements.length - 1];
                System.arraycopy(stackElements, 1, parentStackElements, 0, parentStackElements.length);
                this.setDisconnectInfo(DisconnectType.OTHER, LDAPMessages.ERR_CONN_CLOSED_BY_UNEXPECTED_CALL_PATH.get(StaticUtils.getStackTrace(parentStackElements)), null);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.connectionStatistics.incrementNumDisconnects();
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals != null) {
            internals.close();
            this.connectionInternals = null;
        }
        this.cachedSchema = null;
        this.lastCommunicationTime = -1L;
        LDAPConnection lDAPConnection = this;
        synchronized (lDAPConnection) {
            Timer t = this.timer;
            this.timer = null;
            if (t != null) {
                t.cancel();
            }
        }
    }

    void registerResponseAcceptor(int messageID, @NotNull ResponseAcceptor responseAcceptor) throws LDAPException {
        LDAPConnectionInternals internals;
        if (this.needsReconnect.compareAndSet(true, false)) {
            this.reconnect();
        }
        if ((internals = this.connectionInternals) == null) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        internals.registerResponseAcceptor(messageID, responseAcceptor);
    }

    void deregisterResponseAcceptor(int messageID) {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals != null) {
            internals.deregisterResponseAcceptor(messageID);
        }
    }

    @NotNull
    synchronized Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer("Timer thread for " + this.toString(), true);
        }
        return this.timer;
    }

    @Override
    @NotNull
    public LDAPConnection getReferralConnection(@NotNull LDAPURL referralURL, @NotNull LDAPConnection connection) throws LDAPException {
        String host = referralURL.getHost();
        int port = referralURL.getPort();
        BindRequest bindRequest = null;
        if (connection.lastBindRequest != null && (bindRequest = connection.lastBindRequest.getRebindRequest(host, port)) == null) {
            throw new LDAPException(ResultCode.REFERRAL, LDAPMessages.ERR_CONN_CANNOT_AUTHENTICATE_FOR_REFERRAL.get(host, port));
        }
        ExtendedRequest connStartTLSRequest = connection.startTLSRequest;
        LDAPConnection conn = new LDAPConnection(connection.socketFactory, connection.connectionOptions, host, port);
        if (connStartTLSRequest != null) {
            try {
                ExtendedResult startTLSResult = conn.processExtendedOperation(connStartTLSRequest);
                if (startTLSResult.getResultCode() != ResultCode.SUCCESS) {
                    throw new LDAPException(startTLSResult);
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                conn.setDisconnectInfo(DisconnectType.SECURITY_PROBLEM, null, le);
                conn.close();
                throw le;
            }
        }
        if (bindRequest != null) {
            try {
                conn.bind(bindRequest);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                conn.setDisconnectInfo(DisconnectType.BIND_FAILED, null, le);
                conn.close();
                throw le;
            }
        }
        return conn;
    }

    @Override
    @Nullable
    public BindRequest getLastBindRequest() {
        return this.lastBindRequest;
    }

    @Override
    @Nullable
    public ExtendedRequest getStartTLSRequest() {
        return this.startTLSRequest;
    }

    @Nullable
    LDAPConnectionInternals getConnectionInternals(boolean throwIfDisconnected) throws LDAPException {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null && throwIfDisconnected) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
        }
        return internals;
    }

    @Nullable
    Schema getCachedSchema() {
        return this.cachedSchema;
    }

    void setCachedSchema(@Nullable Schema cachedSchema) {
        this.cachedSchema = cachedSchema;
    }

    @Override
    public boolean synchronousMode() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return false;
        }
        return internals.synchronousMode();
    }

    @NotNull
    LDAPResponse readResponse(int messageID) throws LDAPException {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals != null) {
            LDAPResponse response = internals.getConnectionReader().readResponse(messageID);
            Debug.debugLDAPResult(response, this);
            internals.getConnectionReader().logResponse(response);
            return response;
        }
        DisconnectInfo di = this.disconnectInfo.get();
        if (di == null) {
            return new ConnectionClosedResponse(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONN_READ_RESPONSE_NOT_ESTABLISHED.get());
        }
        return new ConnectionClosedResponse(di.getType().getResultCode(), di.getMessage());
    }

    @Override
    public long getConnectTime() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals != null) {
            return internals.getConnectTime();
        }
        return -1L;
    }

    @Override
    public long getLastCommunicationTime() {
        if (this.lastCommunicationTime > 0L) {
            return this.lastCommunicationTime;
        }
        return this.getConnectTime();
    }

    void setLastCommunicationTime() {
        this.lastCommunicationTime = System.currentTimeMillis();
    }

    @Override
    @NotNull
    public LDAPConnectionStatistics getConnectionStatistics() {
        return this.connectionStatistics;
    }

    @Override
    public int getActiveOperationCount() {
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals == null) {
            return -1;
        }
        if (internals.synchronousMode()) {
            return -1;
        }
        return internals.getConnectionReader().getActiveOperationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Schema getCachedSchema(@NotNull LDAPConnection c) throws LDAPException {
        Schema s = c.getSchema();
        WeakHashSet<Schema> weakHashSet = SCHEMA_SET;
        synchronized (weakHashSet) {
            return SCHEMA_SET.addAndGet(s);
        }
    }

    @Nullable
    synchronized Object getAttachment(@NotNull String name) {
        if (this.attachments == null) {
            return null;
        }
        return this.attachments.get(name);
    }

    synchronized void setAttachment(@NotNull String name, @Nullable Object value) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Object>(StaticUtils.computeMapCapacity(10));
        }
        if (value == null) {
            this.attachments.remove(name);
        } else {
            this.attachments.put(name, value);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.setDisconnectInfo(DisconnectType.CLOSED_BY_FINALIZER, null, null);
        this.setClosed();
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("LDAPConnection(");
        String name = this.connectionName;
        String poolName = this.connectionPoolName;
        if (name != null) {
            buffer.append("name='");
            buffer.append(name);
            buffer.append("', ");
        } else if (poolName != null) {
            buffer.append("poolName='");
            buffer.append(poolName);
            buffer.append("', ");
        }
        LDAPConnectionInternals internals = this.connectionInternals;
        if (internals != null && internals.isConnected()) {
            buffer.append("connected to ");
            buffer.append(internals.getHost());
            buffer.append(':');
            buffer.append(internals.getPort());
        } else {
            buffer.append("not connected");
        }
        buffer.append(')');
    }
}

