/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.AddSchemaFileTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.AlertTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.AuditDataSecurityTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.BackupTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.CollectSupportDataTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.DelayTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.DisconnectClientTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.DumpDBDetailsTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.EnterLockdownModeTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ExecTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ExportTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.FileRetentionTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.GenerateServerProfileTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.GroovyScriptedTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ImportTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.LeaveLockdownModeTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.PopulateComposedAttributeValuesTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ReEncodeEntriesTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.RebuildTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.RefreshEncryptionSettingsTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ReloadGlobalIndexTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ReloadHTTPConnectionHandlerCertificatesTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.RemoveAttributeTypeTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.RemoveObjectClassTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.RestoreTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.RotateLogTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.SearchTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.ShutdownTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.SynchronizeEncryptionSettingsTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskState;
import com.unboundid.ldap.sdk.unboundidds.tasks.ThirdPartyTask;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class Task
implements Serializable {
    @NotNull
    private static final String ATTR_ACTUAL_START_TIME = "ds-task-actual-start-time";
    @NotNull
    private static final String ATTR_ALERT_ON_ERROR = "ds-task-alert-on-error";
    @NotNull
    private static final String ATTR_ALERT_ON_START = "ds-task-alert-on-start";
    @NotNull
    private static final String ATTR_ALERT_ON_SUCCESS = "ds-task-alert-on-success";
    @NotNull
    private static final String ATTR_COMPLETION_TIME = "ds-task-completion-time";
    @NotNull
    private static final String ATTR_DEPENDENCY_ID = "ds-task-dependency-id";
    @NotNull
    private static final String ATTR_FAILED_DEPENDENCY_ACTION = "ds-task-failed-dependency-action";
    @NotNull
    private static final String ATTR_LOG_MESSAGE = "ds-task-log-message";
    @NotNull
    private static final String ATTR_NOTIFY_ON_COMPLETION = "ds-task-notify-on-completion";
    @NotNull
    private static final String ATTR_NOTIFY_ON_ERROR = "ds-task-notify-on-error";
    @NotNull
    private static final String ATTR_NOTIFY_ON_START = "ds-task-notify-on-start";
    @NotNull
    private static final String ATTR_NOTIFY_ON_SUCCESS = "ds-task-notify-on-success";
    @NotNull
    private static final String ATTR_SCHEDULED_START_TIME = "ds-task-scheduled-start-time";
    @NotNull
    private static final String ATTR_TASK_CLASS = "ds-task-class-name";
    @NotNull
    static final String ATTR_TASK_ID = "ds-task-id";
    @NotNull
    static final String ATTR_TASK_STATE = "ds-task-state";
    @NotNull
    static final String OC_TASK = "ds-task";
    @NotNull
    static final String SCHEDULED_TASKS_BASE_DN = "cn=Scheduled Tasks,cn=tasks";
    @NotNull
    private static final TaskProperty PROPERTY_TASK_ID = new TaskProperty("ds-task-id", TaskMessages.INFO_DISPLAY_NAME_TASK_ID.get(), TaskMessages.INFO_DESCRIPTION_TASK_ID.get(), String.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_SCHEDULED_START_TIME = new TaskProperty("ds-task-scheduled-start-time", TaskMessages.INFO_DISPLAY_NAME_SCHEDULED_START_TIME.get(), TaskMessages.INFO_DESCRIPTION_SCHEDULED_START_TIME.get(), Date.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_DEPENDENCY_ID = new TaskProperty("ds-task-dependency-id", TaskMessages.INFO_DISPLAY_NAME_DEPENDENCY_ID.get(), TaskMessages.INFO_DESCRIPTION_DEPENDENCY_ID.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_FAILED_DEPENDENCY_ACTION = new TaskProperty("ds-task-failed-dependency-action", TaskMessages.INFO_DISPLAY_NAME_FAILED_DEPENDENCY_ACTION.get(), TaskMessages.INFO_DESCRIPTION_FAILED_DEPENDENCY_ACTION.get(), String.class, false, false, true, new String[]{FailedDependencyAction.CANCEL.getName(), FailedDependencyAction.DISABLE.getName(), FailedDependencyAction.PROCESS.getName()});
    @NotNull
    private static final TaskProperty PROPERTY_NOTIFY_ON_COMPLETION = new TaskProperty("ds-task-notify-on-completion", TaskMessages.INFO_DISPLAY_NAME_NOTIFY_ON_COMPLETION.get(), TaskMessages.INFO_DESCRIPTION_NOTIFY_ON_COMPLETION.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_NOTIFY_ON_ERROR = new TaskProperty("ds-task-notify-on-error", TaskMessages.INFO_DISPLAY_NAME_NOTIFY_ON_ERROR.get(), TaskMessages.INFO_DESCRIPTION_NOTIFY_ON_ERROR.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_NOTIFY_ON_SUCCESS = new TaskProperty("ds-task-notify-on-success", TaskMessages.INFO_DISPLAY_NAME_NOTIFY_ON_SUCCESS.get(), TaskMessages.INFO_DESCRIPTION_NOTIFY_ON_SUCCESS.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_NOTIFY_ON_START = new TaskProperty("ds-task-notify-on-start", TaskMessages.INFO_DISPLAY_NAME_NOTIFY_ON_START.get(), TaskMessages.INFO_DESCRIPTION_NOTIFY_ON_START.get(), String.class, false, true, true);
    @NotNull
    private static final TaskProperty PROPERTY_ALERT_ON_ERROR = new TaskProperty("ds-task-alert-on-error", TaskMessages.INFO_DISPLAY_NAME_ALERT_ON_ERROR.get(), TaskMessages.INFO_DESCRIPTION_ALERT_ON_ERROR.get(), Boolean.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_ALERT_ON_START = new TaskProperty("ds-task-alert-on-start", TaskMessages.INFO_DISPLAY_NAME_ALERT_ON_START.get(), TaskMessages.INFO_DESCRIPTION_ALERT_ON_START.get(), Boolean.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_ALERT_ON_SUCCESS = new TaskProperty("ds-task-alert-on-success", TaskMessages.INFO_DISPLAY_NAME_ALERT_ON_SUCCESS.get(), TaskMessages.INFO_DESCRIPTION_ALERT_ON_SUCCESS.get(), Boolean.class, false, false, true);
    private static final long serialVersionUID = -4082350090081577623L;
    @Nullable
    private final Boolean alertOnError;
    @Nullable
    private final Boolean alertOnStart;
    @Nullable
    private final Boolean alertOnSuccess;
    @Nullable
    private final Date actualStartTime;
    @Nullable
    private final Date completionTime;
    @Nullable
    private final Date scheduledStartTime;
    @Nullable
    private final Entry taskEntry;
    @Nullable
    private final FailedDependencyAction failedDependencyAction;
    @NotNull
    private final List<String> dependencyIDs;
    @NotNull
    private final List<String> logMessages;
    @NotNull
    private final List<String> notifyOnCompletion;
    @NotNull
    private final List<String> notifyOnError;
    @NotNull
    private final List<String> notifyOnStart;
    @NotNull
    private final List<String> notifyOnSuccess;
    @NotNull
    private final String taskClassName;
    @NotNull
    private final String taskEntryDN;
    @NotNull
    private final String taskID;
    @NotNull
    private final TaskState taskState;

    protected Task() {
        this.alertOnError = null;
        this.alertOnStart = null;
        this.alertOnSuccess = null;
        this.actualStartTime = null;
        this.completionTime = null;
        this.scheduledStartTime = null;
        this.taskEntry = null;
        this.failedDependencyAction = null;
        this.dependencyIDs = null;
        this.logMessages = null;
        this.notifyOnCompletion = null;
        this.notifyOnError = null;
        this.notifyOnStart = null;
        this.notifyOnSuccess = null;
        this.taskClassName = null;
        this.taskEntryDN = null;
        this.taskID = null;
        this.taskState = null;
    }

    public Task(@Nullable String taskID, @NotNull String taskClassName) {
        this(taskID, taskClassName, null, null, null, null, null);
    }

    public Task(@Nullable String taskID, @NotNull String taskClassName, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, taskClassName, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public Task(@Nullable String taskID, @NotNull String taskClassName, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        Validator.ensureNotNull(taskClassName);
        this.taskClassName = taskClassName;
        this.scheduledStartTime = scheduledStartTime;
        this.failedDependencyAction = failedDependencyAction;
        this.alertOnStart = alertOnStart;
        this.alertOnSuccess = alertOnSuccess;
        this.alertOnError = alertOnError;
        this.taskID = taskID == null ? CryptoHelper.getRandomUUID().toString() : taskID;
        this.dependencyIDs = dependencyIDs == null ? Collections.emptyList() : Collections.unmodifiableList(dependencyIDs);
        this.notifyOnStart = notifyOnStart == null ? Collections.emptyList() : Collections.unmodifiableList(notifyOnStart);
        this.notifyOnCompletion = notifyOnCompletion == null ? Collections.emptyList() : Collections.unmodifiableList(notifyOnCompletion);
        this.notifyOnSuccess = notifyOnSuccess == null ? Collections.emptyList() : Collections.unmodifiableList(notifyOnSuccess);
        this.notifyOnError = notifyOnError == null ? Collections.emptyList() : Collections.unmodifiableList(notifyOnError);
        this.taskEntry = null;
        this.taskEntryDN = "ds-task-id=" + this.taskID + ',' + SCHEDULED_TASKS_BASE_DN;
        this.actualStartTime = null;
        this.completionTime = null;
        this.logMessages = Collections.emptyList();
        this.taskState = TaskState.UNSCHEDULED;
    }

    public Task(@NotNull Entry entry) throws TaskException {
        this.taskEntry = entry;
        this.taskEntryDN = entry.getDN();
        if (!entry.hasObjectClass(OC_TASK)) {
            throw new TaskException(TaskMessages.ERR_TASK_MISSING_OC.get(this.taskEntryDN));
        }
        this.taskID = entry.getAttributeValue(ATTR_TASK_ID);
        if (this.taskID == null) {
            throw new TaskException(TaskMessages.ERR_TASK_NO_ID.get(this.taskEntryDN));
        }
        this.taskClassName = entry.getAttributeValue(ATTR_TASK_CLASS);
        if (this.taskClassName == null) {
            throw new TaskException(TaskMessages.ERR_TASK_NO_CLASS.get(this.taskEntryDN));
        }
        String stateStr = entry.getAttributeValue(ATTR_TASK_STATE);
        if (stateStr == null) {
            this.taskState = TaskState.UNSCHEDULED;
        } else {
            this.taskState = TaskState.forName(stateStr);
            if (this.taskState == null) {
                throw new TaskException(TaskMessages.ERR_TASK_INVALID_STATE.get(this.taskEntryDN, stateStr));
            }
        }
        String timestamp = entry.getAttributeValue(ATTR_SCHEDULED_START_TIME);
        if (timestamp == null) {
            this.scheduledStartTime = null;
        } else {
            try {
                this.scheduledStartTime = StaticUtils.decodeGeneralizedTime(timestamp);
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new TaskException(TaskMessages.ERR_TASK_CANNOT_PARSE_SCHEDULED_START_TIME.get(this.taskEntryDN, timestamp, pe.getMessage()), pe);
            }
        }
        timestamp = entry.getAttributeValue(ATTR_ACTUAL_START_TIME);
        if (timestamp == null) {
            this.actualStartTime = null;
        } else {
            try {
                this.actualStartTime = StaticUtils.decodeGeneralizedTime(timestamp);
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new TaskException(TaskMessages.ERR_TASK_CANNOT_PARSE_ACTUAL_START_TIME.get(this.taskEntryDN, timestamp, pe.getMessage()), pe);
            }
        }
        timestamp = entry.getAttributeValue(ATTR_COMPLETION_TIME);
        if (timestamp == null) {
            this.completionTime = null;
        } else {
            try {
                this.completionTime = StaticUtils.decodeGeneralizedTime(timestamp);
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new TaskException(TaskMessages.ERR_TASK_CANNOT_PARSE_COMPLETION_TIME.get(this.taskEntryDN, timestamp, pe.getMessage()), pe);
            }
        }
        String name = entry.getAttributeValue(ATTR_FAILED_DEPENDENCY_ACTION);
        this.failedDependencyAction = name == null ? null : FailedDependencyAction.forName(name);
        this.dependencyIDs = Task.parseStringList(entry, ATTR_DEPENDENCY_ID);
        this.logMessages = Task.parseStringList(entry, ATTR_LOG_MESSAGE);
        this.notifyOnStart = Task.parseStringList(entry, ATTR_NOTIFY_ON_START);
        this.notifyOnCompletion = Task.parseStringList(entry, ATTR_NOTIFY_ON_COMPLETION);
        this.notifyOnSuccess = Task.parseStringList(entry, ATTR_NOTIFY_ON_SUCCESS);
        this.notifyOnError = Task.parseStringList(entry, ATTR_NOTIFY_ON_ERROR);
        this.alertOnStart = entry.getAttributeValueAsBoolean(ATTR_ALERT_ON_START);
        this.alertOnSuccess = entry.getAttributeValueAsBoolean(ATTR_ALERT_ON_SUCCESS);
        this.alertOnError = entry.getAttributeValueAsBoolean(ATTR_ALERT_ON_ERROR);
    }

    public Task(@NotNull String taskClassName, @NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        Validator.ensureNotNull(taskClassName, properties);
        this.taskClassName = taskClassName;
        String idStr = CryptoHelper.getRandomUUID().toString();
        Date sst = null;
        String[] depIDs = StaticUtils.NO_STRINGS;
        FailedDependencyAction fda = FailedDependencyAction.CANCEL;
        String[] nob = StaticUtils.NO_STRINGS;
        String[] noc = StaticUtils.NO_STRINGS;
        String[] noe = StaticUtils.NO_STRINGS;
        String[] nos = StaticUtils.NO_STRINGS;
        Boolean aob = null;
        Boolean aoe = null;
        Boolean aos = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_TASK_ID)) {
                idStr = Task.parseString(p, values, idStr);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_SCHEDULED_START_TIME)) {
                sst = Task.parseDate(p, values, sst);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_DEPENDENCY_ID)) {
                depIDs = Task.parseStrings(p, values, depIDs);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_FAILED_DEPENDENCY_ACTION)) {
                fda = FailedDependencyAction.forName(Task.parseString(p, values, fda.getName()));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_NOTIFY_ON_START)) {
                nob = Task.parseStrings(p, values, nob);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_NOTIFY_ON_COMPLETION)) {
                noc = Task.parseStrings(p, values, noc);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_NOTIFY_ON_SUCCESS)) {
                nos = Task.parseStrings(p, values, nos);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_NOTIFY_ON_ERROR)) {
                noe = Task.parseStrings(p, values, noe);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_ALERT_ON_START)) {
                aob = Task.parseBoolean(p, values, aob);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_ALERT_ON_SUCCESS)) {
                aos = Task.parseBoolean(p, values, aos);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_ALERT_ON_ERROR)) continue;
            aoe = Task.parseBoolean(p, values, aoe);
        }
        this.taskID = idStr;
        this.scheduledStartTime = sst;
        this.dependencyIDs = Collections.unmodifiableList(Arrays.asList(depIDs));
        this.failedDependencyAction = fda;
        this.notifyOnStart = Collections.unmodifiableList(Arrays.asList(nob));
        this.notifyOnCompletion = Collections.unmodifiableList(Arrays.asList(noc));
        this.notifyOnSuccess = Collections.unmodifiableList(Arrays.asList(nos));
        this.notifyOnError = Collections.unmodifiableList(Arrays.asList(noe));
        this.alertOnStart = aob;
        this.alertOnSuccess = aos;
        this.alertOnError = aoe;
        this.taskEntry = null;
        this.taskEntryDN = "ds-task-id=" + this.taskID + ',' + SCHEDULED_TASKS_BASE_DN;
        this.actualStartTime = null;
        this.completionTime = null;
        this.logMessages = Collections.emptyList();
        this.taskState = TaskState.UNSCHEDULED;
    }

    @NotNull
    public static List<Task> getAvailableTaskTypes() {
        List<Task> taskList = Arrays.asList(new AddSchemaFileTask(), new AlertTask(), new AuditDataSecurityTask(), new BackupTask(), new CollectSupportDataTask(), new DelayTask(), new DisconnectClientTask(), new DumpDBDetailsTask(), new EnterLockdownModeTask(), new ExecTask(), new ExportTask(), new FileRetentionTask(), new GenerateServerProfileTask(), new GroovyScriptedTask(), new ImportTask(), new LeaveLockdownModeTask(), new PopulateComposedAttributeValuesTask(), new RebuildTask(), new ReEncodeEntriesTask(), new RefreshEncryptionSettingsTask(), new ReloadGlobalIndexTask(), new ReloadHTTPConnectionHandlerCertificatesTask(), new RemoveAttributeTypeTask(), new RemoveObjectClassTask(), new RestoreTask(), new RotateLogTask(), new SearchTask(), new ShutdownTask(), new SynchronizeEncryptionSettingsTask(), new ThirdPartyTask());
        return Collections.unmodifiableList(taskList);
    }

    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_GENERIC.get();
    }

    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_GENERIC.get();
    }

    @Nullable
    protected final Entry getTaskEntry() {
        return this.taskEntry;
    }

    @NotNull
    public final String getTaskEntryDN() {
        return this.taskEntryDN;
    }

    @NotNull
    public final String getTaskID() {
        return this.taskID;
    }

    @NotNull
    public final String getTaskClassName() {
        return this.taskClassName;
    }

    @NotNull
    public final TaskState getState() {
        return this.taskState;
    }

    public final boolean isPending() {
        return this.taskState.isPending();
    }

    public final boolean isRunning() {
        return this.taskState.isRunning();
    }

    public final boolean isCompleted() {
        return this.taskState.isCompleted();
    }

    @Nullable
    public final Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    @Nullable
    public final Date getActualStartTime() {
        return this.actualStartTime;
    }

    @Nullable
    public final Date getCompletionTime() {
        return this.completionTime;
    }

    @NotNull
    public final List<String> getDependencyIDs() {
        return this.dependencyIDs;
    }

    @Nullable
    public final FailedDependencyAction getFailedDependencyAction() {
        return this.failedDependencyAction;
    }

    @NotNull
    public final List<String> getLogMessages() {
        return this.logMessages;
    }

    @NotNull
    public final List<String> getNotifyOnStartAddresses() {
        return this.notifyOnStart;
    }

    @NotNull
    public final List<String> getNotifyOnCompletionAddresses() {
        return this.notifyOnCompletion;
    }

    @NotNull
    public final List<String> getNotifyOnSuccessAddresses() {
        return this.notifyOnSuccess;
    }

    @NotNull
    public final List<String> getNotifyOnErrorAddresses() {
        return this.notifyOnError;
    }

    @Nullable
    public final Boolean getAlertOnStart() {
        return this.alertOnStart;
    }

    @Nullable
    public final Boolean getAlertOnSuccess() {
        return this.alertOnSuccess;
    }

    @Nullable
    public final Boolean getAlertOnError() {
        return this.alertOnError;
    }

    @NotNull
    public final Entry createTaskEntry() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(20);
        ArrayList<String> ocValues = new ArrayList<String>(5);
        ocValues.add("top");
        ocValues.add(OC_TASK);
        ocValues.addAll(this.getAdditionalObjectClasses());
        attributes.add(new Attribute("objectClass", ocValues));
        attributes.add(new Attribute(ATTR_TASK_ID, this.taskID));
        attributes.add(new Attribute(ATTR_TASK_CLASS, this.taskClassName));
        if (this.scheduledStartTime != null) {
            attributes.add(new Attribute(ATTR_SCHEDULED_START_TIME, StaticUtils.encodeGeneralizedTime(this.scheduledStartTime)));
        }
        if (!this.dependencyIDs.isEmpty()) {
            attributes.add(new Attribute(ATTR_DEPENDENCY_ID, this.dependencyIDs));
        }
        if (this.failedDependencyAction != null) {
            attributes.add(new Attribute(ATTR_FAILED_DEPENDENCY_ACTION, this.failedDependencyAction.getName()));
        }
        if (!this.notifyOnStart.isEmpty()) {
            attributes.add(new Attribute(ATTR_NOTIFY_ON_START, this.notifyOnStart));
        }
        if (!this.notifyOnCompletion.isEmpty()) {
            attributes.add(new Attribute(ATTR_NOTIFY_ON_COMPLETION, this.notifyOnCompletion));
        }
        if (!this.notifyOnSuccess.isEmpty()) {
            attributes.add(new Attribute(ATTR_NOTIFY_ON_SUCCESS, this.notifyOnSuccess));
        }
        if (!this.notifyOnError.isEmpty()) {
            attributes.add(new Attribute(ATTR_NOTIFY_ON_ERROR, this.notifyOnError));
        }
        if (this.alertOnStart != null) {
            attributes.add(new Attribute(ATTR_ALERT_ON_START, String.valueOf(this.alertOnStart)));
        }
        if (this.alertOnSuccess != null) {
            attributes.add(new Attribute(ATTR_ALERT_ON_SUCCESS, String.valueOf(this.alertOnSuccess)));
        }
        if (this.alertOnError != null) {
            attributes.add(new Attribute(ATTR_ALERT_ON_ERROR, String.valueOf(this.alertOnError)));
        }
        attributes.addAll(this.getAdditionalAttributes());
        return new Entry(this.taskEntryDN, attributes);
    }

    protected static boolean parseBooleanValue(@NotNull Entry taskEntry, @NotNull String attributeName, boolean defaultValue) throws TaskException {
        String valueString = taskEntry.getAttributeValue(attributeName);
        if (valueString == null) {
            return defaultValue;
        }
        if (valueString.equalsIgnoreCase("true")) {
            return true;
        }
        if (valueString.equalsIgnoreCase("false")) {
            return false;
        }
        throw new TaskException(TaskMessages.ERR_TASK_CANNOT_PARSE_BOOLEAN.get(taskEntry.getDN(), valueString, attributeName));
    }

    @NotNull
    protected static List<String> parseStringList(@NotNull Entry taskEntry, @NotNull String attributeName) {
        String[] valueStrings = taskEntry.getAttributeValues(attributeName);
        if (valueStrings == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(valueStrings));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected static Boolean parseBoolean(@NotNull TaskProperty p, @NotNull List<Object> values, @Nullable Boolean defaultValue) throws TaskException {
        if (values.isEmpty()) {
            if (!p.isRequired()) return defaultValue;
            throw new TaskException(TaskMessages.ERR_TASK_REQUIRED_PROPERTY_WITHOUT_VALUES.get(p.getDisplayName()));
        }
        if (values.size() > 1) {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_NOT_MULTIVALUED.get(p.getDisplayName()));
        }
        Object o = values.get(0);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (!(o instanceof String)) throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_BOOLEAN.get(p.getDisplayName()));
        String valueStr = (String)o;
        if (valueStr.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (!valueStr.equalsIgnoreCase("false")) throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_BOOLEAN.get(p.getDisplayName()));
        return Boolean.FALSE;
    }

    @Nullable
    protected static Date parseDate(@NotNull TaskProperty p, @NotNull List<Object> values, @Nullable Date defaultValue) throws TaskException {
        Date dateValue;
        if (values.isEmpty()) {
            if (p.isRequired()) {
                throw new TaskException(TaskMessages.ERR_TASK_REQUIRED_PROPERTY_WITHOUT_VALUES.get(p.getDisplayName()));
            }
            return defaultValue;
        }
        if (values.size() > 1) {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_NOT_MULTIVALUED.get(p.getDisplayName()));
        }
        Object o = values.get(0);
        if (o instanceof Date) {
            dateValue = (Date)o;
        } else if (o instanceof String) {
            try {
                dateValue = StaticUtils.decodeGeneralizedTime((String)o);
            }
            catch (ParseException pe) {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_DATE.get(p.getDisplayName()), pe);
            }
        } else {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_DATE.get(p.getDisplayName()));
        }
        Object[] allowedValues = p.getAllowedValues();
        if (allowedValues != null) {
            boolean found = false;
            for (Object allowedValue : allowedValues) {
                if (!dateValue.equals(allowedValue)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_ALLOWED.get(p.getDisplayName(), dateValue.toString()));
            }
        }
        return dateValue;
    }

    @Nullable
    protected static Long parseLong(@NotNull TaskProperty p, @NotNull List<Object> values, @Nullable Long defaultValue) throws TaskException {
        Long longValue;
        if (values.isEmpty()) {
            if (p.isRequired()) {
                throw new TaskException(TaskMessages.ERR_TASK_REQUIRED_PROPERTY_WITHOUT_VALUES.get(p.getDisplayName()));
            }
            return defaultValue;
        }
        if (values.size() > 1) {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_NOT_MULTIVALUED.get(p.getDisplayName()));
        }
        Object o = values.get(0);
        if (o instanceof Long) {
            longValue = (Long)o;
        } else if (o instanceof Number) {
            longValue = ((Number)o).longValue();
        } else if (o instanceof String) {
            try {
                longValue = Long.parseLong((String)o);
            }
            catch (Exception e) {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_LONG.get(p.getDisplayName()), e);
            }
        } else {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_LONG.get(p.getDisplayName()));
        }
        Object[] allowedValues = p.getAllowedValues();
        if (allowedValues != null) {
            boolean found = false;
            for (Object allowedValue : allowedValues) {
                if (!longValue.equals(allowedValue)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_ALLOWED.get(p.getDisplayName(), longValue.toString()));
            }
        }
        return longValue;
    }

    @Nullable
    protected static String parseString(@NotNull TaskProperty p, @NotNull List<Object> values, @Nullable String defaultValue) throws TaskException {
        String valueStr;
        if (values.isEmpty()) {
            if (p.isRequired()) {
                throw new TaskException(TaskMessages.ERR_TASK_REQUIRED_PROPERTY_WITHOUT_VALUES.get(p.getDisplayName()));
            }
            return defaultValue;
        }
        if (values.size() > 1) {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_NOT_MULTIVALUED.get(p.getDisplayName()));
        }
        Object o = values.get(0);
        if (o instanceof String) {
            valueStr = (String)o;
        } else if (values.get(0) instanceof CharSequence) {
            valueStr = o.toString();
        } else {
            throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_STRING.get(p.getDisplayName()));
        }
        Object[] allowedValues = p.getAllowedValues();
        if (allowedValues != null) {
            boolean found = false;
            for (Object allowedValue : allowedValues) {
                String s = (String)allowedValue;
                if (!valueStr.equalsIgnoreCase(s)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_ALLOWED.get(p.getDisplayName(), valueStr));
            }
        }
        return valueStr;
    }

    @Nullable
    protected static String[] parseStrings(@NotNull TaskProperty p, @NotNull List<Object> values, @Nullable String[] defaultValues) throws TaskException {
        if (values.isEmpty()) {
            if (p.isRequired()) {
                throw new TaskException(TaskMessages.ERR_TASK_REQUIRED_PROPERTY_WITHOUT_VALUES.get(p.getDisplayName()));
            }
            return defaultValues;
        }
        String[] stringValues = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            String valueStr;
            Object o = values.get(i);
            if (o instanceof String) {
                valueStr = (String)o;
            } else if (o instanceof CharSequence) {
                valueStr = o.toString();
            } else {
                throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_STRING.get(p.getDisplayName()));
            }
            Object[] allowedValues = p.getAllowedValues();
            if (allowedValues != null) {
                boolean found = false;
                for (Object allowedValue : allowedValues) {
                    String s = (String)allowedValue;
                    if (!valueStr.equalsIgnoreCase(s)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new TaskException(TaskMessages.ERR_TASK_PROPERTY_VALUE_NOT_ALLOWED.get(p.getDisplayName(), valueStr));
                }
            }
            stringValues[i] = valueStr;
        }
        return stringValues;
    }

    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.emptyList();
    }

    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        return Collections.emptyList();
    }

    @NotNull
    public static Task decodeTask(@NotNull Entry entry) throws TaskException {
        String taskClass = entry.getAttributeValue(ATTR_TASK_CLASS);
        if (taskClass == null) {
            throw new TaskException(TaskMessages.ERR_TASK_NO_CLASS.get(entry.getDN()));
        }
        try {
            if (taskClass.equals("com.unboundid.directory.server.tasks.AddSchemaFileTask")) {
                return new AddSchemaFileTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.AlertTask")) {
                return new AlertTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.AuditDataSecurityTask")) {
                return new AuditDataSecurityTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.BackupTask")) {
                return new BackupTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.CollectSupportDataTask")) {
                return new CollectSupportDataTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.DelayTask")) {
                return new DelayTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.DisconnectClientTask")) {
                return new DisconnectClientTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.DumpDBDetailsTask")) {
                return new DumpDBDetailsTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.EnterLockdownModeTask")) {
                return new EnterLockdownModeTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.ExecTask")) {
                return new ExecTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.ExportTask")) {
                return new ExportTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.FileRetentionTask")) {
                return new FileRetentionTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.GenerateServerProfileTask")) {
                return new GenerateServerProfileTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.sdk.extensions.GroovyScriptedTask")) {
                return new GroovyScriptedTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.ImportTask")) {
                return new ImportTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.LeaveLockdownModeTask")) {
                return new LeaveLockdownModeTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.PopulateComposedAttributeValuesTask")) {
                return new PopulateComposedAttributeValuesTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.RebuildTask")) {
                return new RebuildTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.ReEncodeEntriesTask")) {
                return new ReEncodeEntriesTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.RefreshEncryptionSettingsTask")) {
                return new RefreshEncryptionSettingsTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.proxy.tasks.ReloadTask")) {
                return new ReloadGlobalIndexTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.ReloadHTTPConnectionHandlerCertificatesTask")) {
                return new ReloadHTTPConnectionHandlerCertificatesTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.RemoveAttributeTypeTask")) {
                return new RemoveAttributeTypeTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.RemoveObjectClassTask")) {
                return new RemoveObjectClassTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.RestoreTask")) {
                return new RestoreTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.RotateLogTask")) {
                return new RotateLogTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.SearchTask")) {
                return new SearchTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.tasks.ShutdownTask")) {
                return new ShutdownTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.server.crypto.SynchronizeEncryptionSettingsTask")) {
                return new SynchronizeEncryptionSettingsTask(entry);
            }
            if (taskClass.equals("com.unboundid.directory.sdk.extensions.ThirdPartyTask")) {
                return new ThirdPartyTask(entry);
            }
        }
        catch (TaskException te) {
            Debug.debugException(te);
        }
        return new Task(entry);
    }

    @NotNull
    public static List<TaskProperty> getCommonTaskProperties() {
        List<TaskProperty> taskList = Arrays.asList(PROPERTY_TASK_ID, PROPERTY_SCHEDULED_START_TIME, PROPERTY_DEPENDENCY_ID, PROPERTY_FAILED_DEPENDENCY_ACTION, PROPERTY_NOTIFY_ON_START, PROPERTY_NOTIFY_ON_COMPLETION, PROPERTY_NOTIFY_ON_SUCCESS, PROPERTY_NOTIFY_ON_ERROR, PROPERTY_ALERT_ON_START, PROPERTY_ALERT_ON_SUCCESS, PROPERTY_ALERT_ON_ERROR);
        return Collections.unmodifiableList(taskList);
    }

    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.emptyList();
    }

    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(20));
        props.put(PROPERTY_TASK_ID, Collections.singletonList(this.taskID));
        if (this.scheduledStartTime == null) {
            props.put(PROPERTY_SCHEDULED_START_TIME, Collections.emptyList());
        } else {
            props.put(PROPERTY_SCHEDULED_START_TIME, Collections.singletonList(this.scheduledStartTime));
        }
        props.put(PROPERTY_DEPENDENCY_ID, Collections.unmodifiableList(this.dependencyIDs));
        if (this.failedDependencyAction == null) {
            props.put(PROPERTY_FAILED_DEPENDENCY_ACTION, Collections.emptyList());
        } else {
            props.put(PROPERTY_FAILED_DEPENDENCY_ACTION, Collections.singletonList(this.failedDependencyAction.getName()));
        }
        props.put(PROPERTY_NOTIFY_ON_START, Collections.unmodifiableList(this.notifyOnStart));
        props.put(PROPERTY_NOTIFY_ON_COMPLETION, Collections.unmodifiableList(this.notifyOnCompletion));
        props.put(PROPERTY_NOTIFY_ON_SUCCESS, Collections.unmodifiableList(this.notifyOnSuccess));
        props.put(PROPERTY_NOTIFY_ON_ERROR, Collections.unmodifiableList(this.notifyOnError));
        if (this.alertOnStart != null) {
            props.put(PROPERTY_ALERT_ON_START, Collections.singletonList(this.alertOnStart));
        }
        if (this.alertOnSuccess != null) {
            props.put(PROPERTY_ALERT_ON_SUCCESS, Collections.singletonList(this.alertOnSuccess));
        }
        if (this.alertOnError != null) {
            props.put(PROPERTY_ALERT_ON_ERROR, Collections.singletonList(this.alertOnError));
        }
        return Collections.unmodifiableMap(props);
    }

    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public final void toString(@NotNull StringBuilder buffer) {
        buffer.append("Task(name='");
        buffer.append(this.getTaskName());
        buffer.append("', className='");
        buffer.append(this.taskClassName);
        buffer.append(", properties={");
        boolean added = false;
        for (Map.Entry<TaskProperty, List<Object>> e : this.getTaskPropertyValues().entrySet()) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append(e.getKey().getAttributeName());
            buffer.append("={");
            Iterator<Object> iterator = e.getValue().iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(String.valueOf(iterator.next()));
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        buffer.append("})");
    }
}

