/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1BitString;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum CRLDistributionPointRevocationReason {
    UNSPECIFIED("unspecified", 0),
    KEY_COMPROMISE("keyCompromise", 1),
    CA_COMPROMISE("caCompromise", 2),
    AFFILIATION_CHANGED("affiliationChanged", 3),
    SUPERSEDED("superseded", 4),
    CESSATION_OF_OPERATION("cessationOfOperation", 5),
    CERTIFICATE_HOLD("certificateHold", 6),
    PRIVILEGE_WITHDRAWN("privilegeWithdrawn", 7),
    AA_COMPROMISE("aaCompromise", 8);

    private final int bitPosition;
    @NotNull
    private final String name;

    private CRLDistributionPointRevocationReason(String name, int bitPosition) {
        this.name = name;
        this.bitPosition = bitPosition;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    int getBitPosition() {
        return this.bitPosition;
    }

    @NotNull
    static Set<CRLDistributionPointRevocationReason> getReasonSet(@NotNull ASN1BitString bitString) {
        boolean[] bits = bitString.getBits();
        EnumSet<CRLDistributionPointRevocationReason> s = EnumSet.noneOf(CRLDistributionPointRevocationReason.class);
        for (CRLDistributionPointRevocationReason r : CRLDistributionPointRevocationReason.values()) {
            if (bits.length <= r.bitPosition || !bits[r.bitPosition]) continue;
            s.add(r);
        }
        return Collections.unmodifiableSet(s);
    }

    @NotNull
    static ASN1BitString toBitString(byte type, @NotNull Set<CRLDistributionPointRevocationReason> reasons) {
        CRLDistributionPointRevocationReason[] values = CRLDistributionPointRevocationReason.values();
        boolean[] bits = new boolean[values.length];
        for (CRLDistributionPointRevocationReason r : values) {
            bits[r.bitPosition] = reasons.contains((Object)r);
        }
        return new ASN1BitString(type, bits);
    }

    @Nullable
    public static CRLDistributionPointRevocationReason forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "unspecified": {
                return UNSPECIFIED;
            }
            case "keycompromise": 
            case "key-compromise": 
            case "key_compromise": {
                return KEY_COMPROMISE;
            }
            case "cacompromise": 
            case "ca-compromise": 
            case "ca_compromise": {
                return CA_COMPROMISE;
            }
            case "affiliationchanged": 
            case "affiliation-changed": 
            case "affiliation_changed": {
                return AFFILIATION_CHANGED;
            }
            case "superseded": {
                return SUPERSEDED;
            }
            case "cessationofoperation": 
            case "cessation-of-operation": 
            case "cessation_of_operation": {
                return CESSATION_OF_OPERATION;
            }
            case "certificatehold": 
            case "certificate-hold": 
            case "certificate_hold": {
                return CERTIFICATE_HOLD;
            }
            case "privilegewithdrawn": 
            case "privilege-withdrawn": 
            case "privilege_withdrawn": {
                return PRIVILEGE_WITHDRAWN;
            }
            case "aacompromise": 
            case "aa-compromise": 
            case "aa_compromise": {
                return AA_COMPROMISE;
            }
        }
        return null;
    }
}

