/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.ICBORToFromConverter;
import com.upokecenter.cbor.PropertyMap;
import java.util.UUID;

class CBORUuidConverter
implements ICBORToFromConverter<UUID> {
    CBORUuidConverter() {
    }

    private CBORObject ValidateObject(CBORObject obj) {
        if (obj.getType() != CBORType.ByteString) {
            throw new CBORException("UUID must be a byte String");
        }
        byte[] bytes = obj.GetByteString();
        if (bytes.length != 16) {
            throw new CBORException("UUID must be 16 bytes long");
        }
        return obj;
    }

    @Override
    public CBORObject ToCBORObject(UUID obj) {
        byte[] bytes = PropertyMap.UUIDToBytes(obj);
        return CBORObject.FromObjectAndTag((Object)bytes, 37);
    }

    @Override
    public UUID FromCBORObject(CBORObject obj) {
        if (!obj.HasMostOuterTag(37)) {
            throw new CBORException("Must have outermost tag 37");
        }
        this.ValidateObject(obj);
        byte[] bytes = obj.GetByteString();
        char[] guidChars = new char[36];
        String hex = "0123456789abcdef";
        int index = 0;
        for (int i = 0; i < 16; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                guidChars[index++] = 45;
            }
            guidChars[index++] = hex.charAt(bytes[i] >> 4 & 0xF);
            guidChars[index++] = hex.charAt(bytes[i] & 0xF);
        }
        String guidString = new String(guidChars);
        return UUID.fromString(guidString);
    }
}

