/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.shared.Registration;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class DataProviderWrapper<T, F, M>
implements DataProvider<T, F> {
    protected DataProvider<T, M> dataProvider;

    protected DataProviderWrapper(DataProvider<T, M> dataProvider) {
        this.dataProvider = Objects.requireNonNull(dataProvider, "The wrapped data provider cannot be null.");
    }

    DataProvider<T, M> getWrappedDataProvider() {
        return this.dataProvider;
    }

    @Override
    public boolean isInMemory() {
        return this.dataProvider.isInMemory();
    }

    @Override
    public void refreshAll() {
        this.dataProvider.refreshAll();
    }

    @Override
    public void refreshItem(T item) {
        this.dataProvider.refreshItem(item);
    }

    @Override
    public Object getId(T item) {
        return this.dataProvider.getId(item);
    }

    @Override
    public Registration addDataProviderListener(DataProviderListener<T> listener) {
        return this.dataProvider.addDataProviderListener(listener);
    }

    @Override
    public int size(Query<T, F> t) {
        return this.dataProvider.size(new Query<T, M>(t.getOffset(), t.getLimit(), t.getSortOrders(), t.getInMemorySorting(), this.getFilter(t)));
    }

    @Override
    public Stream<T> fetch(Query<T, F> t) {
        return this.dataProvider.fetch(new Query<T, M>(t.getOffset(), t.getLimit(), t.getSortOrders(), t.getInMemorySorting(), this.getFilter(t)));
    }

    protected abstract M getFilter(Query<T, F> var1);

    public String toString() {
        return "DataProviderWrapper(" + this.dataProvider + ")";
    }
}

