/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.server.communication.data;

import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.KeyMapper;
import com.vaadin.shared.Range;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.shared.data.DataProviderRpc;
import com.vaadin.shared.data.DataRequestRpc;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.server.communication.data.DataGenerator;
import com.vaadin.v7.ui.Grid;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class RpcDataProviderExtension
extends AbstractExtension {
    private final Container.Indexed container;
    private DataProviderRpc rpc;
    private final Container.ItemSetChangeListener itemListener = new Container.ItemSetChangeListener(){

        @Override
        public void containerItemSetChange(Container.ItemSetChangeEvent event) {
            if (event instanceof Container.Indexed.ItemAddEvent) {
                Container.Indexed.ItemAddEvent addEvent = (Container.Indexed.ItemAddEvent)event;
                int firstIndex = addEvent.getFirstIndex();
                int count = addEvent.getAddedItemsCount();
                RpcDataProviderExtension.this.insertRowData(firstIndex, count);
            } else if (event instanceof Container.Indexed.ItemRemoveEvent) {
                Container.Indexed.ItemRemoveEvent removeEvent = (Container.Indexed.ItemRemoveEvent)event;
                int firstIndex = removeEvent.getFirstIndex();
                int count = removeEvent.getRemovedItemsCount();
                RpcDataProviderExtension.this.removeRowData(firstIndex, count);
            } else {
                HashSet keySet = new HashSet(RpcDataProviderExtension.this.activeItemHandler.activeItemMap.keySet());
                for (Object itemId : keySet) {
                    RpcDataProviderExtension.this.activeItemHandler.removeListener(itemId);
                }
                RpcDataProviderExtension.this.bareItemSetTriggeredSizeChange = true;
                RpcDataProviderExtension.this.markAsDirty();
            }
        }
    };
    private boolean refreshCache = false;
    private transient Set<Object> updatedItemIds;
    private transient List<Runnable> rowChanges;
    private boolean bareItemSetTriggeredSizeChange = false;
    private final Set<DataGenerator> dataGenerators = new LinkedHashSet<DataGenerator>();
    private final ActiveItemHandler activeItemHandler = new ActiveItemHandler();

    @Deprecated
    public RpcDataProviderExtension(Container.Indexed container) {
        this.container = container;
        this.rpc = (DataProviderRpc)this.getRpcProxy(DataProviderRpc.class);
        this.registerRpc((ServerRpc)new DataRequestRpc(){

            public void requestRows(int firstRow, int numberOfRows, int firstCachedRowIndex, int cacheSize) {
                RpcDataProviderExtension.this.pushRowData(firstRow, numberOfRows, firstCachedRowIndex, cacheSize);
            }

            public void dropRows(JsonArray rowKeys) {
                for (int i = 0; i < rowKeys.length(); ++i) {
                    RpcDataProviderExtension.this.activeItemHandler.dropActiveItem(RpcDataProviderExtension.this.getKeyMapper().get(rowKeys.getString(i)));
                }
            }
        });
        if (container instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)container)).addItemSetChangeListener(this.itemListener);
        }
        this.addDataGenerator(this.activeItemHandler);
    }

    public void beforeClientResponse(boolean initial) {
        if (initial || this.bareItemSetTriggeredSizeChange) {
            int size = this.container.size();
            this.rpc.resetDataAndSize(size);
            int numberOfRows = Math.min(40, size);
            this.pushRowData(0, numberOfRows, 0, 0);
        } else {
            if (this.rowChanges != null) {
                for (Runnable r : this.rowChanges) {
                    r.run();
                }
            }
            if (this.refreshCache) {
                for (Object itemId : this.activeItemHandler.getActiveItemIds()) {
                    this.updateRowData(itemId);
                }
            }
        }
        this.internalUpdateRows(this.updatedItemIds);
        if (this.rowChanges != null) {
            this.rowChanges.clear();
        }
        if (this.updatedItemIds != null) {
            this.updatedItemIds.clear();
        }
        this.refreshCache = false;
        this.bareItemSetTriggeredSizeChange = false;
        super.beforeClientResponse(initial);
    }

    private void pushRowData(int firstRowToPush, int numberOfRows, int firstCachedRowIndex, int cacheSize) {
        Range newRange = Range.withLength((int)firstRowToPush, (int)numberOfRows);
        Range cached = Range.withLength((int)firstCachedRowIndex, (int)cacheSize);
        Range fullRange = newRange;
        if (!cached.isEmpty()) {
            fullRange = newRange.combineWith(cached);
        }
        List<?> itemIds = this.container.getItemIds(fullRange.getStart(), fullRange.length());
        JsonArray rows = Json.createArray();
        int diff = 0;
        if (!cached.isEmpty() && newRange.getStart() > cached.getStart()) {
            diff = cached.length();
        }
        for (int i = 0; i < newRange.length() && i + diff < itemIds.size(); ++i) {
            Object itemId = itemIds.get(i + diff);
            Item item = this.container.getItem(itemId);
            rows.set(i, (JsonValue)this.getRowData(itemId, item));
        }
        this.rpc.setRowData(firstRowToPush, rows);
        this.activeItemHandler.addActiveItems(itemIds);
    }

    private JsonObject getRowData(Object itemId, Item item) {
        JsonObject rowObject = Json.createObject();
        for (DataGenerator dg : this.dataGenerators) {
            dg.generateData(itemId, item, rowObject);
        }
        return rowObject;
    }

    public void extend(Grid component) {
        super.extend((AbstractClientConnector)component);
    }

    public void addDataGenerator(DataGenerator generator) {
        this.dataGenerators.add(generator);
    }

    public void removeDataGenerator(DataGenerator generator) {
        this.dataGenerators.remove(generator);
    }

    private void insertRowData(final int index, final int count) {
        if (this.rowChanges == null) {
            this.rowChanges = new ArrayList<Runnable>();
        }
        if (this.rowChanges.isEmpty()) {
            this.markAsDirty();
        }
        this.rowChanges.add(new Runnable(){

            @Override
            public void run() {
                RpcDataProviderExtension.this.rpc.insertRowData(index, count);
            }
        });
    }

    private void removeRowData(final int index, final int count) {
        if (this.rowChanges == null) {
            this.rowChanges = new ArrayList<Runnable>();
        }
        if (this.rowChanges.isEmpty()) {
            this.markAsDirty();
        }
        this.rowChanges.add(new Runnable(){

            @Override
            public void run() {
                RpcDataProviderExtension.this.rpc.removeRowData(index, count);
            }
        });
    }

    public void updateRowData(Object itemId) {
        if (this.updatedItemIds == null) {
            this.updatedItemIds = new LinkedHashSet<Object>();
        }
        if (this.updatedItemIds.isEmpty()) {
            this.markAsDirty();
        }
        this.updatedItemIds.add(itemId);
    }

    private void internalUpdateRows(Set<Object> itemIds) {
        if (itemIds == null || itemIds.isEmpty()) {
            return;
        }
        Collection<Object> activeItemIds = this.activeItemHandler.getActiveItemIds();
        JsonArray rowData = Json.createArray();
        int i = 0;
        for (Object itemId : itemIds) {
            Item item;
            if (!activeItemIds.contains(itemId) || (item = this.container.getItem(itemId)) == null) continue;
            JsonObject row = this.getRowData(itemId, item);
            rowData.set(i++, (JsonValue)row);
        }
        this.rpc.updateRowData(rowData);
    }

    public void refreshCache() {
        if (!this.refreshCache) {
            this.refreshCache = true;
            this.markAsDirty();
        }
    }

    public void setParent(ClientConnector parent) {
        if (parent == null) {
            this.internalDropItems(this.activeItemHandler.getActiveItemIds());
            if (this.container instanceof Container.ItemSetChangeNotifier) {
                ((Container.ItemSetChangeNotifier)((Object)this.container)).removeItemSetChangeListener(this.itemListener);
            }
        } else if (!(parent instanceof Grid)) {
            throw new IllegalStateException("Grid is the only accepted parent type");
        }
        super.setParent(parent);
    }

    private void internalDropItems(Collection<Object> droppedItemIds) {
        for (Object itemId : droppedItemIds) {
            for (DataGenerator generator : this.dataGenerators) {
                generator.destroyData(itemId);
            }
        }
    }

    public void columnsRemoved(List<Grid.Column> removedColumns) {
        for (GridValueChangeListener l : this.activeItemHandler.getValueChangeListeners()) {
            l.removeColumns(removedColumns);
        }
    }

    public void columnsAdded(List<Grid.Column> addedColumns) {
        for (GridValueChangeListener l : this.activeItemHandler.getValueChangeListeners()) {
            l.addColumns(addedColumns);
        }
        this.refreshCache();
    }

    public KeyMapper<Object> getKeyMapper() {
        return this.activeItemHandler.keyMapper;
    }

    protected Grid getGrid() {
        return (Grid)this.getParent();
    }

    private class GridValueChangeListener
    implements Property.ValueChangeListener {
        private final Object itemId;
        private final Item item;

        public GridValueChangeListener(Object itemId, Item item) {
            assert (itemId != null) : "null itemId not accepted";
            this.itemId = itemId;
            this.item = item;
            this.internalAddColumns(RpcDataProviderExtension.this.getGrid().getColumns());
        }

        @Override
        public void valueChange(Property.ValueChangeEvent event) {
            RpcDataProviderExtension.this.updateRowData(this.itemId);
        }

        public void removeListener() {
            this.removeColumns(RpcDataProviderExtension.this.getGrid().getColumns());
        }

        public void addColumns(Collection<Grid.Column> addedColumns) {
            this.internalAddColumns(addedColumns);
            RpcDataProviderExtension.this.updateRowData(this.itemId);
        }

        private void internalAddColumns(Collection<Grid.Column> addedColumns) {
            for (Grid.Column column : addedColumns) {
                Property property = this.item.getItemProperty(column.getPropertyId());
                if (!(property instanceof Property.ValueChangeNotifier)) continue;
                ((Property.ValueChangeNotifier)((Object)property)).addValueChangeListener(this);
            }
        }

        public void removeColumns(Collection<Grid.Column> removedColumns) {
            for (Grid.Column column : removedColumns) {
                Property property = this.item.getItemProperty(column.getPropertyId());
                if (!(property instanceof Property.ValueChangeNotifier)) continue;
                ((Property.ValueChangeNotifier)((Object)property)).removeValueChangeListener(this);
            }
        }
    }

    private class ActiveItemHandler
    implements DataGenerator {
        private final Map<Object, GridValueChangeListener> activeItemMap = new HashMap<Object, GridValueChangeListener>();
        private final KeyMapper<Object> keyMapper = new KeyMapper();
        private final Set<Object> droppedItems = new HashSet<Object>();

        private ActiveItemHandler() {
        }

        public void addActiveItems(Collection<?> itemIds) {
            for (Object itemId : itemIds) {
                if (this.activeItemMap.containsKey(itemId)) continue;
                this.activeItemMap.put(itemId, new GridValueChangeListener(itemId, RpcDataProviderExtension.this.container.getItem(itemId)));
            }
            this.droppedItems.removeAll(itemIds);
            RpcDataProviderExtension.this.internalDropItems(this.droppedItems);
            this.droppedItems.clear();
        }

        public void dropActiveItem(Object itemId) {
            if (this.activeItemMap.containsKey(itemId)) {
                this.droppedItems.add(itemId);
            }
        }

        public Collection<Object> getActiveItemIds() {
            return new HashSet<Object>(this.activeItemMap.keySet());
        }

        public Collection<GridValueChangeListener> getValueChangeListeners() {
            return new HashSet<GridValueChangeListener>(this.activeItemMap.values());
        }

        @Override
        public void generateData(Object itemId, Item item, JsonObject rowData) {
            rowData.put("k", this.keyMapper.key(itemId));
        }

        @Override
        public void destroyData(Object itemId) {
            this.keyMapper.remove(itemId);
            this.removeListener(itemId);
        }

        private void removeListener(Object itemId) {
            GridValueChangeListener removed = this.activeItemMap.remove(itemId);
            if (removed != null) {
                removed.removeListener();
            }
        }
    }
}

