/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.server.VariableOwner;
import com.vaadin.ui.LegacyComponent;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.textarea.RichTextAreaState;
import com.vaadin.v7.ui.AbstractField;
import java.util.Map;
import org.jsoup.nodes.Element;

@Deprecated
public class RichTextArea
extends AbstractField<String>
implements LegacyComponent {
    private String nullRepresentation = "null";
    private boolean nullSettingAllowed = false;
    private boolean selectAll = false;

    public RichTextArea() {
        this.setValue("");
    }

    public RichTextArea(String caption) {
        this();
        this.setCaption(caption);
    }

    public RichTextArea(Property dataSource) {
        this.setPropertyDataSource(dataSource);
    }

    public RichTextArea(String caption, Property dataSource) {
        this(dataSource);
        this.setCaption(caption);
    }

    public RichTextArea(String caption, String value) {
        this.setValue(value);
        this.setCaption(caption);
    }

    public void paintContent(PaintTarget target) throws PaintException {
        String value;
        if (this.selectAll) {
            target.addAttribute("selectAll", true);
            this.selectAll = false;
        }
        if ((value = (String)this.getValue()) == null) {
            value = this.getNullRepresentation();
        }
        if (value == null) {
            throw new IllegalStateException("Null values are not allowed if the null-representation is null");
        }
        target.addVariable((VariableOwner)this, "text", value);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (readOnly) {
            this.addStyleName("v-richtextarea-readonly");
        } else {
            this.removeStyleName("v-richtextarea-readonly");
        }
    }

    public void selectAll() {
        this.selectAll = true;
        this.focus();
        this.markAsDirty();
    }

    public void changeVariables(Object source, Map<String, Object> variables) {
        if (variables.containsKey("text") && !this.isReadOnly()) {
            String newValue = (String)variables.get("text");
            String oldValue = (String)this.getValue();
            if (newValue != null && (oldValue == null || this.isNullSettingAllowed()) && newValue.equals(this.getNullRepresentation())) {
                newValue = null;
            }
            if (!(newValue == oldValue || newValue != null && newValue.equals(oldValue))) {
                boolean wasModified = this.isModified();
                this.setValue(newValue, true);
                if (wasModified != this.isModified()) {
                    this.markAsDirty();
                }
            }
        }
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    public String getNullRepresentation() {
        return this.nullRepresentation;
    }

    public boolean isNullSettingAllowed() {
        return this.nullSettingAllowed;
    }

    public void setNullRepresentation(String nullRepresentation) {
        this.nullRepresentation = nullRepresentation;
    }

    public void setNullSettingAllowed(boolean nullSettingAllowed) {
        this.nullSettingAllowed = nullSettingAllowed;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() || ((String)this.getValue()).isEmpty();
    }

    @Override
    public void clear() {
        this.setValue("");
    }

    @Override
    public void readDesign(Element design, DesignContext designContext) {
        super.readDesign(design, designContext);
        this.setValue(design.html(), false, true);
    }

    @Override
    public void writeDesign(Element design, DesignContext designContext) {
        super.writeDesign(design, designContext);
        design.html((String)this.getValue());
    }

    protected RichTextAreaState getState() {
        return (RichTextAreaState)super.getState();
    }
}

