/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.converter;

import com.vaadin.v7.data.util.converter.Converter;
import java.util.EnumSet;
import java.util.Locale;

@Deprecated
public class StringToEnumConverter
implements Converter<String, Enum> {
    @Override
    public Enum convertToModel(String value, Class<? extends Enum> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        return StringToEnumConverter.stringToEnum(value, targetType, locale);
    }

    public static <T extends Enum<T>> T stringToEnum(String value, Class<T> enumType, Locale locale) throws Converter.ConversionException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!enumType.isEnum()) {
            throw new Converter.ConversionException(enumType.getName() + " is not an enum type");
        }
        String upperCaseValue = value.toUpperCase(locale);
        Enum match = null;
        for (Enum e : EnumSet.allOf(enumType)) {
            String upperCase = StringToEnumConverter.enumToString(e, locale).toUpperCase(locale);
            if (!upperCase.equals(upperCaseValue)) continue;
            if (match != null) {
                throw new Converter.ConversionException("Both " + match.name() + " and " + e.name() + " are matching the input string " + value);
            }
            match = e;
        }
        if (match != null) {
            return (T)match;
        }
        try {
            return Enum.valueOf(enumType, upperCaseValue);
        }
        catch (Exception ee) {
            throw new Converter.ConversionException(ee);
        }
    }

    public static String enumToString(Enum<?> value, Locale locale) {
        String enumString;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((enumString = value.toString()).equals(value.name())) {
            String result = enumString.substring(0, 1).toUpperCase(locale);
            result = result + enumString.substring(1).toLowerCase(locale).replace('_', ' ');
            return result;
        }
        return enumString;
    }

    @Override
    public String convertToPresentation(Enum value, Class<? extends String> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return null;
        }
        return StringToEnumConverter.enumToString(value, locale);
    }

    @Override
    public Class<Enum> getModelType() {
        return Enum.class;
    }

    @Override
    public Class<String> getPresentationType() {
        return String.class;
    }
}

