/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4); 
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation enabling using multiple {@link JavaScript @JavaScript}
 * annotations.
 * <p>
 * <b>NOT meant to be used</b>, for multiple JavaScript dependencies,
 * {@link JavaScript @JavaScript} should be used instead.
 *
 * @author Vaadin Ltd
 * @since 8.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface InternalContainerAnnotationForJS {

    /**
     * Not to be used, instead multiple {@link JavaScript @JavaScript}
     * annotations should be used.
     *
     * @return an array of the JavaScript annotations
     */
    JavaScript[] value();
}
