/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4); 
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.shared.ui;

/**
 * Constants for border styles used on HTML elements.
 *
 * @author Vaadin Ltd
 * @since 7.0
 *
 */
public enum BorderStyle {
    /**
     * A border style used for using no border.
     */
    NONE,

    /**
     * A border style used for a minimal border.
     */
    MINIMAL,

    /**
     * A border style that indicates that the default border style should be
     * used.
     */
    DEFAULT;
}
