/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4); 
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.shared.ui.grid;

import com.vaadin.shared.ui.dnd.DropTargetState;

/**
 * State class containing parameters for GridDropTarget.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public class GridDropTargetState extends DropTargetState {

    /**
     * Stores the drop mode of the drop target Grid.
     */
    public DropMode dropMode;

    /**
     * Stores the threshold between drop locations within a row in pixels.
     * Defaults to 5px.
     *
     * @see DropMode#ON_TOP_OR_BETWEEN
     */
    public int dropThreshold = 5;

}
