/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.server;

import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.UICreateEvent;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinRequest;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.spring.internal.UIID;
import com.vaadin.ui.UI;
import com.vaadin.util.CurrentInstance;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;

public class SpringUIProvider
extends UIProvider {
    private static final long serialVersionUID = 6954428459733726004L;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final WebApplicationContext webApplicationContext;
    private final Map<String, Class<? extends UI>> pathToUIMap = new ConcurrentHashMap<String, Class<? extends UI>>();
    private final Map<String, Class<? extends UI>> wildcardPathToUIMap = new ConcurrentHashMap<String, Class<? extends UI>>();

    public SpringUIProvider(WebApplicationContext webApplicationContext) {
        if (webApplicationContext == null) {
            throw new IllegalStateException("Spring WebApplicationContext not initialized for UI provider. Use e.g. ContextLoaderListener to initialize it.");
        }
        this.webApplicationContext = webApplicationContext;
        this.detectUIs();
        if (this.pathToUIMap.isEmpty()) {
            this.logger.warn("Found no Vaadin UIs in the application context");
        }
    }

    protected void detectUIs() {
        String[] uiBeanNames;
        this.logger.info("Checking the application context for Vaadin UIs");
        for (String uiBeanName : uiBeanNames = this.getWebApplicationContext().getBeanNamesForAnnotation(SpringUI.class)) {
            Class beanType = this.getWebApplicationContext().getType(uiBeanName);
            if (!UI.class.isAssignableFrom(beanType)) continue;
            this.logger.info("Found Vaadin UI [{}]", (Object)beanType.getCanonicalName());
            String tempPath = this.deriveMappingForUI(uiBeanName);
            String path = tempPath.length() > 0 && !tempPath.startsWith("/") ? "/".concat(tempPath) : tempPath;
            Class<? extends UI> existingBeanType = this.getUIByPath(path);
            if (existingBeanType != null) {
                throw new IllegalStateException(String.format("[%s] is already mapped to the path [%s]", existingBeanType.getCanonicalName(), path));
            }
            this.logger.debug("Mapping Vaadin UI [{}] to path [{}]", (Object)beanType.getCanonicalName(), (Object)path);
            this.mapPathToUI(path, beanType);
        }
    }

    protected String deriveMappingForUI(String uiBeanName) {
        SpringUI annotation = (SpringUI)this.getWebApplicationContext().findAnnotationOnBean(uiBeanName, SpringUI.class);
        return annotation.path();
    }

    public Class<? extends UI> getUIClass(UIClassSelectionEvent uiClassSelectionEvent) {
        String path = this.extractUIPathFromRequest(uiClassSelectionEvent.getRequest());
        if (this.pathToUIMap.containsKey(path)) {
            return this.pathToUIMap.get(path);
        }
        for (Map.Entry<String, Class<? extends UI>> entry : this.wildcardPathToUIMap.entrySet()) {
            if (!path.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private String extractUIPathFromRequest(VaadinRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.length() > 1) {
            String path = pathInfo;
            int indexOfBang = path.indexOf(33);
            if (indexOfBang > -1) {
                path = path.substring(0, indexOfBang);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }
        return "";
    }

    protected WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected void mapPathToUI(String path, Class<? extends UI> uiClass) {
        if (path.endsWith("/*")) {
            this.wildcardPathToUIMap.put(path.substring(0, path.length() - 2), uiClass);
        } else {
            this.pathToUIMap.put(path, uiClass);
        }
    }

    protected Class<? extends UI> getUIByPath(String path) {
        return this.pathToUIMap.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UI createInstance(UICreateEvent event) {
        Class<UIID> key = UIID.class;
        UIID identifier = new UIID(event);
        CurrentInstance.set(key, (Object)identifier);
        try {
            this.logger.debug("Creating a new UI bean of class [{}] with identifier [{}]", (Object)event.getUIClass().getCanonicalName(), (Object)identifier);
            UI uI = (UI)this.webApplicationContext.getBean(event.getUIClass());
            return uI;
        }
        finally {
            CurrentInstance.set(key, null);
        }
    }
}

