/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.DB;
import com.versionone.Oid;
import com.versionone.apiclient.Asset;
import com.versionone.apiclient.MetaModel;
import com.versionone.apiclient.MimeType;
import com.versionone.apiclient.Query;
import com.versionone.apiclient.V1Connector;
import com.versionone.apiclient.XMLHandler;
import com.versionone.apiclient.XmlApiWriter;
import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.exceptions.ConnectionException;
import com.versionone.apiclient.exceptions.MetaException;
import com.versionone.apiclient.exceptions.NotImplementedException;
import com.versionone.apiclient.exceptions.OidException;
import com.versionone.apiclient.exceptions.V1Exception;
import com.versionone.apiclient.filters.FilterTerm;
import com.versionone.apiclient.interfaces.IAPIConnector;
import com.versionone.apiclient.interfaces.IAssetType;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.apiclient.interfaces.IMetaModel;
import com.versionone.apiclient.interfaces.IOperation;
import com.versionone.apiclient.interfaces.IServices;
import com.versionone.apiclient.services.QueryResult;
import com.versionone.apiclient.services.QueryURLBuilder;
import com.versionone.utils.V1Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Services
implements IServices {
    private IMetaModel _meta;
    private IAPIConnector _connector;
    private Oid _loggedin;
    private V1Connector _v1Connector;

    @Override
    public IMetaModel getMeta() {
        return this._meta;
    }

    public IAPIConnector get_connector() {
        return this._connector;
    }

    public Oid get_loggedin() {
        return this._loggedin;
    }

    @Override
    public V1Connector getV1Connector() {
        return this._v1Connector;
    }

    public Services(IMetaModel metaModel, IAPIConnector connector) {
        this._meta = metaModel;
        this._connector = connector;
    }

    public Services(V1Connector v1Connector) throws NullArgumentException {
        if (v1Connector == null) {
            throw new NullArgumentException("v1Connector");
        }
        this._v1Connector = v1Connector;
        this._meta = new MetaModel(this._v1Connector);
    }

    public Services(V1Connector connector, IMetaModel metaModel) throws NullArgumentException {
        if (connector == null) {
            throw new NullArgumentException("connector");
        }
        if (metaModel == null) {
            throw new NullArgumentException("metaModel");
        }
        this._v1Connector = connector;
        this._meta = metaModel;
    }

    public Services(V1Connector connector, boolean preLoadMeta) throws NullArgumentException {
        if (connector == null) {
            throw new NullArgumentException("connector");
        }
        this._v1Connector = connector;
        this._meta = new MetaModel(connector, preLoadMeta);
    }

    @Override
    public QueryResult retrieve(Query query) throws ConnectionException, APIException, OidException {
        String queryUrl = null;
        Reader reader = null;
        try {
            if (this._connector != null) {
                queryUrl = new QueryURLBuilder(query, false).toString();
                reader = this._connector.getData(queryUrl);
            } else {
                queryUrl = new QueryURLBuilder(query, true).toString();
                if (query.isHistorical()) {
                    this._v1Connector.useHistoryAPI();
                } else {
                    this._v1Connector.useDataAPI();
                }
                reader = this._v1Connector.getData(queryUrl);
            }
            Document doc = XMLHandler.buildDocument(reader, queryUrl);
            QueryResult queryResult = this.parseQueryResult(doc.getDocumentElement(), query);
            return queryResult;
        }
        catch (ConnectionException ex) {
            if (ex.getServerResponseCode() == 404) {
                QueryResult queryResult = this.getEmptyQueryResult(query);
                return queryResult;
            }
            throw ex;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private QueryResult getEmptyQueryResult(Query query) {
        return new QueryResult(new Asset[0], 0, query);
    }

    @Override
    public Asset createNew(IAssetType assetType, Oid context) throws V1Exception {
        String path;
        String string = path = this._connector != null ? "New/" + assetType.getToken() : assetType.getToken();
        if (context != null && !context.isNull()) {
            path = path + "?ctx=" + context.getToken();
        }
        Reader reader = null;
        try {
            if (this._connector != null) {
                reader = this._connector.getData(path);
            } else {
                this._v1Connector.useNewAPI();
                reader = this._v1Connector.getData(path);
            }
            Document doc = XMLHandler.buildDocument(reader, path);
            Asset asset = this.parseNewAssetNode(doc.getDocumentElement(), assetType);
            return asset;
        }
        catch (Exception ex) {
            throw new APIException("Failed to create new asset!", assetType.getToken(), ex);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Oid executeOperation(IOperation op, Oid oid) throws APIException {
        String path = this._connector != null ? "Data/" + oid.getAssetType().getToken() + "/" + oid.getKey().toString() + "?op=" + op.getName() : oid.getAssetType().getToken() + "/" + oid.getKey().toString() + "?op=" + op.getName();
        Reader reader = null;
        try {
            if (this._connector != null) {
                reader = this._connector.sendData(path, "");
            } else {
                this._v1Connector.useDataAPI();
                reader = this._v1Connector.sendData(path, "");
            }
            Document doc = XMLHandler.buildDocument(reader, path);
            Asset asset = this.parseAssetNode(doc.getDocumentElement());
            Oid oid2 = asset.getOid();
            return oid2;
        }
        catch (Exception ex) {
            throw new APIException("Error executing Operation!", op.getName(), ex);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public IAssetType getAssetType(String token) throws MetaException {
        return this._meta.getAssetType(token);
    }

    @Override
    public IAttributeDefinition getAttributeDefinition(String token) throws MetaException {
        return this._meta.getAttributeDefinition(token);
    }

    @Override
    public Oid getOid(String token) throws OidException {
        return Oid.fromToken(token, this._meta);
    }

    @Override
    public IOperation getOperation(String token) throws MetaException {
        return this._meta.getOperation(token);
    }

    @Override
    public Oid getLoggedIn() throws APIException, ConnectionException, OidException {
        if (this._loggedin == null) {
            Query q = new Query(this.getAssetType("Member"));
            FilterTerm term = new FilterTerm(this.getAttributeDefinition("Member.IsSelf"));
            term.equal(true);
            q.setFilter(term);
            QueryResult result = this.retrieve(q);
            this._loggedin = result.getAssets().length != 1 ? Oid.Null : result.getAssets()[0].getOid();
        }
        return this._loggedin;
    }

    @Override
    public void save(Asset asset) throws APIException, ConnectionException {
        this.save(asset, "");
    }

    @Override
    public void save(Asset asset, String comment) throws APIException, ConnectionException {
        if (asset.hasChanged() || asset.getOid().isNull()) {
            String path;
            StringWriter assetData = new StringWriter();
            XmlApiWriter writer = new XmlApiWriter(true);
            writer.write(asset, assetData);
            String data = assetData.toString();
            if (data.startsWith("<?xml")) {
                data = data.substring(data.indexOf("?>") + 2);
            }
            String string = path = this._connector != null ? "Data/" + asset.getAssetType().getToken() : asset.getAssetType().getToken();
            if (!asset.getOid().isNull()) {
                path = path + "/" + asset.getOid().getKey().toString();
            }
            if (comment != null && !comment.equals("")) {
                try {
                    comment = URLEncoder.encode(comment, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    comment = comment.replace(" ", "%20");
                    comment = comment.replace("&", "%26");
                    comment = comment.replace("#", "%23");
                }
                path = path + String.format("?Comment='%s'", comment);
            }
            Reader reader = null;
            try {
                if (this._connector != null) {
                    reader = this._connector.sendData(path, data);
                } else {
                    this._v1Connector.useDataAPI();
                    reader = this._v1Connector.sendData(path, data);
                }
                Document doc = XMLHandler.buildDocument(reader, path);
                this.parseSaveAssetNode(doc.getDocumentElement(), asset);
            }
            catch (OidException e) {
                throw new APIException("Error processing response", e);
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        Iterator<Asset> newAssetIter = asset.getNewAssets().values().iterator();
        while (newAssetIter.hasNext()) {
            this.save(newAssetIter.next());
        }
    }

    @Override
    public void save(Asset[] assets) throws V1Exception {
        for (Asset asset : assets) {
            this.save(asset);
        }
    }

    private QueryResult parseQueryResult(Element element, Query query) throws APIException, OidException {
        if ("History".equals(element.getNodeName())) {
            return this.parseHistoryQueryResult(element, query);
        }
        if ("Assets".equals(element.getNodeName())) {
            return this.parseAssetListQueryResult(element, query);
        }
        if ("Asset".equals(element.getNodeName())) {
            return this.parseAssetQueryResult(element, query);
        }
        if ("Attribute".equals(element.getNodeName())) {
            return this.parseAttributeQueryResult(element, query);
        }
        if ("Relation".equals(element.getNodeName())) {
            return this.parseAttributeQueryResult(element, query);
        }
        return new QueryResult(query);
    }

    private QueryResult parseAttributeQueryResult(Element element, Query query) throws APIException {
        ArrayList<Asset> list = new ArrayList<Asset>();
        Asset asset = new Asset(query.getOid());
        list.add(asset);
        IAttributeDefinition attribdef = this.getAttributeDefinition(query.getAssetType().getToken() + "." + element.getAttribute("name"));
        this.parseAttributeNode(asset, attribdef, element);
        return new QueryResult(this.assetArray(list), 1, query);
    }

    private void parseAttributeNode(Asset asset, IAttributeDefinition attribdef, Element element) throws APIException {
        String type = element.getNodeName();
        asset.ensureAttribute(attribdef);
        if ("Relation".equals(type)) {
            if (attribdef.isMultiValue()) {
                NodeList nodes = element.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    boolean add;
                    Element child = (Element)nodes.item(i);
                    String token = child.getAttribute("idref");
                    boolean bl = add = child.hasAttribute("act") && child.getAttribute("act").equals("add");
                    if (!add) {
                        asset.loadAttributeValue(attribdef, token);
                        continue;
                    }
                    asset.addAttributeValue(attribdef, token);
                }
            } else {
                boolean force;
                String token = Oid.Null.getToken();
                if (element.hasChildNodes()) {
                    token = ((Element)element.getChildNodes().item(0)).getAttribute("idref");
                }
                boolean bl = force = element.hasAttribute("act") && element.getAttribute("act").equals("set");
                if (!force) {
                    asset.loadAttributeValue(attribdef, token);
                } else {
                    asset.forceAttributeValue(attribdef, token);
                }
            }
        } else if (attribdef.isMultiValue()) {
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                boolean add;
                Element child = (Element)nodes.item(i);
                boolean bl = add = child.hasAttribute("act") && child.getAttribute("act").equals("add");
                if (!add) {
                    asset.loadAttributeValue(attribdef, child.getTextContent());
                    continue;
                }
                asset.addAttributeValue(attribdef, child.getTextContent());
            }
        } else {
            boolean force;
            Object v = DB.Null;
            if (null != element.getNodeValue()) {
                v = element.getNodeValue();
            } else if (null != element.getTextContent()) {
                v = element.getTextContent();
            }
            boolean bl = force = element.hasAttribute("act") && element.getAttribute("act").equals("set");
            if (!force) {
                asset.loadAttributeValue(attribdef, V1Util.convertXmlCrToSystemCr(v.toString()));
            } else {
                asset.forceAttributeValue(attribdef, V1Util.convertXmlCrToSystemCr(v.toString()));
            }
        }
    }

    private QueryResult parseAssetQueryResult(Element element, Query query) throws OidException, APIException {
        ArrayList<Asset> list = new ArrayList<Asset>();
        list.add(this.parseAssetNode(element));
        return new QueryResult(this.assetArray(list), 1, query);
    }

    private Asset parseNewAssetNode(Element element, IAssetType assetType) throws APIException {
        Asset asset = new Asset(assetType);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            this.parseAttributeNode(asset, asset.getAssetType().getAttributeDefinition(child.getAttribute("name")), child);
        }
        return asset;
    }

    private Asset parseAssetNode(Element element) throws APIException, OidException {
        Asset asset = new Asset(this.getOid(element.getAttribute("id")));
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element child = (Element)nodes.item(i);
            this.parseAttributeNode(asset, asset.getAssetType().getAttributeDefinition(child.getAttribute("name")), child);
        }
        return asset;
    }

    private void removeEmptyTextNodes(Element element) throws APIException {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpathExp = xpath.compile("//text()[normalize-space(.) = '']");
            NodeList emptyTextNodes = (NodeList)xpathExp.evaluate(element, XPathConstants.NODESET);
            for (int i = 0; i < emptyTextNodes.getLength(); ++i) {
                Node emptyTextNode = emptyTextNodes.item(i);
                emptyTextNode.getParentNode().removeChild(emptyTextNode);
            }
        }
        catch (XPathExpressionException e) {
            throw new APIException("Error trying to remove empty text from nodes", e);
        }
    }

    private QueryResult parseAssetListQueryResult(Element element, Query query) throws APIException, OidException {
        NodeList nodes;
        List<Asset> list = new ArrayList<Asset>();
        int total = Integer.parseInt(element.getAttribute("total"));
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            this.removeEmptyTextNodes(element);
            String nodeName = query.isHistorical() ? "History" : "Assets";
            nodes = (NodeList)xpath.compile(String.format("/%s/Asset", nodeName)).evaluate(element, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new APIException("Error reading nodes", "Asset", e);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            list.add(this.parseAssetNode((Element)nodes.item(i)));
        }
        if (query.getParentRelation() != null) {
            list = this.treeAssetListByAttribute(list, query.getParentRelation());
        }
        return new QueryResult(this.assetArray(list), total, query);
    }

    private Asset[] assetArray(List<Asset> list) {
        Asset[] rc = new Asset[list.size()];
        return list.toArray(rc);
    }

    private List<Asset> treeAssetListByAttribute(List<Asset> input, IAttributeDefinition def) throws APIException {
        HashMap<String, Asset> h = new HashMap<String, Asset>();
        for (Asset asset : input) {
            h.put(asset.getOid().getToken(), asset);
        }
        ArrayList<Asset> r = new ArrayList<Asset>();
        for (Asset asset : input) {
            Asset parent = (Asset)h.get(((Oid)asset.getAttribute(def).getValue()).getToken());
            List<Asset> t = parent != null ? parent.getChildren() : r;
            t.add(asset);
        }
        return r;
    }

    private QueryResult parseHistoryQueryResult(Element element, Query query) throws OidException, APIException {
        if (!element.hasChildNodes()) {
            return new QueryResult(query);
        }
        if (element.getFirstChild().getNodeName().equals("Asset")) {
            return this.parseAssetListQueryResult(element, query);
        }
        throw new NotImplementedException();
    }

    private void parseSaveAssetNode(Element element, Asset asset) throws OidException {
        asset.setOid(this.getOid(element.getAttribute("id")));
        asset.acceptChanges();
    }

    @Override
    public String executePassThroughQuery(String query) {
        this._v1Connector.useQueryAPI();
        return this._v1Connector.stringSendData(query, "application/json");
    }

    @Override
    public String getLocalization(IAttributeDefinition attribute) throws V1Exception {
        if (null != attribute) {
            return this.getStringData("?" + attribute.getDisplayName());
        }
        throw new NullArgumentException("IAttributeDefinition");
    }

    private String getStringData(String joinedStrings) throws ConnectionException {
        Reader stream;
        if (this._connector != null) {
            stream = this._connector.getData("loc.v1/" + joinedStrings);
        } else {
            this._v1Connector.useLocAPI();
            stream = this._v1Connector.getData(joinedStrings);
        }
        String result = null;
        try {
            result = IOUtils.toString((Reader)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getLocalization(String key) throws V1Exception {
        String path = "?" + key;
        return this.getStringData(path);
    }

    @Override
    public Map<String, String> getLocalization(ArrayList<IAttributeDefinition> attributes) throws ConnectionException {
        HashMap<String, String> locs = new HashMap<String, String>();
        ArrayList<String> data = new ArrayList<String>();
        String result = null;
        for (IAttributeDefinition iAttributeDefinition : attributes) {
            data.add("AttributeDefinition'" + iAttributeDefinition.getName() + "'" + iAttributeDefinition.getAssetType().getToken());
        }
        String path = "?[" + StringUtils.join(data, (String)",") + "]";
        Reader stream = null;
        if (this._connector != null) {
            path = "loc-2.v1/" + path;
            stream = this._connector.getData(path);
        } else {
            this._v1Connector.useLoc2API();
            stream = this._v1Connector.getData(path);
        }
        try {
            result = IOUtils.toString((Reader)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = new JSONObject(result);
        for (IAttributeDefinition iAttribute : attributes) {
            String param = "AttributeDefinition'" + iAttribute.getName() + "'" + iAttribute.getAssetType().getToken();
            locs.put(iAttribute.getToken(), jsonObject.getString(param));
        }
        return locs;
    }

    @Override
    public Oid saveAttachment(String filePath, Asset asset, String attachmentName) throws V1Exception, IOException {
        int read;
        if (StringUtils.isEmpty((String)filePath)) {
            throw new NullArgumentException("filePath");
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException(String.format("File \"%s\" does not exist.", filePath));
        }
        String mimeType = MimeType.resolve(filePath);
        IAssetType attachmentType = this._meta.getAssetType("Attachment");
        IAttributeDefinition attachmentAssetDef = attachmentType.getAttributeDefinition("Asset");
        IAttributeDefinition attachmentContent = attachmentType.getAttributeDefinition("Content");
        IAttributeDefinition attachmentContentType = attachmentType.getAttributeDefinition("ContentType");
        IAttributeDefinition attachmentFileName = attachmentType.getAttributeDefinition("Filename");
        IAttributeDefinition attachmentNameAttr = attachmentType.getAttributeDefinition("Name");
        Asset attachment = this.createNew(attachmentType, Oid.Null);
        attachment.setAttributeValue(attachmentNameAttr, attachmentName);
        attachment.setAttributeValue(attachmentFileName, filePath);
        attachment.setAttributeValue(attachmentContentType, mimeType);
        attachment.setAttributeValue(attachmentContent, "");
        attachment.setAttributeValue(attachmentAssetDef, asset.getOid());
        this.save(attachment);
        String key = attachment.getOid().getKey().toString();
        FileInputStream inStream = new FileInputStream(filePath);
        OutputStream output = this._connector != null ? this._connector.beginRequest(key.substring(key.lastIndexOf(47) + 1), null) : this._v1Connector.beginRequest(key.substring(key.lastIndexOf(47) + 1), null);
        byte[] buffer = new byte[inStream.available() + 1];
        while ((read = inStream.read(buffer, 0, buffer.length)) > 0) {
            output.write(buffer, 0, read);
        }
        if (this._connector != null) {
            this._connector.endRequest(key.substring(key.lastIndexOf(47) + 1));
        } else {
            this._v1Connector.useAttachmentApi();
            this._v1Connector.endRequest(key.substring(key.lastIndexOf(47) + 1));
        }
        return attachment.getOid();
    }

    @Override
    public InputStream getAttachment(Oid attachmentOid) throws V1Exception {
        InputStream result = null;
        if (this._connector != null) {
            result = this._connector.getAttachment(attachmentOid.getKey().toString());
        } else if (this._v1Connector != null) {
            this._v1Connector.useAttachmentApi();
            result = this._v1Connector.getAttachment(attachmentOid.getKey().toString());
        }
        return result;
    }

    @Override
    public Oid saveEmbeddedImage(String filePath, Asset asset) throws V1Exception, IOException {
        int read;
        if (StringUtils.isEmpty((String)filePath)) {
            throw new NullArgumentException("Null value " + filePath);
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException(String.format("File \"%s\" does not exist.", filePath));
        }
        String mimeType = MimeType.resolve(filePath);
        IAssetType embeddedImageType = this._meta.getAssetType("EmbeddedImage");
        Asset newEmbeddedImage = this.createNew(embeddedImageType, Oid.Null);
        IAttributeDefinition assetAttribute = embeddedImageType.getAttributeDefinition("Asset");
        IAttributeDefinition contentAttribute = embeddedImageType.getAttributeDefinition("Content");
        IAttributeDefinition contentTypeAttribute = embeddedImageType.getAttributeDefinition("ContentType");
        newEmbeddedImage.setAttributeValue(assetAttribute, asset.getOid());
        newEmbeddedImage.setAttributeValue(contentTypeAttribute, mimeType);
        newEmbeddedImage.setAttributeValue(contentAttribute, "");
        this.save(newEmbeddedImage);
        String key = newEmbeddedImage.getOid().getKey().toString();
        FileInputStream inStream = new FileInputStream(filePath);
        OutputStream output = this._connector != null ? this._connector.beginRequest(key.substring(key.lastIndexOf(47) + 1), null) : this._v1Connector.beginRequest(key.substring(key.lastIndexOf(47) + 1), null);
        byte[] buffer = new byte[inStream.available() + 1];
        while ((read = inStream.read(buffer, 0, buffer.length)) > 0) {
            output.write(buffer, 0, read);
        }
        if (this._connector != null) {
            this._connector.endRequest(key.substring(key.lastIndexOf(47) + 1));
        } else {
            this._v1Connector.useEmbeddedApi();
            this._v1Connector.endRequest(key.substring(key.lastIndexOf(47) + 1));
        }
        return newEmbeddedImage.getOid();
    }

    @Override
    public Reader getEmbeddedImage(Oid embeddedImageOid) throws V1Exception {
        Reader result = null;
        if (this._connector != null) {
            result = this._connector.getData(embeddedImageOid.getKey().toString());
        } else if (this._v1Connector != null) {
            this._v1Connector.useEmbeddedApi();
            result = this._v1Connector.getData(embeddedImageOid.getKey().toString());
        }
        return result;
    }
}

