/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.config;

import com.ververica.cdc.connectors.base.config.JdbcSourceConfig;
import com.ververica.cdc.connectors.base.config.SourceConfig;
import com.ververica.cdc.connectors.base.options.JdbcSourceOptions;
import com.ververica.cdc.connectors.base.options.SourceOptions;
import com.ververica.cdc.connectors.base.options.StartupOptions;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.flink.annotation.Internal;

@Internal
public abstract class JdbcSourceConfigFactory
implements SourceConfig.Factory<JdbcSourceConfig> {
    private static final long serialVersionUID = 1L;
    protected int port;
    protected String hostname;
    protected String username;
    protected String password;
    protected List<String> databaseList;
    protected List<String> tableList;
    protected StartupOptions startupOptions = StartupOptions.initial();
    protected boolean includeSchemaChanges = false;
    protected double distributionFactorUpper = (Double)SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue();
    protected double distributionFactorLower = (Double)SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue();
    protected int splitSize = (Integer)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue();
    protected int splitMetaGroupSize = (Integer)SourceOptions.CHUNK_META_GROUP_SIZE.defaultValue();
    protected int fetchSize = (Integer)SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue();
    protected String serverTimeZone = (String)JdbcSourceOptions.SERVER_TIME_ZONE.defaultValue();
    protected Duration connectTimeout = (Duration)JdbcSourceOptions.CONNECT_TIMEOUT.defaultValue();
    protected int connectMaxRetries = (Integer)JdbcSourceOptions.CONNECT_MAX_RETRIES.defaultValue();
    protected int connectionPoolSize = (Integer)JdbcSourceOptions.CONNECTION_POOL_SIZE.defaultValue();
    protected Properties dbzProperties;
    protected String chunkKeyColumn;

    public JdbcSourceConfigFactory hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public JdbcSourceConfigFactory port(int port) {
        this.port = port;
        return this;
    }

    public JdbcSourceConfigFactory databaseList(String ... databaseList) {
        this.databaseList = Arrays.asList(databaseList);
        return this;
    }

    public JdbcSourceConfigFactory tableList(String ... tableList) {
        this.tableList = Arrays.asList(tableList);
        return this;
    }

    public JdbcSourceConfigFactory username(String username) {
        this.username = username;
        return this;
    }

    public JdbcSourceConfigFactory password(String password) {
        this.password = password;
        return this;
    }

    public JdbcSourceConfigFactory serverTimeZone(String timeZone) {
        this.serverTimeZone = timeZone;
        return this;
    }

    public JdbcSourceConfigFactory splitSize(int splitSize) {
        this.splitSize = splitSize;
        return this;
    }

    public JdbcSourceConfigFactory splitMetaGroupSize(int splitMetaGroupSize) {
        this.splitMetaGroupSize = splitMetaGroupSize;
        return this;
    }

    public JdbcSourceConfigFactory distributionFactorUpper(double distributionFactorUpper) {
        this.distributionFactorUpper = distributionFactorUpper;
        return this;
    }

    public JdbcSourceConfigFactory distributionFactorLower(double distributionFactorLower) {
        this.distributionFactorLower = distributionFactorLower;
        return this;
    }

    public JdbcSourceConfigFactory fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public JdbcSourceConfigFactory connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public JdbcSourceConfigFactory connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public JdbcSourceConfigFactory connectMaxRetries(int connectMaxRetries) {
        this.connectMaxRetries = connectMaxRetries;
        return this;
    }

    public JdbcSourceConfigFactory includeSchemaChanges(boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
        return this;
    }

    public JdbcSourceConfigFactory debeziumProperties(Properties properties) {
        this.dbzProperties = properties;
        return this;
    }

    public JdbcSourceConfigFactory chunkKeyColumn(String chunkKeyColumn) {
        this.chunkKeyColumn = chunkKeyColumn;
        return this;
    }

    public JdbcSourceConfigFactory startupOptions(StartupOptions startupOptions) {
        switch (startupOptions.startupMode) {
            case INITIAL: 
            case LATEST_OFFSET: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported startup mode: " + (Object)((Object)startupOptions.startupMode));
            }
        }
        this.startupOptions = startupOptions;
        return this;
    }

    @Override
    public abstract JdbcSourceConfig create(int var1);
}

