/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.options;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class SourceOptions {
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_SNAPSHOT_ENABLED = ConfigOptions.key((String)"scan.incremental.snapshot.enabled").booleanType().defaultValue((Object)true).withDescription("Incremental snapshot is a new mechanism to read snapshot of a table. Compared to the old snapshot mechanism, the incremental snapshot has many advantages, including:\n(1) source can be parallel during snapshot reading, \n(2) source can perform checkpoints in the chunk granularity during snapshot reading, \n(3) source doesn't need to acquire global read lock (FLUSH TABLES WITH READ LOCK) before snapshot reading.\nIf you would like the source run in parallel, each parallel reader should have an unique server id, so the 'server-id' must be a range like '5400-6400', and the range must be larger than the parallelism.");
    public static final ConfigOption<Integer> SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE = ConfigOptions.key((String)"scan.incremental.snapshot.chunk.size").intType().defaultValue((Object)8096).withDescription("The chunk size (number of rows) of table snapshot, captured tables are split into multiple chunks when read the snapshot of table.");
    public static final ConfigOption<Integer> SCAN_SNAPSHOT_FETCH_SIZE = ConfigOptions.key((String)"scan.snapshot.fetch.size").intType().defaultValue((Object)1024).withDescription("The maximum fetch size for per poll when read table snapshot.");
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for CDC consumer, valid enumerations are \"initial\", \"earliest-offset\", \"latest-offset\", \"timestamp\"\nor \"specific-offset\"");
    public static final ConfigOption<String> SCAN_STARTUP_SPECIFIC_OFFSET_FILE = ConfigOptions.key((String)"scan.startup.specific-offset.file").stringType().noDefaultValue().withDescription("Optional offsets used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<Integer> SCAN_STARTUP_SPECIFIC_OFFSET_POS = ConfigOptions.key((String)"scan.startup.specific-offset.pos").intType().noDefaultValue().withDescription("Optional offsets used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<Long> SCAN_STARTUP_TIMESTAMP_MILLIS = ConfigOptions.key((String)"scan.startup.timestamp-millis").longType().noDefaultValue().withDescription("Optional timestamp used in case of \"timestamp\" startup mode");
    public static final ConfigOption<Integer> CHUNK_META_GROUP_SIZE = ConfigOptions.key((String)"chunk-meta.group.size").intType().defaultValue((Object)1000).withDescription("The group size of chunk meta, if the meta size exceeds the group size, the meta will be divided into multiple groups.");
    public static final ConfigOption<Double> SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND = ConfigOptions.key((String)"chunk-key.even-distribution.factor.upper-bound").doubleType().defaultValue((Object)1000.0).withFallbackKeys(new String[]{"split-key.even-distribution.factor.upper-bound"}).withDescription("The upper bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    public static final ConfigOption<Double> SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND = ConfigOptions.key((String)"chunk-key.even-distribution.factor.lower-bound").doubleType().defaultValue((Object)0.05).withFallbackKeys(new String[]{"split-key.even-distribution.factor.lower-bound"}).withDescription("The lower bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
}

