/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.meta.offset;

import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.offset.OffsetFactory;
import com.ververica.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.base.utils.SerializerUtils;
import io.debezium.relational.TableId;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.util.FlinkRuntimeException;

public interface OffsetDeserializerSerializer
extends Serializable {
    public OffsetFactory getOffsetFactory();

    default public Offset readOffsetPosition(int offsetVersion, DataInputDeserializer in) throws IOException {
        switch (offsetVersion) {
            case 1: {
                OffsetFactory offsetFactory = this.getOffsetFactory();
                return in.readBoolean() ? offsetFactory.newOffset(in.readUTF(), in.readLong()) : null;
            }
            case 2: 
            case 3: {
                return this.readOffsetPosition(in);
            }
        }
        throw new IOException("Unknown version: " + offsetVersion);
    }

    default public Offset readOffsetPosition(DataInputDeserializer in) throws IOException {
        boolean offsetNonNull = in.readBoolean();
        if (offsetNonNull) {
            int offsetBytesLength = in.readInt();
            byte[] offsetBytes = new byte[offsetBytesLength];
            in.readFully(offsetBytes);
            OffsetDeserializer offsetDeserializer = this.createOffsetDeserializer();
            return offsetDeserializer.deserialize(offsetBytes);
        }
        return null;
    }

    default public void writeOffsetPosition(Offset offset, DataOutputSerializer out) throws IOException {
        out.writeBoolean(offset != null);
        if (offset != null) {
            byte[] offsetBytes = OffsetSerializer.INSTANCE.serialize(offset);
            out.writeInt(offsetBytes.length);
            out.write(offsetBytes);
        }
    }

    default public OffsetDeserializer createOffsetDeserializer() {
        return new OffsetDeserializer(this.getOffsetFactory());
    }

    default public FinishedSnapshotSplitInfo deserialize(byte[] serialized) {
        try {
            DataInputDeserializer in = new DataInputDeserializer(serialized);
            TableId tableId = TableId.parse((String)in.readUTF());
            String splitId = in.readUTF();
            Object[] splitStart = SerializerUtils.serializedStringToRow(in.readUTF());
            Object[] splitEnd = SerializerUtils.serializedStringToRow(in.readUTF());
            OffsetFactory offsetFactory = (OffsetFactory)SerializerUtils.serializedStringToObject(in.readUTF());
            Offset highWatermark = this.readOffsetPosition(in);
            in.releaseArrays();
            return new FinishedSnapshotSplitInfo(tableId, splitId, splitStart, splitEnd, highWatermark, offsetFactory);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public static class OffsetDeserializer {
        private final OffsetFactory factory;

        public OffsetDeserializer(OffsetFactory offsetFactory) {
            this.factory = offsetFactory;
        }

        public Offset deserialize(byte[] bytes) throws IOException {
            ObjectMapper objectMapper = new ObjectMapper();
            Map offset = (Map)objectMapper.readValue(bytes, Map.class);
            return this.factory.newOffset(offset);
        }
    }

    public static class OffsetSerializer {
        public static final OffsetSerializer INSTANCE = new OffsetSerializer();

        public byte[] serialize(Offset offset) throws IOException {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsBytes(offset.getOffset());
        }
    }
}

