/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.assigner;

import com.ververica.cdc.connectors.base.config.SourceConfig;
import com.ververica.cdc.connectors.base.dialect.DataSourceDialect;
import com.ververica.cdc.connectors.base.source.assigner.SnapshotSplitAssigner;
import com.ververica.cdc.connectors.base.source.assigner.SplitAssigner;
import com.ververica.cdc.connectors.base.source.assigner.state.HybridPendingSplitsState;
import com.ververica.cdc.connectors.base.source.assigner.state.PendingSplitsState;
import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.offset.OffsetFactory;
import com.ververica.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.base.source.meta.split.SchemalessSnapshotSplit;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import com.ververica.cdc.connectors.base.source.meta.split.StreamSplit;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridSplitAssigner<C extends SourceConfig>
implements SplitAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(HybridSplitAssigner.class);
    private static final String STREAM_SPLIT_ID = "stream-split";
    private final int splitMetaGroupSize;
    private boolean isStreamSplitAssigned;
    private final SnapshotSplitAssigner<C> snapshotSplitAssigner;
    private final OffsetFactory offsetFactory;

    public HybridSplitAssigner(C sourceConfig, int currentParallelism, List<TableId> remainingTables, boolean isTableIdCaseSensitive, DataSourceDialect<C> dialect, OffsetFactory offsetFactory) {
        this(new SnapshotSplitAssigner<C>(sourceConfig, currentParallelism, remainingTables, isTableIdCaseSensitive, dialect, offsetFactory), false, sourceConfig.getSplitMetaGroupSize(), offsetFactory);
    }

    public HybridSplitAssigner(C sourceConfig, int currentParallelism, HybridPendingSplitsState checkpoint, DataSourceDialect<C> dialect, OffsetFactory offsetFactory) {
        this(new SnapshotSplitAssigner<C>(sourceConfig, currentParallelism, checkpoint.getSnapshotPendingSplits(), dialect, offsetFactory), checkpoint.isStreamSplitAssigned(), sourceConfig.getSplitMetaGroupSize(), offsetFactory);
    }

    private HybridSplitAssigner(SnapshotSplitAssigner<C> snapshotSplitAssigner, boolean isStreamSplitAssigned, int splitMetaGroupSize, OffsetFactory offsetFactory) {
        this.snapshotSplitAssigner = snapshotSplitAssigner;
        this.isStreamSplitAssigned = isStreamSplitAssigned;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.offsetFactory = offsetFactory;
    }

    @Override
    public void open() {
        this.snapshotSplitAssigner.open();
    }

    @Override
    public Optional<SourceSplitBase> getNext() {
        if (this.snapshotSplitAssigner.noMoreSplits()) {
            if (this.isStreamSplitAssigned) {
                LOG.trace("No more splits for the SnapshotSplitAssigner. StreamSplit is already assigned.");
                return Optional.empty();
            }
            if (this.snapshotSplitAssigner.isFinished()) {
                this.isStreamSplitAssigned = true;
                StreamSplit streamSplit = this.createStreamSplit();
                LOG.trace("SnapshotSplitAssigner is finished: creating a new stream split {}", (Object)streamSplit);
                return Optional.of(streamSplit);
            }
            LOG.trace("Waiting for SnapshotSplitAssigner to be finished before assigning a new stream split.");
            return Optional.empty();
        }
        return this.snapshotSplitAssigner.getNext();
    }

    @Override
    public boolean waitingForFinishedSplits() {
        return this.snapshotSplitAssigner.waitingForFinishedSplits();
    }

    @Override
    public List<FinishedSnapshotSplitInfo> getFinishedSplitInfos() {
        return this.snapshotSplitAssigner.getFinishedSplitInfos();
    }

    @Override
    public void onFinishedSplits(Map<String, Offset> splitFinishedOffsets) {
        this.snapshotSplitAssigner.onFinishedSplits(splitFinishedOffsets);
    }

    @Override
    public void addSplits(Collection<SourceSplitBase> splits) {
        ArrayList<SourceSplitBase> snapshotSplits = new ArrayList<SourceSplitBase>();
        for (SourceSplitBase split : splits) {
            if (split.isSnapshotSplit()) {
                snapshotSplits.add(split);
                continue;
            }
            this.isStreamSplitAssigned = false;
        }
        this.snapshotSplitAssigner.addSplits(snapshotSplits);
    }

    @Override
    public PendingSplitsState snapshotState(long checkpointId) {
        return new HybridPendingSplitsState(this.snapshotSplitAssigner.snapshotState(checkpointId), this.isStreamSplitAssigned);
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) {
        this.snapshotSplitAssigner.notifyCheckpointComplete(checkpointId);
    }

    @Override
    public boolean isStreamSplitAssigned() {
        return this.isStreamSplitAssigned;
    }

    @Override
    public void close() {
        this.snapshotSplitAssigner.close();
    }

    public StreamSplit createStreamSplit() {
        List assignedSnapshotSplit = this.snapshotSplitAssigner.getAssignedSplits().values().stream().sorted(Comparator.comparing(SourceSplitBase::splitId)).collect(Collectors.toList());
        Map<String, Offset> splitFinishedOffsets = this.snapshotSplitAssigner.getSplitFinishedOffsets();
        ArrayList<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos = new ArrayList<FinishedSnapshotSplitInfo>();
        Offset minOffset = null;
        for (SchemalessSnapshotSplit split : assignedSnapshotSplit) {
            Offset changeLogOffset = splitFinishedOffsets.get(split.splitId());
            if (minOffset == null || changeLogOffset.isBefore(minOffset)) {
                minOffset = changeLogOffset;
            }
            finishedSnapshotSplitInfos.add(new FinishedSnapshotSplitInfo(split.getTableId(), split.splitId(), split.getSplitStart(), split.getSplitEnd(), changeLogOffset, this.offsetFactory));
        }
        boolean divideMetaToGroups = finishedSnapshotSplitInfos.size() > this.splitMetaGroupSize;
        return new StreamSplit(STREAM_SPLIT_ID, minOffset == null ? this.offsetFactory.createInitialOffset() : minOffset, this.offsetFactory.createNoStoppingOffset(), divideMetaToGroups ? new ArrayList<FinishedSnapshotSplitInfo>() : finishedSnapshotSplitInfos, new HashMap<TableId, TableChanges.TableChange>(), finishedSnapshotSplitInfos.size());
    }
}

