/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.assigner;

import com.ververica.cdc.connectors.base.config.SourceConfig;
import com.ververica.cdc.connectors.base.dialect.DataSourceDialect;
import com.ververica.cdc.connectors.base.source.assigner.SplitAssigner;
import com.ververica.cdc.connectors.base.source.assigner.splitter.ChunkSplitter;
import com.ververica.cdc.connectors.base.source.assigner.state.SnapshotPendingSplitsState;
import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.offset.OffsetFactory;
import com.ververica.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.base.source.meta.split.SchemalessSnapshotSplit;
import com.ververica.cdc.connectors.base.source.meta.split.SnapshotSplit;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotSplitAssigner<C extends SourceConfig>
implements SplitAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotSplitAssigner.class);
    private final List<TableId> alreadyProcessedTables;
    private final List<SchemalessSnapshotSplit> remainingSplits;
    private final Map<String, SchemalessSnapshotSplit> assignedSplits;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;
    private final Map<String, Offset> splitFinishedOffsets;
    private boolean assignerFinished;
    private final C sourceConfig;
    private final int currentParallelism;
    private final LinkedList<TableId> remainingTables;
    private final boolean isRemainingTablesCheckpointed;
    private ChunkSplitter chunkSplitter;
    private boolean isTableIdCaseSensitive;
    @Nullable
    private Long checkpointIdToFinish;
    private final DataSourceDialect<C> dialect;
    private final OffsetFactory offsetFactory;

    public SnapshotSplitAssigner(C sourceConfig, int currentParallelism, List<TableId> remainingTables, boolean isTableIdCaseSensitive, DataSourceDialect<C> dialect, OffsetFactory offsetFactory) {
        this(sourceConfig, currentParallelism, new ArrayList<TableId>(), new ArrayList<SchemalessSnapshotSplit>(), new HashMap<String, SchemalessSnapshotSplit>(), new HashMap<TableId, TableChanges.TableChange>(), new HashMap<String, Offset>(), false, remainingTables, isTableIdCaseSensitive, true, dialect, offsetFactory);
    }

    public SnapshotSplitAssigner(C sourceConfig, int currentParallelism, SnapshotPendingSplitsState checkpoint, DataSourceDialect<C> dialect, OffsetFactory offsetFactory) {
        this(sourceConfig, currentParallelism, checkpoint.getAlreadyProcessedTables(), checkpoint.getRemainingSplits(), checkpoint.getAssignedSplits(), checkpoint.getTableSchemas(), checkpoint.getSplitFinishedOffsets(), checkpoint.isAssignerFinished(), checkpoint.getRemainingTables(), checkpoint.isTableIdCaseSensitive(), checkpoint.isRemainingTablesCheckpointed(), dialect, offsetFactory);
    }

    private SnapshotSplitAssigner(C sourceConfig, int currentParallelism, List<TableId> alreadyProcessedTables, List<SchemalessSnapshotSplit> remainingSplits, Map<String, SchemalessSnapshotSplit> assignedSplits, Map<TableId, TableChanges.TableChange> tableSchemas, Map<String, Offset> splitFinishedOffsets, boolean assignerFinished, List<TableId> remainingTables, boolean isTableIdCaseSensitive, boolean isRemainingTablesCheckpointed, DataSourceDialect<C> dialect, OffsetFactory offsetFactory) {
        this.sourceConfig = sourceConfig;
        this.currentParallelism = currentParallelism;
        this.alreadyProcessedTables = alreadyProcessedTables;
        this.remainingSplits = remainingSplits;
        this.assignedSplits = assignedSplits;
        this.tableSchemas = tableSchemas;
        this.splitFinishedOffsets = splitFinishedOffsets;
        this.assignerFinished = assignerFinished;
        this.remainingTables = new LinkedList<TableId>(remainingTables);
        this.isRemainingTablesCheckpointed = isRemainingTablesCheckpointed;
        this.isTableIdCaseSensitive = isTableIdCaseSensitive;
        this.dialect = dialect;
        this.offsetFactory = offsetFactory;
    }

    @Override
    public void open() {
        this.chunkSplitter = this.dialect.createChunkSplitter(this.sourceConfig);
        if (!this.isRemainingTablesCheckpointed && !this.assignerFinished) {
            try {
                List<TableId> discoverTables = this.dialect.discoverDataCollections(this.sourceConfig);
                discoverTables.removeAll(this.alreadyProcessedTables);
                this.remainingTables.addAll(discoverTables);
                this.isTableIdCaseSensitive = this.dialect.isDataCollectionIdCaseSensitive(this.sourceConfig);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to discover remaining tables to capture", (Throwable)e);
            }
        }
    }

    @Override
    public Optional<SourceSplitBase> getNext() {
        if (!this.remainingSplits.isEmpty()) {
            Iterator<SchemalessSnapshotSplit> iterator = this.remainingSplits.iterator();
            SchemalessSnapshotSplit split = iterator.next();
            iterator.remove();
            this.assignedSplits.put(split.splitId(), split);
            return Optional.of(split.toSnapshotSplit(this.tableSchemas.get(split.getTableId())));
        }
        TableId nextTable = this.remainingTables.pollFirst();
        if (nextTable != null) {
            Collection<SnapshotSplit> splits = this.chunkSplitter.generateSplits(nextTable);
            HashMap<TableId, TableChanges.TableChange> tableSchema = new HashMap<TableId, TableChanges.TableChange>();
            if (!splits.isEmpty()) {
                tableSchema.putAll(splits.iterator().next().getTableSchemas());
            }
            List schemalessSnapshotSplits = splits.stream().map(SnapshotSplit::toSchemalessSnapshotSplit).collect(Collectors.toList());
            this.remainingSplits.addAll(schemalessSnapshotSplits);
            this.tableSchemas.putAll(tableSchema);
            this.alreadyProcessedTables.add(nextTable);
            return this.getNext();
        }
        return Optional.empty();
    }

    @Override
    public boolean waitingForFinishedSplits() {
        return !this.allSplitsFinished();
    }

    @Override
    public List<FinishedSnapshotSplitInfo> getFinishedSplitInfos() {
        if (this.waitingForFinishedSplits()) {
            LOG.error("The assigner is not ready to offer finished split information, this should not be called");
            throw new FlinkRuntimeException("The assigner is not ready to offer finished split information, this should not be called");
        }
        List assignedSnapshotSplit = this.assignedSplits.values().stream().sorted(Comparator.comparing(SourceSplitBase::splitId)).collect(Collectors.toList());
        ArrayList<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos = new ArrayList<FinishedSnapshotSplitInfo>();
        for (SchemalessSnapshotSplit split : assignedSnapshotSplit) {
            Offset finishedOffset = this.splitFinishedOffsets.get(split.splitId());
            finishedSnapshotSplitInfos.add(new FinishedSnapshotSplitInfo(split.getTableId(), split.splitId(), split.getSplitStart(), split.getSplitEnd(), finishedOffset, this.offsetFactory));
        }
        return finishedSnapshotSplitInfos;
    }

    @Override
    public void onFinishedSplits(Map<String, Offset> splitFinishedOffsets) {
        this.splitFinishedOffsets.putAll(splitFinishedOffsets);
        if (this.allSplitsFinished()) {
            if (this.currentParallelism == 1) {
                this.assignerFinished = true;
                LOG.info("Snapshot split assigner received all splits finished and the job parallelism is 1, snapshot split assigner is turn into finished status.");
            } else {
                LOG.info("Snapshot split assigner received all splits finished, waiting for a complete checkpoint to mark the assigner finished.");
            }
        }
    }

    @Override
    public void addSplits(Collection<SourceSplitBase> splits) {
        for (SourceSplitBase split : splits) {
            this.tableSchemas.putAll(split.asSnapshotSplit().getTableSchemas());
            this.remainingSplits.add(split.asSnapshotSplit().toSchemalessSnapshotSplit());
            this.assignedSplits.remove(split.splitId());
            this.splitFinishedOffsets.remove(split.splitId());
        }
    }

    @Override
    public SnapshotPendingSplitsState snapshotState(long checkpointId) {
        SnapshotPendingSplitsState state = new SnapshotPendingSplitsState(this.alreadyProcessedTables, this.remainingSplits, this.assignedSplits, this.tableSchemas, this.splitFinishedOffsets, this.assignerFinished, this.remainingTables, this.isTableIdCaseSensitive, true);
        if (this.checkpointIdToFinish == null && !this.assignerFinished && this.allSplitsFinished()) {
            this.checkpointIdToFinish = checkpointId;
        }
        return state;
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) {
        if (this.checkpointIdToFinish != null && !this.assignerFinished && this.allSplitsFinished()) {
            this.assignerFinished = checkpointId >= this.checkpointIdToFinish;
            LOG.info("Snapshot split assigner is turn into finished status.");
        }
    }

    @Override
    public void close() {
    }

    public boolean noMoreSplits() {
        return this.remainingTables.isEmpty() && this.remainingSplits.isEmpty();
    }

    public boolean isFinished() {
        return this.assignerFinished;
    }

    public Map<String, SchemalessSnapshotSplit> getAssignedSplits() {
        return this.assignedSplits;
    }

    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public Map<String, Offset> getSplitFinishedOffsets() {
        return this.splitFinishedOffsets;
    }

    private boolean allSplitsFinished() {
        return this.noMoreSplits() && this.assignedSplits.size() == this.splitFinishedOffsets.size();
    }
}

