/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.meta.split;

import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitState;
import com.ververica.cdc.connectors.base.source.meta.split.StreamSplit;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.Map;
import javax.annotation.Nullable;

public class StreamSplitState
extends SourceSplitState {
    @Nullable
    private Offset startingOffset;
    @Nullable
    private Offset endingOffset;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;

    public StreamSplitState(StreamSplit split) {
        super(split);
        this.startingOffset = split.getStartingOffset();
        this.endingOffset = split.getEndingOffset();
        this.tableSchemas = split.getTableSchemas();
    }

    @Nullable
    public Offset getStartingOffset() {
        return this.startingOffset;
    }

    public void setStartingOffset(@Nullable Offset startingOffset) {
        this.startingOffset = startingOffset;
    }

    @Nullable
    public Offset getEndingOffset() {
        return this.endingOffset;
    }

    public void setEndingOffset(@Nullable Offset endingOffset) {
        this.endingOffset = endingOffset;
    }

    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public void recordSchema(TableId tableId, TableChanges.TableChange latestTableChange) {
        this.tableSchemas.put(tableId, latestTableChange);
    }

    @Override
    public StreamSplit toSourceSplit() {
        StreamSplit streamSplit = this.split.asStreamSplit();
        return new StreamSplit(streamSplit.splitId(), this.getStartingOffset(), this.getEndingOffset(), streamSplit.asStreamSplit().getFinishedSnapshotSplitInfos(), this.getTableSchemas(), streamSplit.getTotalFinishedSplitSize());
    }

    public String toString() {
        return "StreamSplitState{startingOffset=" + this.startingOffset + ", endingOffset=" + this.endingOffset + ", split=" + this.split + '}';
    }
}

