/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeRepository;
import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.util.KeepType;
import com.vladsch.flexmark.util.ValueRunnable;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import java.util.HashSet;
import java.util.Set;

public class AbbreviationRepository
extends NodeRepository<AbbreviationBlock> {
    public AbbreviationRepository(DataHolder options) {
        super((KeepType)AbbreviationExtension.ABBREVIATIONS_KEEP.getFrom(options));
    }

    public DataKey<AbbreviationRepository> getDataKey() {
        return AbbreviationExtension.ABBREVIATIONS;
    }

    public DataKey<KeepType> getKeepDataKey() {
        return AbbreviationExtension.ABBREVIATIONS_KEEP;
    }

    public Set<AbbreviationBlock> getReferencedElements(Node parent) {
        final HashSet<AbbreviationBlock> references = new HashSet<AbbreviationBlock>();
        this.visitNodes(parent, (ValueRunnable)new ValueRunnable<Node>(){

            public void run(Node value) {
                AbbreviationBlock reference;
                if (value instanceof Abbreviation && (reference = ((Abbreviation)value).getReferenceNode(AbbreviationRepository.this)) != null) {
                    references.add(reference);
                }
            }
        }, new Class[]{Abbreviation.class});
        return references;
    }
}

