/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ast.BlankLine;
import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.DefinitionTerm;
import com.vladsch.flexmark.ext.definition.internal.DefinitionOptions;
import com.vladsch.flexmark.internal.ParagraphParser;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockPreProcessor;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefinitionListItemBlockPreProcessor
implements BlockPreProcessor {
    private final DefinitionOptions options;
    Boolean blankLinesInAst;

    public DefinitionListItemBlockPreProcessor(DataHolder options) {
        this.options = new DefinitionOptions(options);
        this.blankLinesInAst = (Boolean)Parser.BLANK_LINES_IN_AST.getFrom(options);
    }

    public void preProcess(ParserState state, Block block) {
        if (block instanceof DefinitionItem) {
            DefinitionItem definitionItem = (DefinitionItem)block;
            Node previous = block.getPreviousAnyNot(new Class[]{BlankLine.class});
            DefinitionList trailingBlankLines = new DefinitionList();
            Node blankLine = definitionItem.getNext();
            if (blankLine instanceof BlankLine) {
                blankLine.extractChainTo((Node)trailingBlankLines);
            }
            if (previous instanceof Paragraph) {
                boolean hadPreviousList;
                Paragraph paragraph = (Paragraph)previous;
                Node afterParagraph = previous.getNext();
                Node paragraphPreviousNonBlank = paragraph.getPreviousAnyNot(new Class[]{BlankLine.class});
                Node paragraphPrevious = paragraph.getPrevious();
                Block paragraphParent = paragraph.getParent();
                definitionItem.unlink();
                paragraph.unlink();
                state.blockRemovedWithChildren((Block)paragraph);
                if (this.options.doubleBlankLineBreaksList) {
                    BasedSequence interSpace = paragraphPreviousNonBlank == null ? BasedSequence.NULL : BasedSequenceImpl.of((CharSequence)paragraphPreviousNonBlank.getChars().baseSubSequence(paragraphPreviousNonBlank.getChars().getEndOffset(), paragraph.getChars().getStartOffset()).normalizeEOL());
                    hadPreviousList = paragraphPreviousNonBlank instanceof DefinitionList && interSpace.countChars('\n') < 2;
                } else {
                    hadPreviousList = paragraphPreviousNonBlank instanceof DefinitionList;
                }
                DefinitionList definitionList = new DefinitionList();
                definitionList.setTight(true);
                List lines = paragraph.getContentLines();
                DefinitionTerm definitionTerm = null;
                int lineIndex = 0;
                for (BasedSequence line : lines) {
                    definitionTerm = new DefinitionTerm();
                    ParagraphParser parser = new ParagraphParser();
                    BlockContent content = new BlockContent();
                    content.add(line, paragraph.getLineIndent(lineIndex++));
                    parser.getBlock().setContent(content);
                    parser.getBlock().setCharsFromContent();
                    definitionTerm.appendChild((Node)parser.getBlock());
                    definitionTerm.setCharsFromContent();
                    state.blockParserAdded((BlockParser)parser);
                    definitionList.appendChild((Node)definitionTerm);
                    state.blockAdded((Block)definitionTerm);
                }
                if (this.blankLinesInAst.booleanValue() && afterParagraph instanceof BlankLine) {
                    while (afterParagraph instanceof BlankLine) {
                        Node next = afterParagraph.getNext();
                        afterParagraph.unlink();
                        definitionList.appendChild(afterParagraph);
                        afterParagraph = next;
                    }
                }
                definitionList.appendChild((Node)definitionItem);
                definitionList.takeChildren((Node)trailingBlankLines);
                if (hadPreviousList) {
                    DefinitionList previousList = (DefinitionList)paragraphPreviousNonBlank;
                    previousList.takeChildren((Node)definitionList);
                    for (Node node : definitionList.getChildren()) {
                        node.unlink();
                        previousList.appendChild(node);
                        state.blockAddedWithChildren((Block)node);
                    }
                    previousList.setCharsFromContent();
                } else {
                    if (paragraphPreviousNonBlank != null) {
                        paragraphPrevious.insertAfter((Node)definitionList);
                    } else if (paragraphParent.getFirstChild() != null) {
                        paragraphParent.getFirstChild().insertBefore((Node)definitionList);
                    } else {
                        paragraphParent.appendChild((Node)definitionList);
                    }
                    definitionList.setCharsFromContent();
                    state.blockAddedWithChildren((Block)definitionList);
                }
            } else if (previous instanceof DefinitionList) {
                DefinitionList previousList = (DefinitionList)previous;
                definitionItem.unlink();
                previousList.appendChild((Node)definitionItem);
                previousList.takeChildren((Node)trailingBlankLines);
                previousList.setCharsFromContent();
            }
        }
    }

    public static class Factory
    implements BlockPreProcessorFactory {
        public Set<Class<? extends Block>> getBlockTypes() {
            HashSet<Class<? extends Block>> set = new HashSet<Class<? extends Block>>();
            set.add(DefinitionItem.class);
            return set;
        }

        public Set<Class<? extends BlockPreProcessorFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends BlockPreProcessorFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return true;
        }

        public BlockPreProcessor create(ParserState state) {
            return new DefinitionListItemBlockPreProcessor((DataHolder)state.getProperties());
        }
    }
}

