/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros.internal;

import com.vladsch.flexmark.ext.gitlab.GitLabBlockQuote;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabBlockQuoteParser;
import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacrosExtension;
import com.vladsch.flexmark.ext.macros.internal.MacroDefinitionRepository;
import com.vladsch.flexmark.ext.macros.internal.MacrosOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacroDefinitionBlockParser
extends AbstractBlockParser {
    static Pattern MACRO_BLOCK_START = Pattern.compile(">>>([\\w_-]+)(\\s*$)");
    static Pattern MACRO_BLOCK_START_INTELLIJ = Pattern.compile(">>>([\u001f\\w_-]+)(\\s*$)");
    static Pattern MACRO_BLOCK_END = Pattern.compile("<<<(\\s*$)");
    private final MacroDefinitionBlock block = new MacroDefinitionBlock();
    private BlockContent content = new BlockContent();
    private final MacrosOptions options;
    private boolean hadClose = false;

    MacroDefinitionBlockParser(DataHolder options, BasedSequence openMarker, BasedSequence name, BasedSequence openTrailing) {
        this.options = new MacrosOptions(options);
        this.block.setOpeningMarker(openMarker);
        this.block.setName(name);
        this.block.setOpeningTrailing(openTrailing);
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        if (this.hadClose) {
            return BlockContinue.none();
        }
        int index = state.getIndex();
        BasedSequence line = state.getLineWithEOL();
        Matcher matcher = MACRO_BLOCK_END.matcher((CharSequence)line);
        if (!matcher.matches()) {
            return BlockContinue.atIndex((int)index);
        }
        Node lastChild = this.block.getLastChild();
        if (lastChild instanceof GitLabBlockQuote && ((GitLabBlockQuote)lastChild).getClosingMarker().isEmpty()) {
            return BlockContinue.atIndex((int)index);
        }
        this.hadClose = true;
        this.block.setClosingMarker((BasedSequence)state.getLine().subSequence(index, index + 3));
        this.block.setClosingTrailing((BasedSequence)state.getLineWithEOL().subSequence(matcher.start(1), matcher.end(1)));
        return BlockContinue.atIndex((int)state.getLineEndIndex());
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    public void closeBlock(ParserState state) {
        this.block.setContent(this.content);
        this.block.setCharsFromContent();
        this.content = null;
        this.block.setCharsFromContent();
        MacroDefinitionRepository macrosRepository = (MacroDefinitionRepository)((Object)state.getProperties().get(MacrosExtension.MACRO_DEFINITIONS));
        macrosRepository.put(macrosRepository.normalizeKey((CharSequence)this.block.getName()), (Object)this.block);
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final MacrosOptions options;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new MacrosOptions(options);
        }

        boolean haveBlockQuoteParser(ParserState state) {
            List parsers = state.getActiveBlockParsers();
            int i = parsers.size();
            while (i-- > 0) {
                if (!(parsers.get(i) instanceof MacroDefinitionBlockParser)) continue;
                return true;
            }
            return false;
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence line;
            Matcher matcher;
            if (state.getIndex() == 0 && !this.haveBlockQuoteParser(state) && (matcher = (state.getParsing().intellijDummyIdentifier ? MACRO_BLOCK_START_INTELLIJ : MACRO_BLOCK_START).matcher((CharSequence)(line = state.getLineWithEOL()))).matches()) {
                return BlockStart.of((BlockParser[])new BlockParser[]{new MacroDefinitionBlockParser((DataHolder)state.getProperties(), (BasedSequence)line.subSequence(0, 3), (BasedSequence)line.subSequence(matcher.start(1), matcher.end(1)), (BasedSequence)line.subSequence(matcher.start(2), matcher.end(1)))}).atIndex(state.getLineEndIndex());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(GitLabBlockQuoteParser.Factory.class));
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory apply(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

