/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitor;
import com.vladsch.flexmark.ast.VisitHandler;
import com.vladsch.flexmark.ast.Visitor;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.List;

public class TableExtractingVisitor {
    private final TableFormatOptions options;
    private NodeVisitor myVisitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(TableBlock.class, (Visitor)new Visitor<TableBlock>(){

        public void visit(TableBlock node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler(TableHead.class, (Visitor)new Visitor<TableHead>(){

        public void visit(TableHead node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler(TableSeparator.class, (Visitor)new Visitor<TableSeparator>(){

        public void visit(TableSeparator node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler(TableBody.class, (Visitor)new Visitor<TableBody>(){

        public void visit(TableBody node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler(TableRow.class, (Visitor)new Visitor<TableRow>(){

        public void visit(TableRow node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler(TableCell.class, (Visitor)new Visitor<TableCell>(){

        public void visit(TableCell node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler(TableCaption.class, (Visitor)new Visitor<TableCaption>(){

        public void visit(TableCaption node) {
            TableExtractingVisitor.this.visit(node);
        }
    })});
    private MarkdownTable myTable;
    private final List<MarkdownTable> myTables;

    public TableExtractingVisitor(DataHolder options) {
        this.options = new TableFormatOptions(options);
        this.myTables = new ArrayList<MarkdownTable>();
    }

    public MarkdownTable[] getTables(Node node) {
        this.myTable = null;
        this.myVisitor.visit(node);
        return this.myTables.toArray(new MarkdownTable[0]);
    }

    private void visit(TableBlock node) {
        this.myTable = new MarkdownTable(this.options);
        this.myVisitor.visitChildren((Node)node);
        this.myTables.add(this.myTable);
        this.myTable = null;
    }

    private void visit(TableHead node) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(true);
        this.myVisitor.visitChildren((Node)node);
    }

    private void visit(TableSeparator node) {
        this.myTable.setSeparator(true);
        this.myVisitor.visitChildren((Node)node);
    }

    private void visit(TableBody node) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(false);
        this.myVisitor.visitChildren((Node)node);
    }

    private void visit(TableRow node) {
        this.myVisitor.visitChildren((Node)node);
        if (!this.myTable.isSeparator()) {
            this.myTable.nextRow();
        }
    }

    private void visit(TableCaption node) {
        this.myTable.setCaptionWithMarkers((CharSequence)node.getOpeningMarker(), (CharSequence)node.getText(), (CharSequence)node.getClosingMarker());
    }

    private void visit(TableCell node) {
        BasedSequence text = node.getText();
        if (this.options.trimCellWhitespace) {
            text = text.isBlank() && !text.isEmpty() ? text.subSequence(0, 1) : text.trim();
        }
        this.myTable.addCell(new com.vladsch.flexmark.util.format.TableCell((CharSequence)node.getOpeningMarker(), (CharSequence)text, (CharSequence)node.getClosingMarker(), 1, node.getSpan(), node.getAlignment() == null ? CellAlignment.NONE : node.getAlignment().cellAlignment()));
    }
}

