/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.interceptor;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.volcengine.ApiClient;
import com.volcengine.ApiException;
import com.volcengine.Pair;
import com.volcengine.ProgressRequestBody;
import com.volcengine.interceptor.InitInterceptorContext;
import com.volcengine.interceptor.RequestInterceptorContext;
import com.volcengine.interceptor.ResponseInterceptorContext;
import com.volcengine.sign.ServiceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterceptorContext
extends Call {
    private ApiClient apiClient;
    public InitInterceptorContext initInterceptorContext = new InitInterceptorContext();
    public RequestInterceptorContext requestContext = new RequestInterceptorContext();
    public ResponseInterceptorContext responseContext = new ResponseInterceptorContext();

    public InterceptorContext(OkHttpClient client, Request originalRequest) {
        super(client, originalRequest);
    }

    public InitInterceptorContext getInitInterceptorContext() {
        return this.initInterceptorContext;
    }

    public void setInitInterceptorContext(InitInterceptorContext initInterceptorContext) {
        this.initInterceptorContext = initInterceptorContext;
    }

    public ResponseInterceptorContext getResponseContext() {
        return this.responseContext;
    }

    public void setResponseContext(ResponseInterceptorContext responseContext) {
        this.responseContext = responseContext;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RequestInterceptorContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestInterceptorContext requestContext) {
        this.requestContext = requestContext;
    }

    public void buildRequest() throws ApiException {
        Object reqBody;
        String path = this.getInitInterceptorContext().getPath();
        String method = this.getInitInterceptorContext().getMethod();
        List<Pair> queryParams = this.copy(this.getInitInterceptorContext().getQueryParams());
        List<Pair> collectionQueryParams = this.copy(this.getInitInterceptorContext().getCollectionQueryParams());
        Object body = this.getInitInterceptorContext().getBody();
        Map<String, String> headerParams = this.copy(this.getInitInterceptorContext().getHeaderParams());
        Map<String, Object> formParams = this.copy(this.getInitInterceptorContext().getFormParams());
        String[] authNames = this.getInitInterceptorContext().getAuthNames();
        boolean isCommon = this.getInitInterceptorContext().isCommon();
        ProgressRequestBody.ProgressRequestListener progressRequestListener = this.getInitInterceptorContext().getProgressRequestListener();
        this.apiClient.getDefaultContentType(headerParams);
        ServiceInfo serviceInfo = this.apiClient.addPairAndGetServiceInfo(path, queryParams, headerParams);
        method = serviceInfo.getMethod().toUpperCase();
        String contentType = headerParams.get("Content-Type");
        StringBuilder bodyBuilder = new StringBuilder();
        FormEncodingBuilder formBuilder = new FormEncodingBuilder();
        try {
            this.apiClient.buildSimpleRequest(body, queryParams, headerParams, bodyBuilder, formBuilder, "", isCommon);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        if (!HttpMethod.permitsRequestBody((String)method)) {
            reqBody = null;
        } else if ("application/x-www-form-urlencoded".equals(contentType)) {
            reqBody = formBuilder.build();
            queryParams.clear();
            this.apiClient.updateQueryParams(queryParams, path.split("/"));
        } else if ("multipart/form-data".equals(contentType)) {
            reqBody = this.apiClient.buildRequestBodyMultipart(formParams);
            queryParams.clear();
            this.apiClient.updateQueryParams(queryParams, path.split("/"));
        } else if (body == null) {
            reqBody = "DELETE".equals(method) ? null : RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)"");
            queryParams.clear();
            this.apiClient.updateQueryParams(queryParams, path.split("/"));
        } else {
            reqBody = this.apiClient.serialize(body, contentType);
            queryParams.clear();
            this.apiClient.updateQueryParams(queryParams, path.split("/"));
        }
        this.apiClient.processDefaultHeader(headerParams);
        this.getRequestContext().setQueryParams(queryParams);
        this.getRequestContext().setRequestBody((RequestBody)reqBody);
        this.getRequestContext().setProgressRequestListener(progressRequestListener);
        this.getRequestContext().setAuthNames(authNames);
        this.getRequestContext().setHeaderParams(headerParams);
        this.getRequestContext().setCommon(isCommon);
        this.getRequestContext().setPath("/");
        this.getRequestContext().setMethod(method);
        this.getRequestContext().setServiceInfo(serviceInfo);
    }

    public List<Pair> copy(List<Pair> list) {
        ArrayList<Pair> resultList = new ArrayList<Pair>();
        if (list != null) {
            for (Pair p : list) {
                Pair cur = new Pair(p.getName(), p.getValue());
                resultList.add(cur);
            }
        }
        return resultList;
    }

    public <T> Map<String, T> copy(Map<String, T> map) {
        HashMap<String, T> resultMap = new HashMap<String, T>();
        if (map != null) {
            for (Map.Entry<String, T> entry : map.entrySet()) {
                String key = entry.getKey();
                T value = entry.getValue();
                resultMap.put(key, value);
            }
        }
        return resultMap;
    }
}

