/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.date;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.wdullaer.materialdatetimepicker.Utils;
import com.wdullaer.materialdatetimepicker.date.DatePickerController;
import com.wdullaer.materialdatetimepicker.date.DateRangeLimiter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.TreeSet;

class DefaultDateRangeLimiter
implements DateRangeLimiter {
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private transient DatePickerController mController;
    private int mMinYear = 1900;
    private int mMaxYear = 2100;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private TreeSet<Calendar> selectableDays = new TreeSet();
    private HashSet<Calendar> disabledDays = new HashSet();
    public static final Parcelable.Creator<DefaultDateRangeLimiter> CREATOR = new Parcelable.Creator<DefaultDateRangeLimiter>(){

        public DefaultDateRangeLimiter createFromParcel(Parcel in) {
            return new DefaultDateRangeLimiter(in);
        }

        public DefaultDateRangeLimiter[] newArray(int size) {
            return new DefaultDateRangeLimiter[size];
        }
    };

    DefaultDateRangeLimiter() {
    }

    public DefaultDateRangeLimiter(Parcel in) {
        this.mMinYear = in.readInt();
        this.mMaxYear = in.readInt();
        this.mMinDate = (Calendar)in.readSerializable();
        this.mMaxDate = (Calendar)in.readSerializable();
        this.selectableDays = (TreeSet)in.readSerializable();
        this.disabledDays = (HashSet)in.readSerializable();
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mMinYear);
        out.writeInt(this.mMaxYear);
        out.writeSerializable((Serializable)this.mMinDate);
        out.writeSerializable((Serializable)this.mMaxDate);
        out.writeSerializable(this.selectableDays);
        out.writeSerializable(this.disabledDays);
    }

    public int describeContents() {
        return 0;
    }

    void setSelectableDays(@NonNull Calendar[] days) {
        for (Calendar selectableDay : days) {
            Utils.trimToMidnight(selectableDay);
        }
        this.selectableDays.addAll(Arrays.asList(days));
    }

    void setDisabledDays(@NonNull Calendar[] days) {
        for (Calendar disabledDay : days) {
            Utils.trimToMidnight(disabledDay);
        }
        this.disabledDays.addAll(Arrays.asList(days));
    }

    void setMinDate(@NonNull Calendar calendar) {
        this.mMinDate = Utils.trimToMidnight((Calendar)calendar.clone());
    }

    void setMaxDate(@NonNull Calendar calendar) {
        this.mMaxDate = Utils.trimToMidnight((Calendar)calendar.clone());
    }

    void setController(@NonNull DatePickerController controller) {
        this.mController = controller;
    }

    void setYearRange(int startYear, int endYear) {
        if (endYear < startYear) {
            throw new IllegalArgumentException("Year end must be larger than or equal to year start");
        }
        this.mMinYear = startYear;
        this.mMaxYear = endYear;
    }

    @Nullable
    Calendar getMinDate() {
        return this.mMinDate;
    }

    @Nullable
    Calendar getMaxDate() {
        return this.mMaxDate;
    }

    @Nullable
    Calendar[] getSelectableDays() {
        return this.selectableDays.isEmpty() ? null : this.selectableDays.toArray(new Calendar[0]);
    }

    @Nullable
    Calendar[] getDisabledDays() {
        return this.disabledDays.isEmpty() ? null : this.disabledDays.toArray(new Calendar[0]);
    }

    @Override
    public int getMinYear() {
        if (!this.selectableDays.isEmpty()) {
            return this.selectableDays.first().get(1);
        }
        return this.mMinDate != null && this.mMinDate.get(1) > this.mMinYear ? this.mMinDate.get(1) : this.mMinYear;
    }

    @Override
    public int getMaxYear() {
        if (!this.selectableDays.isEmpty()) {
            return this.selectableDays.last().get(1);
        }
        return this.mMaxDate != null && this.mMaxDate.get(1) < this.mMaxYear ? this.mMaxDate.get(1) : this.mMaxYear;
    }

    @Override
    @NonNull
    public Calendar getStartDate() {
        if (!this.selectableDays.isEmpty()) {
            return (Calendar)this.selectableDays.first().clone();
        }
        if (this.mMinDate != null) {
            return (Calendar)this.mMinDate.clone();
        }
        TimeZone timeZone = this.mController == null ? TimeZone.getDefault() : this.mController.getTimeZone();
        Calendar output = Calendar.getInstance(timeZone);
        output.set(1, this.mMinYear);
        output.set(5, 1);
        output.set(2, 0);
        return output;
    }

    @Override
    @NonNull
    public Calendar getEndDate() {
        if (!this.selectableDays.isEmpty()) {
            return (Calendar)this.selectableDays.last().clone();
        }
        if (this.mMaxDate != null) {
            return (Calendar)this.mMaxDate.clone();
        }
        TimeZone timeZone = this.mController == null ? TimeZone.getDefault() : this.mController.getTimeZone();
        Calendar output = Calendar.getInstance(timeZone);
        output.set(1, this.mMaxYear);
        output.set(5, 31);
        output.set(2, 11);
        return output;
    }

    @Override
    public boolean isOutOfRange(int year, int month, int day) {
        Calendar date = Calendar.getInstance();
        date.set(1, year);
        date.set(2, month);
        date.set(5, day);
        return this.isOutOfRange(date);
    }

    private boolean isOutOfRange(@NonNull Calendar calendar) {
        Utils.trimToMidnight(calendar);
        return this.isDisabled(calendar) || !this.isSelectable(calendar);
    }

    private boolean isDisabled(@NonNull Calendar c) {
        return this.disabledDays.contains(Utils.trimToMidnight(c)) || this.isBeforeMin(c) || this.isAfterMax(c);
    }

    private boolean isSelectable(@NonNull Calendar c) {
        return this.selectableDays.isEmpty() || this.selectableDays.contains(Utils.trimToMidnight(c));
    }

    private boolean isBeforeMin(@NonNull Calendar calendar) {
        return this.mMinDate != null && calendar.before(this.mMinDate) || calendar.get(1) < this.mMinYear;
    }

    private boolean isAfterMax(@NonNull Calendar calendar) {
        return this.mMaxDate != null && calendar.after(this.mMaxDate) || calendar.get(1) > this.mMaxYear;
    }

    @Override
    @NonNull
    public Calendar setToNearestDate(@NonNull Calendar calendar) {
        if (!this.selectableDays.isEmpty()) {
            Calendar newCalendar = null;
            Calendar higher = this.selectableDays.ceiling(calendar);
            Calendar lower = this.selectableDays.lower(calendar);
            if (higher == null && lower != null) {
                newCalendar = lower;
            } else if (lower == null && higher != null) {
                newCalendar = higher;
            }
            if (newCalendar != null || higher == null) {
                newCalendar = newCalendar == null ? calendar : newCalendar;
                TimeZone timeZone = this.mController == null ? TimeZone.getDefault() : this.mController.getTimeZone();
                newCalendar.setTimeZone(timeZone);
                return (Calendar)newCalendar.clone();
            }
            long highDistance = Math.abs(higher.getTimeInMillis() - calendar.getTimeInMillis());
            long lowDistance = Math.abs(calendar.getTimeInMillis() - lower.getTimeInMillis());
            if (lowDistance < highDistance) {
                return (Calendar)lower.clone();
            }
            return (Calendar)higher.clone();
        }
        if (!this.disabledDays.isEmpty()) {
            Calendar backwardDate;
            Calendar forwardDate = this.isBeforeMin(calendar) ? this.getStartDate() : (Calendar)calendar.clone();
            Calendar calendar2 = backwardDate = this.isAfterMax(calendar) ? this.getEndDate() : (Calendar)calendar.clone();
            while (this.isDisabled(forwardDate) && this.isDisabled(backwardDate)) {
                forwardDate.add(5, 1);
                backwardDate.add(5, -1);
            }
            if (!this.isDisabled(backwardDate)) {
                return backwardDate;
            }
            if (!this.isDisabled(forwardDate)) {
                return forwardDate;
            }
        }
        if (this.mMinDate != null && this.isBeforeMin(calendar)) {
            return (Calendar)this.mMinDate.clone();
        }
        if (this.mMaxDate != null && this.isAfterMax(calendar)) {
            return (Calendar)this.mMaxDate.clone();
        }
        return calendar;
    }
}

