/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.mockmaker;

import java.util.List;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.mockmaker.MockMakerLoader;
import org.powermock.configuration.GlobalConfiguration;

public class PowerMockMaker
implements MockMaker {
    private final MockMaker mockMaker = new MockMakerLoader().load(GlobalConfiguration.mockitoConfiguration());

    @Override
    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        return this.mockMaker.createMock(settings, handler);
    }

    @Override
    public MockHandler getHandler(Object mock) {
        if (mock instanceof Class) {
            return new PowerMockInternalMockHandler((Class)mock);
        }
        return this.mockMaker.getHandler(mock);
    }

    @Override
    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        this.mockMaker.resetMock(mock, newHandler, settings);
    }

    @Override
    public MockMaker.TypeMockability isTypeMockable(Class<?> type2) {
        return this.mockMaker.isTypeMockable(type2);
    }

    MockMaker getMockMaker() {
        return this.mockMaker;
    }

    private static class PowerMockInternalMockHandler
    implements InternalMockHandler<Class> {
        private final Class<?> mock;

        private PowerMockInternalMockHandler(Class<?> mock) {
            this.mock = mock;
        }

        @Override
        public MockCreationSettings<Class> getMockSettings() {
            MockSettingsImpl<Class> mockSettings = new MockSettingsImpl<Class>();
            mockSettings.setMockName(new MockNameImpl(this.mock.getName()));
            mockSettings.setTypeToMock(this.mock);
            return mockSettings;
        }

        @Override
        public void setAnswersForStubbing(List<Answer<?>> list) {
        }

        @Override
        public InvocationContainer getInvocationContainer() {
            return null;
        }

        @Override
        public Object handle(Invocation invocation) throws Throwable {
            return null;
        }
    }
}

