/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ObjectAssertFactory;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.VisibleForTesting;

public class IterableAssert<ELEMENT>
extends FactoryBasedNavigableIterableAssert<IterableAssert<ELEMENT>, Iterable<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> {
    public IterableAssert(Iterable<? extends ELEMENT> actual) {
        super(actual, IterableAssert.class, new ObjectAssertFactory());
    }

    public IterableAssert(Iterator<? extends ELEMENT> actual) {
        this(IterableAssert.toLazyIterable(actual));
    }

    @Override
    public IterableAssert<ELEMENT> isEqualTo(Object expected) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertEqual(this.info, this.asLazyIterable().iterator, expected);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isEqualTo(expected);
    }

    @Override
    public IterableAssert<ELEMENT> isInstanceOf(Class<?> type2) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsInstanceOf(this.info, this.asLazyIterable().iterator, type2);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isInstanceOf((Class)type2);
    }

    @Override
    public IterableAssert<ELEMENT> isInstanceOfAny(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsInstanceOfAny(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isInstanceOfAny((Class[])types);
    }

    @Override
    public IterableAssert<ELEMENT> isOfAnyClassIn(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsOfAnyClassIn(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isOfAnyClassIn((Class[])types);
    }

    @Override
    public IterableAssert<ELEMENT> isExactlyInstanceOf(Class<?> type2) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsExactlyInstanceOf(this.info, this.asLazyIterable().iterator, type2);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isExactlyInstanceOf((Class)type2);
    }

    @Override
    public IterableAssert<ELEMENT> isNotInstanceOf(Class<?> type2) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotInstanceOf(this.info, this.asLazyIterable().iterator, type2);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotInstanceOf((Class)type2);
    }

    @Override
    public IterableAssert<ELEMENT> isNotInstanceOfAny(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotInstanceOfAny(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotInstanceOfAny((Class[])types);
    }

    @Override
    public IterableAssert<ELEMENT> isNotOfAnyClassIn(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotOfAnyClassIn(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotOfAnyClassIn((Class[])types);
    }

    @Override
    public IterableAssert<ELEMENT> isNotExactlyInstanceOf(Class<?> type2) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotExactlyInstanceOf(this.info, this.asLazyIterable().iterator, type2);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotExactlyInstanceOf((Class)type2);
    }

    @Override
    public IterableAssert<ELEMENT> isSameAs(Object expected) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertSame(this.info, this.asLazyIterable().iterator, expected);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isSameAs(expected);
    }

    @Override
    public IterableAssert<ELEMENT> isNotSameAs(Object expected) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertNotSame(this.info, this.asLazyIterable().iterator, expected);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotSameAs(expected);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> startsWith(ELEMENT ... sequence) {
        if (!(this.actual instanceof LazyIterable)) {
            return (IterableAssert)super.startsWith((Object[])sequence);
        }
        this.objects.assertNotNull(this.info, this.actual);
        CommonValidations.checkIsNotNull(sequence);
        Iterator iterator = ((LazyIterable)this.actual).iterator;
        if (sequence.length == 0 && iterator.hasNext()) {
            throw new AssertionError((Object)"actual is not empty");
        }
        int i = 0;
        while (iterator.hasNext() && i < sequence.length) {
            if (this.iterables.getComparisonStrategy().areEqual(iterator.next(), sequence[i++])) continue;
            throw this.actualDoesNotStartWithSequence(this.info, (Iterable)this.actual, sequence);
        }
        if (sequence.length > i) {
            throw this.actualDoesNotStartWithSequence(this.info, (Iterable)this.actual, sequence);
        }
        return (IterableAssert)this.myself;
    }

    private AssertionError actualDoesNotStartWithSequence(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        return Failures.instance().failure(info, ShouldStartWith.shouldStartWith(actual, sequence, this.iterables.getComparisonStrategy()));
    }

    private LazyIterable asLazyIterable() {
        return (LazyIterable)this.actual;
    }

    private static <T> Iterable<T> toIterable(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> contains(ELEMENT ... values) {
        return (IterableAssert)super.contains((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsOnly(ELEMENT ... values) {
        return (IterableAssert)super.containsOnly((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsOnlyOnce(ELEMENT ... values) {
        return (IterableAssert)super.containsOnlyOnce((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsExactly(ELEMENT ... values) {
        return (IterableAssert)super.containsExactly((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsExactlyInAnyOrder(ELEMENT ... values) {
        return (IterableAssert)super.containsExactlyInAnyOrder((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> isSubsetOf(ELEMENT ... values) {
        return (IterableAssert)super.isSubsetOf((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsSequence(ELEMENT ... sequence) {
        return (IterableAssert)super.containsSequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> doesNotContainSequence(ELEMENT ... sequence) {
        return (IterableAssert)super.doesNotContainSequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsSubsequence(ELEMENT ... sequence) {
        return (IterableAssert)super.containsSubsequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> doesNotContainSubsequence(ELEMENT ... sequence) {
        return (IterableAssert)super.doesNotContainSubsequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> doesNotContain(ELEMENT ... values) {
        return (IterableAssert)super.doesNotContain((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> endsWith(ELEMENT ... sequence) {
        return (IterableAssert)super.endsWith((Object[])sequence);
    }

    @VisibleForTesting
    static class LazyIterable<T>
    extends AbstractCollection<T> {
        private Iterator<T> iterator;
        private Iterable<T> iterable;

        public LazyIterable(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.iterable == null) {
                this.iterable = IterableAssert.toIterable(this.iterator);
            }
            return this.iterable.iterator();
        }

        @Override
        public int size() {
            int size = 0;
            Iterator<T> localIterator = this.iterator();
            while (localIterator.hasNext()) {
                localIterator.next();
                ++size;
            }
            return size;
        }
    }
}

