/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import org.mockito.internal.util.reflection.AccessibilityChanger;

public class FieldSetter {
    private FieldSetter() {
    }

    public static void setField(Object target, Field field2, Object value) {
        AccessibilityChanger changer = new AccessibilityChanger();
        changer.enableAccess(field2);
        try {
            field2.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access not authorized on field '" + field2 + "' of object '" + target + "' with value: '" + value + "'", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Wrong argument on field '" + field2 + "' of object '" + target + "' with value: '" + value + "', \n" + "reason : " + e.getMessage(), e);
        }
        changer.safelyDisableAccess(field2);
    }
}

