/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import java.lang.reflect.Constructor;
import org.mockito.stubbing.OngoingStubbing;
import org.powermock.api.mockito.expectation.ConstructorExpectationSetup;
import org.powermock.api.mockito.expectation.WithExpectedArguments;
import org.powermock.api.mockito.internal.expectation.DelegatingToConstructorsOngoingStubbing;
import org.powermock.api.mockito.internal.mockcreation.MockCreator;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.internal.WhiteboxImpl;
import org.powermock.tests.utils.ArrayMerger;
import org.powermock.tests.utils.impl.ArrayMergerImpl;

public abstract class AbstractConstructorExpectationSetup<T>
implements ConstructorExpectationSetup<T> {
    protected final Class<T> mockType;
    protected final ArrayMerger arrayMerger = new ArrayMergerImpl();
    private Class<?>[] parameterTypes = null;

    public AbstractConstructorExpectationSetup(Class<T> mockType) {
        this.mockType = mockType;
    }

    private <T> OngoingStubbing<T> createNewSubstituteMock(Class<T> type2, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        if (type2 == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Class<?> unmockedType = WhiteboxImpl.getOriginalUnmockedType(type2);
        if (parameterTypes == null) {
            WhiteboxImpl.findUniqueConstructorOrThrowException(type2, arguments);
        } else {
            WhiteboxImpl.getConstructor(unmockedType, parameterTypes);
        }
        NewInvocationControl<Object> newInvocationControl = MockRepository.getNewInstanceControl(unmockedType);
        if (newInvocationControl == null) {
            InvocationSubstitute mock = this.getMockCreator().createMock(InvocationSubstitute.class, false, false, null, null, null);
            newInvocationControl = this.createNewInvocationControl(mock);
            MockRepository.putNewInstanceControl(type2, newInvocationControl);
            MockRepository.addObjectsToAutomaticallyReplayAndVerify(WhiteboxImpl.getOriginalUnmockedType(type2));
        }
        return (OngoingStubbing)newInvocationControl.expectSubstitutionLogic(arguments);
    }

    abstract MockCreator getMockCreator();

    abstract <T> NewInvocationControl<OngoingStubbing<T>> createNewInvocationControl(InvocationSubstitute<T> var1);

    void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    OngoingStubbing<T> withArguments(Object[] additionalArguments) throws Exception {
        return this.createNewSubstituteMock(this.mockType, this.parameterTypes, additionalArguments);
    }

    @Override
    public OngoingStubbing<T> withArguments(Object firstArgument, Object ... additionalArguments) throws Exception {
        return this.createNewSubstituteMock(this.mockType, this.parameterTypes, this.arrayMerger.mergeArrays(Object.class, {firstArgument}, additionalArguments));
    }

    @Override
    public OngoingStubbing<T> withAnyArguments() throws Exception {
        if (this.mockType == null) {
            throw new IllegalArgumentException("Class to expected cannot be null");
        }
        Class<?> unmockedType = WhiteboxImpl.getOriginalUnmockedType(this.mockType);
        Constructor<?>[] allConstructors = WhiteboxImpl.getAllConstructors(unmockedType);
        Constructor<?> constructor = allConstructors[0];
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] paramArgs = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> paramType = parameterTypes[i];
            paramArgs[i] = this.createParamArgMatcher(paramType);
        }
        OngoingStubbing<T> ongoingStubbing = this.createNewSubstituteMock(this.mockType, parameterTypes, paramArgs);
        Constructor[] otherCtors = new Constructor[allConstructors.length - 1];
        System.arraycopy(allConstructors, 1, otherCtors, 0, allConstructors.length - 1);
        return new DelegatingToConstructorsOngoingStubbing<T>(otherCtors, ongoingStubbing);
    }

    abstract Object createParamArgMatcher(Class<?> var1);

    @Override
    public OngoingStubbing<T> withNoArguments() throws Exception {
        return this.createNewSubstituteMock(this.mockType, this.parameterTypes, new Object[0]);
    }

    @Override
    public WithExpectedArguments<T> withParameterTypes(Class<?> parameterType, Class<?> ... additionalParameterTypes) {
        this.parameterTypes = this.arrayMerger.mergeArrays(Class.class, {parameterType}, additionalParameterTypes);
        return this;
    }
}

