/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import java.lang.reflect.Method;
import java.util.List;
import org.mockito.internal.stubbing.StubberImpl;
import org.mockito.invocation.MockHandler;
import org.powermock.api.mockito.expectation.PowerMockitoStubber;
import org.powermock.api.mockito.expectation.PrivatelyExpectedArguments;
import org.powermock.api.mockito.internal.expectation.DefaultPrivatelyExpectedArguments;
import org.powermock.api.mockito.internal.invocation.MockitoMethodInvocationControl;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;

public class PowerMockitoStubberImpl
extends StubberImpl
implements PowerMockitoStubber {
    @Override
    public void when(Class<?> classMock) {
        MockitoMethodInvocationControl invocationControl = (MockitoMethodInvocationControl)MockRepository.getStaticMethodInvocationControl(classMock);
        this.addAnswersForStubbing(invocationControl);
    }

    @Override
    public <T> T when(T instanceMock) {
        T returnValue;
        MockitoMethodInvocationControl invocationControl = (MockitoMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl(instanceMock);
        if (invocationControl == null) {
            returnValue = super.when(instanceMock);
        } else {
            this.addAnswersForStubbing(invocationControl);
            returnValue = instanceMock;
        }
        return returnValue;
    }

    private void addAnswersForStubbing(MockitoMethodInvocationControl invocationControl) {
        MockHandler mockHandler = invocationControl.getMockHandler();
        List list = Whitebox.getInternalState((Object)this, List.class);
        try {
            Whitebox.invokeMethod((Object)mockHandler, "setAnswersForStubbing", list);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> PrivatelyExpectedArguments when(T mock, Method method) throws Exception {
        this.assertNotNull(mock, "mock");
        this.assertNotNull(method, "Method");
        this.prepareForStubbing(mock);
        return new DefaultPrivatelyExpectedArguments(mock, method);
    }

    @Override
    public <T> void when(T mock, Object ... arguments) throws Exception {
        this.assertNotNull(mock, "mock");
        this.prepareForStubbing(mock);
        Whitebox.invokeMethod(mock, arguments);
    }

    @Override
    public <T> void when(T mock, String methodToExpect, Object ... arguments) throws Exception {
        this.assertNotNull(mock, "mock");
        this.assertNotNull(methodToExpect, "methodToExpect");
        this.prepareForStubbing(mock);
        Whitebox.invokeMethod(mock, methodToExpect, arguments);
    }

    @Override
    public <T> void when(Class<T> classMock, Object ... arguments) throws Exception {
        this.assertNotNull(classMock, "classMock");
        this.when((T)classMock);
        Whitebox.invokeMethod(classMock, arguments);
    }

    @Override
    public <T> void when(Class<T> classMock, String methodToExpect, Object ... parameters) throws Exception {
        this.assertNotNull(classMock, "classMock");
        this.assertNotNull(methodToExpect, "methodToExpect");
        this.when((T)classMock);
        Whitebox.invokeMethod(classMock, methodToExpect, parameters);
    }

    @Override
    public <T> PrivatelyExpectedArguments when(Class<T> classMock, Method method) throws Exception {
        this.assertNotNull(classMock, "classMock");
        this.assertNotNull(method, "Method");
        this.when((T)classMock);
        return new DefaultPrivatelyExpectedArguments(classMock, method);
    }

    private void assertNotNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    private <T> void prepareForStubbing(T mock) {
        MockitoMethodInvocationControl invocationControl = (MockitoMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl(mock);
        this.addAnswersForStubbing(invocationControl);
    }
}

